package OpenGL;

use strict;
use warnings;

#  Copyright (c) 1998,1999 Kenneth Albanowski. All rights reserved.
#  Copyright (c) 2007 Bob Free. All rights reserved.
#  Copyright (c) 2009 Christopher Marshall. All rights reserved.
#  Copyright (c) 2015 Bob Free. All rights reserved.
#  Copyright (c) 2016 Chris Marshall. All rights reserved.
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.

use Exporter 'import';

use Carp;

our $VERSION = '0.7003';
our $BUILD_VERSION = our $XS_VERSION = $VERSION;
$VERSION =~ tr/_//d;

use OpenGL::V1;
use OpenGL::V2;
use OpenGL::V3;
use OpenGL::Const;
use OpenGL::Array qw(glpHasGPGPU);
use OpenGL::Matrix;
use OpenGL::GLX qw(:constants :functions _have_glp _have_glx glpcOpenWindow __had_dbuffer_hack glpReadTex);
use OpenGL::GLU qw(:constants :functions _have_glu);
use OpenGL::GLUT qw(:constants :functions _have_glut _have_freeglut glpHasGLUT);

our $gl_version;
our $glext_installed = {};

# Implemented extensions and their dependencies
our $glext_dependencies =
{
   GL_ARB_color_buffer_float=>'2.0', #39
   GL_ARB_depth_texture=>'1.1', #22
   GL_ARB_draw_buffers=>'1.3', #37
   GL_ARB_fragment_program=>'1.4;ARB_vertex_program', #27
   GL_ARB_fragment_program_shadow=>'1.4;ARB_fragment_program,ARB_shadow', #36
   GL_ARB_fragment_shader=>'1.4;ARB_shader_objects', #32
   GL_ARB_half_float_pixel=>'1.5', #40
   GL_ARB_multisample=>'1.0', #5
   GL_ARB_multitexture=>'1.1', # Moved to 1.2.1
   GL_ARB_pixel_buffer_object=>'1.5', #42
   GL_ARB_point_parameters=>'1.0', #14
   GL_ARB_point_sprite=>'1.4', #35
   GL_ARB_shading_language_100=>'1.4;ARB_shader_objects,ARB_fragment_shader,ARB_vertex_shader', #33
   GL_ARB_shader_objects=>'1.4', #30
   GL_ARB_shadow=>'1.1;ARB_depth_texture', #23
   GL_ARB_shadow_ambient=>'1.1;ARB_shadow,ARB_depth_texture', #23
   GL_ARB_texture_border_clamp=>'1.0', #13
   GL_ARB_texture_cube_map=>'1.0', #7
   GL_ARB_texture_env_add=>'1.0', #6
   GL_ARB_texture_env_combine=>'1.1;ARB_multitexture', #17
   GL_ARB_texture_env_dot3=>'1.1;ARB_multitexture,ARB_texture_env_combine', #19
   GL_ARB_texture_float=>'1.1', #41
   GL_ARB_texture_mirrored_repeat=>'1.0', #21
   GL_ARB_texture_non_power_of_two=>'1.4', #34
   GL_ARB_texture_rectangle=>'1.1', #38
   GL_ARB_vertex_buffer_object=>'1.4', #28
   GL_ARB_vertex_program=>'1.3', #26
   GL_ARB_vertex_shader=>'1.4;ARB_shader_objects', #31
   GL_ATI_texture_float=>'1.1', #280
   GL_ATI_texture_mirror_once=>'1.0;EXT_texture3D', #221
   GL_EXT_abgr=>'1.0', #1
   GL_EXT_bgra=>'1.0', #129
   GL_EXT_blend_color=>'1.0', #2
   GL_EXT_blend_subtract=>'1.0', #38
   GL_EXT_Cg_shader=>'1.0;ARB_shader_objects', #???
   GL_EXT_copy_texture=>'1.0', #10
   GL_EXT_framebuffer_object=>'1.1', #310
   GL_EXT_packed_pixels=>'1.0', #23
   GL_EXT_pixel_buffer_object=>'1.0', #???
   GL_EXT_rescale_normal=>'1.0', #27
   GL_EXT_separate_specular_color=>'1.0', #144
   GL_EXT_shadow_funcs=>'1.1;ARB_depth_texture,ARB_shadow', #267
   GL_EXT_stencil_wrap=>'1.0', #176
   GL_EXT_subtexture=>'1.0', #9
   GL_EXT_texture=>'1.0', #4
   GL_EXT_texture3D=>'1.1;EXT_abgr', #6
   GL_EXT_texture_cube_map=>'1.0', #6
   GL_EXT_texture_env_combine=>'1.0', #158
   GL_EXT_texture_env_dot3=>'1.0;EXT_texture_env_combine', #220
   GL_EXT_texture_filter_anisotropic=>'1.0', #187
   GL_EXT_texture_lod_bias=>'1.0', #186
   GL_EXT_texture_mirror_clamp=>'1.0', #298
   GL_EXT_vertex_array=>'1.0', #30
   GL_HP_occlusion_test=>'1.0', #137
   GL_IBM_rasterpos_clip=>'1.0', #110
   GL_NV_blend_square=>'1.0', #194
   GL_NV_copy_depth_to_color=>'1.0;NV_packed_depth_stencil', #243
   GL_NV_depth_clamp=>'1.0', #260
   GL_NV_fog_distance=>'1.0', #192
   GL_NV_fragment_program_option=>'1.0;ARB_fragment_program', #303
   GL_NV_fragment_program2=>'1.0;ARB_fragment_program,NV_fragment_program_option', #304
   GL_NV_light_max_exponent=>'1.0', #189
   GL_NV_multisample_filter_hint=>'1.0;ARB_multisample', #259
   GL_NV_packed_depth_stencil=>'1.0', #226
   GL_NV_texgen_reflection=>'1.0', #179
   GL_NV_texture_compression_vtc=>'1.0;ARB_texture_compression,EXT_texture_compression_s3tc,ARB_texture_non_power_of_two', #228
   GL_NV_texture_expand_normal=>'1.1', #286
   GL_NV_texture_rectangle=>'1.0', #229
   GL_NV_texture_shader=>'1.0;ARB_multitexture,ARB_texture_cube_map', #230
   GL_NV_texture_shader2=>'1.0;NV_texture_shader', #231
   GL_NV_texture_shader3=>'1.0;NV_texture_shader2', #265
   GL_NV_vertex_program1_1=>'1.0;NV_vertex_program', #266
   GL_NV_vertex_program2=>'1.0;NV_vertex_program', #287
   GL_NV_vertex_program2_option=>'1.0;ARB_vertex_program', #305
   GL_NV_vertex_program3=>'1.0;ARB_vertex_program,NV_vertex_program2_option', #306
   GL_S3_s3tc=>'1.1', #276
   GL_SGIS_generate_mipmap=>'1.1', #32
   GL_SGIS_texture_lod=>'1.1', #24
   GL_SGIX_depth_texture=>'1.1', #63
   GL_SGIX_shadow=>'1.0', #34
   GL_SUN_slice_accum=>'1.0' #258
};

my @gl_func_common = qw(
   glAccum
   glAlphaFunc
   glBegin
   glBlendColorEXT
   glBlendEquationEXT
   glBlendFunc
   glCallList
   glClear
   glClearAccum
   glClearColor
   glClearDepth
   glClearIndex
   glClearStencil
   glColor3b
   glColor3d
   glColor3f
   glColor3i
   glColor3s
   glColor3ub
   glColor3ui
   glColor4d
   glColor4f
   glColor4i
   glColor4s
   glColor4ub
   glColor4ui
   glColor4us
   glColorMask
   glColorMaterial
   glCopyPixels
   glCullFace
   glDeleteLists
   glDepthFunc
   glDepthMask
   glDepthRange
   glDisable
   glDrawBuffer
   glEdgeFlag
   glEnable
   glEnd
   glEndList
   glEvalCoord1d
   glEvalCoord1f
   glEvalCoord2d
   glEvalCoord2f
   glEvalMesh1
   glEvalMesh2
   glEvalPoint1
   glEvalPoint2
   glFinish
   glFlush
   glFogf
   glFogi
   glFrontFace
   glFrustum
   glGenLists
   glGetError
   glHint
   glIndexMask
   glIndexd
   glIndexi
   glInitNames
   glIsEnabled
   glIsList
   glLightModelf
   glLightModeli
   glLightf
   glLighti
   glLineStipple
   glLineWidth
   glListBase
   glLoadIdentity
   glLoadName
   glLogicOp
   glMapGrid1d
   glMapGrid1f
   glMapGrid2d
   glMapGrid2f
   glMaterialf
   glMateriali
   glMatrixMode
   glNewList
   glNormal3b
   glNormal3d
   glNormal3f
   glNormal3i
   glNormal3s
   glOrtho
   glPassThrough
   glPixelStoref
   glPixelStorei
   glPixelTransferf
   glPixelTransferi
   glPixelZoom
   glPointSize
   glPolygonMode
   glPolygonOffsetEXT
   glPopAttrib
   glPopMatrix
   glPopName
   glPushAttrib
   glPushMatrix
   glPushName
   glRasterPos2d
   glRasterPos2f
   glRasterPos2i
   glRasterPos2s
   glRasterPos3d
   glRasterPos3f
   glRasterPos3i
   glRasterPos3s
   glRasterPos4d
   glRasterPos4f
   glRasterPos4i
   glRasterPos4s
   glReadBuffer
   glRectd
   glRectf
   glRecti
   glRects
   glRenderMode
   glRotated
   glRotatef
   glScaled
   glScalef
   glScissor
   glShadeModel
   glStencilFunc
   glStencilMask
   glStencilOp
   glTexCoord1d
   glTexCoord1f
   glTexCoord1i
   glTexCoord1s
   glTexCoord2d
   glTexCoord2f
   glTexCoord2i
   glTexCoord2s
   glTexCoord3d
   glTexCoord3f
   glTexCoord3i
   glTexCoord3s
   glTexCoord4d
   glTexCoord4f
   glTexCoord4i
   glTexCoord4s
   glTexEnvf
   glTexEnvi
   glTexGend
   glTexGenf
   glTexGeni
   glTexParameterf
   glTexParameteri
   glTranslated
   glTranslatef
   glVertex2d
   glVertex2f
   glVertex2i
   glVertex2s
   glVertex3d
   glVertex3f
   glVertex3i
   glVertex3s
   glVertex4d
   glVertex4f
   glVertex4i
   glVertex4s
   glViewport
);
our @gl_func = (@gl_func_common, qw(
   glActiveTexture
   glActiveTextureARB
   glAreTexturesResidentEXT_p
   glAreTexturesResident_c
   glAreTexturesResident_p
   glAreTexturesResident_s
   glArrayElement
   glArrayElementEXT
   glAttachObjectARB
   glBindAttribLocationARB
   glBindBufferARB
   glBindFramebufferEXT
   glBindProgramARB
   glBindRenderbufferEXT
   glBindTexture
   glBindTextureEXT
   glBitmap_c
   glBitmap_p
   glBitmap_s
   glBufferDataARB_c
   glBufferDataARB_p
   glBufferDataARB_s
   glBufferSubDataARB_c
   glBufferSubDataARB_p
   glBufferSubDataARB_s
   glCallLists_c
   glCallLists_p
   glCallLists_s
   glCheckFramebufferStatusEXT
   glClampColorARB
   glClientActiveTexture
   glClientActiveTextureARB
   glClipPlane_c
   glClipPlane_p
   glClipPlane_s
   glColor3bv_c
   glColor3bv_p
   glColor3bv_s
   glColor3dv_c
   glColor3dv_p
   glColor3dv_s
   glColor3fv_c
   glColor3fv_p
   glColor3fv_s
   glColor3iv_c
   glColor3iv_p
   glColor3iv_s
   glColor3sv_c
   glColor3sv_p
   glColor3sv_s
   glColor3ubv_c
   glColor3ubv_p
   glColor3ubv_s
   glColor3uiv_c
   glColor3uiv_p
   glColor3uiv_s
   glColor3us
   glColor3usv_c
   glColor3usv_p
   glColor3usv_s
   glColor4b
   glColor4bv_c
   glColor4bv_p
   glColor4bv_s
   glColor4dv_c
   glColor4dv_p
   glColor4dv_s
   glColor4fv_c
   glColor4fv_p
   glColor4fv_s
   glColor4iv_c
   glColor4iv_p
   glColor4iv_s
   glColor4sv_c
   glColor4sv_p
   glColor4sv_s
   glColor4ubv_c
   glColor4ubv_p
   glColor4ubv_s
   glColor4uiv_c
   glColor4uiv_p
   glColor4uiv_s
   glColor4usv_c
   glColor4usv_p
   glColor4usv_s
   glColorPointerEXT_c
   glColorPointerEXT_p
   glColorPointerEXT_s
   glColorPointer_c
   glColorPointer_p
   glColorPointer_s
   glCompileShaderARB
   glCopyTexImage1D
   glCopyTexImage1DEXT
   glCopyTexImage2D
   glCopyTexImage2DEXT
   glCopyTexSubImage1D
   glCopyTexSubImage1DEXT
   glCopyTexSubImage2D
   glCopyTexSubImage2DEXT
   glCopyTexSubImage3D
   glCopyTexSubImage3DEXT
   glCreateProgramObjectARB
   glCreateShaderObjectARB
   glDeleteBuffersARB_c
   glDeleteBuffersARB_p
   glDeleteBuffersARB_s
   glDeleteFramebuffersEXT_c
   glDeleteFramebuffersEXT_p
   glDeleteFramebuffersEXT_s
   glDeleteObjectARB
   glDeleteProgramsARB_c
   glDeleteProgramsARB_p
   glDeleteProgramsARB_s
   glDeleteRenderbuffersEXT_c
   glDeleteRenderbuffersEXT_p
   glDeleteRenderbuffersEXT_s
   glDeleteTexturesEXT_p
   glDeleteTextures_c
   glDeleteTextures_p
   glDeleteTextures_s
   glDetachObjectARB
   glDisableClientState
   glDisableVertexAttribArrayARB
   glDrawArrays
   glDrawArraysEXT
   glDrawBuffersARB_c
   glDrawBuffersARB_p
   glDrawBuffersARB_s
   glDrawBuffers_c
   glDrawBuffers_p
   glDrawBuffers_s
   glDrawElements_c
   glDrawElements_p
   glDrawElements_s
   glDrawPixels_c
   glDrawPixels_p
   glDrawPixels_s
   glDrawRangeElements_c
   glDrawRangeElements_p
   glDrawRangeElements_s
   glEdgeFlagPointerEXT_c
   glEdgeFlagPointerEXT_p
   glEdgeFlagPointerEXT_s
   glEdgeFlagPointer_c
   glEdgeFlagPointer_p
   glEdgeFlagPointer_s
   glEnableClientState
   glEnableVertexAttribArrayARB
   glFeedbackBuffer_c
   glFogfv_c
   glFogfv_p
   glFogfv_s
   glFogiv_c
   glFogiv_p
   glFogiv_s
   glFramebufferRenderbufferEXT
   glFramebufferTexture1DEXT
   glFramebufferTexture2DEXT
   glFramebufferTexture3DEXT
   glGenBuffersARB_c
   glGenBuffersARB_p
   glGenBuffersARB_s
   glGenFramebuffersEXT_c
   glGenFramebuffersEXT_p
   glGenFramebuffersEXT_s
   glGenProgramsARB_c
   glGenProgramsARB_p
   glGenProgramsARB_s
   glGenRenderbuffersEXT_c
   glGenRenderbuffersEXT_p
   glGenRenderbuffersEXT_s
   glGenTexturesEXT_p
   glGenTextures_c
   glGenTextures_p
   glGenTextures_s
   glGenerateMipmapEXT
   glGetActiveAttribARB_c
   glGetActiveAttribARB_p
   glGetActiveAttribARB_s
   glGetActiveUniformARB_c
   glGetActiveUniformARB_p
   glGetActiveUniformARB_s
   glGetAttachedObjectsARB_c
   glGetAttachedObjectsARB_p
   glGetAttachedObjectsARB_s
   glGetAttribLocationARB_c
   glGetAttribLocationARB_p
   glGetBooleanv_c
   glGetBooleanv_p
   glGetBooleanv_s
   glGetBufferParameterivARB_c
   glGetBufferParameterivARB_p
   glGetBufferParameterivARB_s
   glGetBufferPointervARB_c
   glGetBufferPointervARB_p
   glGetBufferPointervARB_s
   glGetBufferSubDataARB_c
   glGetBufferSubDataARB_p
   glGetBufferSubDataARB_s
   glGetClipPlane_c
   glGetClipPlane_p
   glGetClipPlane_s
   glGetDoublev_c
   glGetDoublev_p
   glGetDoublev_s
   glGetFloatv_c
   glGetFloatv_p
   glGetFloatv_s
   glGetFramebufferAttachmentParameterivEXT_c
   glGetFramebufferAttachmentParameterivEXT_s
   glGetGLhandleARB
   glGetInfoLogARB_c
   glGetInfoLogARB_p
   glGetIntegerv_c
   glGetIntegerv_p
   glGetIntegerv_s
   glGetLightfv_c
   glGetLightfv_p
   glGetLightfv_s
   glGetLightiv_c
   glGetLightiv_p
   glGetLightiv_s
   glGetMapdv_c
   glGetMapdv_p
   glGetMapdv_s
   glGetMapfv_c
   glGetMapfv_p
   glGetMapfv_s
   glGetMapiv_c
   glGetMapiv_p
   glGetMapiv_s
   glGetMaterialfv_c
   glGetMaterialfv_p
   glGetMaterialfv_s
   glGetMaterialiv_c
   glGetMaterialiv_p
   glGetMaterialiv_s
   glGetObjectParameterfvARB_c
   glGetObjectParameterfvARB_p
   glGetObjectParameterfvARB_s
   glGetObjectParameterivARB_c
   glGetObjectParameterivARB_p
   glGetObjectParameterivARB_s
   glGetPixelMapfv_c
   glGetPixelMapfv_p
   glGetPixelMapfv_s
   glGetPixelMapuiv_c
   glGetPixelMapuiv_p
   glGetPixelMapuiv_s
   glGetPixelMapusv_c
   glGetPixelMapusv_p
   glGetPixelMapusv_s
   glGetPointerv_c
   glGetPointerv_p
   glGetPointerv_s
   glGetPolygonStipple_c
   glGetPolygonStipple_p
   glGetPolygonStipple_s
   glGetProgramEnvParameterdvARB_c
   glGetProgramEnvParameterdvARB_p
   glGetProgramEnvParameterdvARB_s
   glGetProgramEnvParameterfvARB_c
   glGetProgramEnvParameterfvARB_p
   glGetProgramEnvParameterfvARB_s
   glGetProgramLocalParameterdvARB_c
   glGetProgramLocalParameterdvARB_p
   glGetProgramLocalParameterdvARB_s
   glGetProgramLocalParameterfvARB_c
   glGetProgramLocalParameterfvARB_p
   glGetProgramLocalParameterfvARB_s
   glGetProgramStringARB_c
   glGetProgramStringARB_p
   glGetProgramStringARB_s
   glGetProgramivARB_c
   glGetProgramivARB_p
   glGetProgramivARB_s
   glGetRenderbufferParameterivEXT_c
   glGetRenderbufferParameterivEXT_s
   glGetShaderSourceARB_c
   glGetShaderSourceARB_p
   glGetString
   glGetTexEnvfv_c
   glGetTexEnvfv_p
   glGetTexEnvfv_s
   glGetTexEnviv_c
   glGetTexEnviv_p
   glGetTexEnviv_s
   glGetTexGendv_c
   glGetTexGendv_p
   glGetTexGendv_s
   glGetTexGenfv_c
   glGetTexGenfv_p
   glGetTexGenfv_s
   glGetTexGeniv_c
   glGetTexGeniv_p
   glGetTexGeniv_s
   glGetTexImage_c
   glGetTexImage_p
   glGetTexImage_s
   glGetTexLevelParameterfv_c
   glGetTexLevelParameterfv_p
   glGetTexLevelParameterfv_s
   glGetTexLevelParameteriv_c
   glGetTexLevelParameteriv_p
   glGetTexLevelParameteriv_s
   glGetTexParameterfv_c
   glGetTexParameterfv_p
   glGetTexParameterfv_s
   glGetTexParameteriv_c
   glGetTexParameteriv_p
   glGetTexParameteriv_s
   glGetUniformLocationARB_c
   glGetUniformLocationARB_p
   glGetUniformfvARB_c
   glGetUniformfvARB_p
   glGetUniformivARB_c
   glGetUniformivARB_p
   glGetVertexAttribPointervARB_c
   glGetVertexAttribPointervARB_p
   glGetVertexAttribdvARB_c
   glGetVertexAttribdvARB_p
   glGetVertexAttribdvARB_s
   glGetVertexAttribfvARB_c
   glGetVertexAttribfvARB_p
   glGetVertexAttribfvARB_s
   glGetVertexAttribivARB_c
   glGetVertexAttribivARB_p
   glGetVertexAttribivARB_s
   glIndexPointerEXT_c
   glIndexPointerEXT_p
   glIndexPointerEXT_s
   glIndexPointer_c
   glIndexPointer_p
   glIndexPointer_s
   glInterleavedArrays_c
   glIsBufferARB
   glIsFramebufferEXT
   glIsProgramARB
   glIsRenderbufferEXT
   glIsTexture
   glIsTextureEXT
   glLightModelfv_c
   glLightModelfv_p
   glLightModelfv_s
   glLightModeliv_c
   glLightModeliv_p
   glLightModeliv_s
   glLightfv_c
   glLightfv_p
   glLightfv_s
   glLightiv_c
   glLightiv_p
   glLightiv_s
   glLinkProgramARB
   glLoadMatrixd_c
   glLoadMatrixd_p
   glLoadMatrixd_s
   glLoadMatrixf_c
   glLoadMatrixf_p
   glLoadMatrixf_s
   glMap1d_c
   glMap1d_p
   glMap1d_s
   glMap1f_c
   glMap1f_p
   glMap1f_s
   glMap2d_c
   glMap2d_p
   glMap2d_s
   glMap2f_c
   glMap2f_p
   glMap2f_s
   glMapBufferARB_c
   glMapBufferARB_p
   glMaterialfv_c
   glMaterialfv_p
   glMaterialfv_s
   glMaterialiv_c
   glMaterialiv_p
   glMaterialiv_s
   glMultMatrixd_p
   glMultMatrixf_p
   glMultiTexCoord1d
   glMultiTexCoord1dARB
   glMultiTexCoord1dvARB_c
   glMultiTexCoord1dvARB_p
   glMultiTexCoord1dvARB_s
   glMultiTexCoord1dv_c
   glMultiTexCoord1dv_p
   glMultiTexCoord1dv_s
   glMultiTexCoord1f
   glMultiTexCoord1fARB
   glMultiTexCoord1fvARB_c
   glMultiTexCoord1fvARB_p
   glMultiTexCoord1fvARB_s
   glMultiTexCoord1fv_c
   glMultiTexCoord1fv_p
   glMultiTexCoord1fv_s
   glMultiTexCoord1i
   glMultiTexCoord1iARB
   glMultiTexCoord1ivARB_c
   glMultiTexCoord1ivARB_p
   glMultiTexCoord1ivARB_s
   glMultiTexCoord1iv_c
   glMultiTexCoord1iv_p
   glMultiTexCoord1iv_s
   glMultiTexCoord1s
   glMultiTexCoord1sARB
   glMultiTexCoord1svARB_c
   glMultiTexCoord1svARB_p
   glMultiTexCoord1svARB_s
   glMultiTexCoord1sv_c
   glMultiTexCoord1sv_p
   glMultiTexCoord1sv_s
   glMultiTexCoord2d
   glMultiTexCoord2dARB
   glMultiTexCoord2dvARB_c
   glMultiTexCoord2dvARB_p
   glMultiTexCoord2dvARB_s
   glMultiTexCoord2dv_c
   glMultiTexCoord2dv_p
   glMultiTexCoord2dv_s
   glMultiTexCoord2f
   glMultiTexCoord2fARB
   glMultiTexCoord2fvARB_c
   glMultiTexCoord2fvARB_p
   glMultiTexCoord2fvARB_s
   glMultiTexCoord2fv_c
   glMultiTexCoord2fv_p
   glMultiTexCoord2fv_s
   glMultiTexCoord2i
   glMultiTexCoord2iARB
   glMultiTexCoord2ivARB_c
   glMultiTexCoord2ivARB_p
   glMultiTexCoord2ivARB_s
   glMultiTexCoord2iv_c
   glMultiTexCoord2iv_p
   glMultiTexCoord2iv_s
   glMultiTexCoord2s
   glMultiTexCoord2sARB
   glMultiTexCoord2svARB_c
   glMultiTexCoord2svARB_p
   glMultiTexCoord2svARB_s
   glMultiTexCoord2sv_c
   glMultiTexCoord2sv_p
   glMultiTexCoord2sv_s
   glMultiTexCoord3d
   glMultiTexCoord3dARB
   glMultiTexCoord3dvARB_c
   glMultiTexCoord3dvARB_p
   glMultiTexCoord3dvARB_s
   glMultiTexCoord3dv_c
   glMultiTexCoord3dv_p
   glMultiTexCoord3dv_s
   glMultiTexCoord3f
   glMultiTexCoord3fARB
   glMultiTexCoord3fvARB_c
   glMultiTexCoord3fvARB_p
   glMultiTexCoord3fvARB_s
   glMultiTexCoord3fv_c
   glMultiTexCoord3fv_p
   glMultiTexCoord3fv_s
   glMultiTexCoord3i
   glMultiTexCoord3iARB
   glMultiTexCoord3ivARB_c
   glMultiTexCoord3ivARB_p
   glMultiTexCoord3ivARB_s
   glMultiTexCoord3iv_c
   glMultiTexCoord3iv_p
   glMultiTexCoord3iv_s
   glMultiTexCoord3s
   glMultiTexCoord3sARB
   glMultiTexCoord3svARB_c
   glMultiTexCoord3svARB_p
   glMultiTexCoord3svARB_s
   glMultiTexCoord3sv_c
   glMultiTexCoord3sv_p
   glMultiTexCoord3sv_s
   glMultiTexCoord4d
   glMultiTexCoord4dARB
   glMultiTexCoord4dvARB_c
   glMultiTexCoord4dvARB_p
   glMultiTexCoord4dvARB_s
   glMultiTexCoord4dv_c
   glMultiTexCoord4dv_p
   glMultiTexCoord4dv_s
   glMultiTexCoord4f
   glMultiTexCoord4fARB
   glMultiTexCoord4fvARB_c
   glMultiTexCoord4fvARB_p
   glMultiTexCoord4fvARB_s
   glMultiTexCoord4fv_c
   glMultiTexCoord4fv_p
   glMultiTexCoord4fv_s
   glMultiTexCoord4i
   glMultiTexCoord4iARB
   glMultiTexCoord4ivARB_c
   glMultiTexCoord4ivARB_p
   glMultiTexCoord4ivARB_s
   glMultiTexCoord4iv_c
   glMultiTexCoord4iv_p
   glMultiTexCoord4iv_s
   glMultiTexCoord4s
   glMultiTexCoord4sARB
   glMultiTexCoord4svARB_c
   glMultiTexCoord4svARB_p
   glMultiTexCoord4svARB_s
   glMultiTexCoord4sv_c
   glMultiTexCoord4sv_p
   glMultiTexCoord4sv_s
   glNormal3bv_c
   glNormal3bv_p
   glNormal3bv_s
   glNormal3dv_c
   glNormal3dv_p
   glNormal3dv_s
   glNormal3fv_c
   glNormal3fv_p
   glNormal3fv_s
   glNormal3iv_c
   glNormal3iv_p
   glNormal3iv_s
   glNormal3sv_c
   glNormal3sv_p
   glNormal3sv_s
   glNormalPointerEXT_c
   glNormalPointerEXT_p
   glNormalPointerEXT_s
   glNormalPointer_c
   glNormalPointer_p
   glNormalPointer_s
   glPixelMapfv_c
   glPixelMapfv_p
   glPixelMapfv_s
   glPixelMapuiv_c
   glPixelMapuiv_p
   glPixelMapuiv_s
   glPixelMapusv_c
   glPixelMapusv_p
   glPixelMapusv_s
   glPointParameterfARB
   glPointParameterfvARB_c
   glPointParameterfvARB_p
   glPointParameterfvARB_s
   glPolygonOffset
   glPolygonStipple_c
   glPolygonStipple_p
   glPolygonStipple_s
   glPopClientAttrib
   glPrioritizeTexturesEXT_p
   glPrioritizeTextures_c
   glPrioritizeTextures_p
   glPrioritizeTextures_s
   glProgramEnvParameter4dARB
   glProgramEnvParameter4dvARB_c
   glProgramEnvParameter4dvARB_p
   glProgramEnvParameter4dvARB_s
   glProgramEnvParameter4fARB
   glProgramEnvParameter4fvARB_c
   glProgramEnvParameter4fvARB_p
   glProgramEnvParameter4fvARB_s
   glProgramLocalParameter4dARB
   glProgramLocalParameter4dvARB_c
   glProgramLocalParameter4dvARB_p
   glProgramLocalParameter4dvARB_s
   glProgramLocalParameter4fARB
   glProgramLocalParameter4fvARB_c
   glProgramLocalParameter4fvARB_p
   glProgramLocalParameter4fvARB_s
   glProgramStringARB_c
   glProgramStringARB_p
   glProgramStringARB_s
   glPushClientAttrib
   glRasterPos2dv_c
   glRasterPos2dv_p
   glRasterPos2dv_s
   glRasterPos2fv_c
   glRasterPos2fv_p
   glRasterPos2fv_s
   glRasterPos2iv_c
   glRasterPos2iv_p
   glRasterPos2iv_s
   glRasterPos2sv_c
   glRasterPos2sv_p
   glRasterPos2sv_s
   glRasterPos3dv_c
   glRasterPos3dv_p
   glRasterPos3dv_s
   glRasterPos3fv_c
   glRasterPos3fv_p
   glRasterPos3fv_s
   glRasterPos3iv_c
   glRasterPos3iv_p
   glRasterPos3iv_s
   glRasterPos3sv_c
   glRasterPos3sv_p
   glRasterPos3sv_s
   glRasterPos4dv_c
   glRasterPos4dv_p
   glRasterPos4dv_s
   glRasterPos4fv_c
   glRasterPos4fv_p
   glRasterPos4fv_s
   glRasterPos4iv_c
   glRasterPos4iv_p
   glRasterPos4iv_s
   glRasterPos4sv_c
   glRasterPos4sv_p
   glRasterPos4sv_s
   glReadPixels_c
   glReadPixels_p
   glReadPixels_s
   glRectdv_c
   glRectdv_s
   glRectfv_c
   glRectfv_s
   glRectiv_c
   glRectiv_s
   glRectsv_c
   glRectsv_s
   glRenderbufferStorageEXT
   glResizeBuffersMESA
   glSampleCoverageARB
   glSelectBuffer_c
   glShaderSourceARB_c
   glShaderSourceARB_p
   glTexCoord1dv_c
   glTexCoord1dv_p
   glTexCoord1dv_s
   glTexCoord1fv_c
   glTexCoord1fv_p
   glTexCoord1fv_s
   glTexCoord1iv_c
   glTexCoord1iv_p
   glTexCoord1iv_s
   glTexCoord1sv_c
   glTexCoord1sv_p
   glTexCoord1sv_s
   glTexCoord2dv_c
   glTexCoord2dv_p
   glTexCoord2dv_s
   glTexCoord2fv_c
   glTexCoord2fv_p
   glTexCoord2fv_s
   glTexCoord2iv_c
   glTexCoord2iv_p
   glTexCoord2iv_s
   glTexCoord2sv_c
   glTexCoord2sv_p
   glTexCoord2sv_s
   glTexCoord3dv_c
   glTexCoord3dv_p
   glTexCoord3dv_s
   glTexCoord3fv_c
   glTexCoord3fv_p
   glTexCoord3fv_s
   glTexCoord3iv_c
   glTexCoord3iv_p
   glTexCoord3iv_s
   glTexCoord3sv_c
   glTexCoord3sv_p
   glTexCoord3sv_s
   glTexCoord4dv_c
   glTexCoord4dv_p
   glTexCoord4dv_s
   glTexCoord4fv_c
   glTexCoord4fv_p
   glTexCoord4fv_s
   glTexCoord4iv_c
   glTexCoord4iv_p
   glTexCoord4iv_s
   glTexCoord4sv_c
   glTexCoord4sv_p
   glTexCoord4sv_s
   glTexCoordPointerEXT_c
   glTexCoordPointerEXT_p
   glTexCoordPointerEXT_s
   glTexCoordPointer_c
   glTexCoordPointer_p
   glTexCoordPointer_s
   glTexEnvfv_p
   glTexEnvfv_s
   glTexEnviv_p
   glTexEnviv_s
   glTexGendv_c
   glTexGendv_p
   glTexGendv_s
   glTexGenfv_c
   glTexGenfv_p
   glTexGenfv_s
   glTexGeniv_c
   glTexGeniv_p
   glTexGeniv_s
   glTexImage1D_c
   glTexImage1D_p
   glTexImage1D_s
   glTexImage2D_c
   glTexImage2D_p
   glTexImage2D_s
   glTexImage3DEXT_c
   glTexImage3DEXT_p
   glTexImage3DEXT_s
   glTexImage3D_c
   glTexImage3D_p
   glTexImage3D_s
   glTexParameterfv_c
   glTexParameterfv_p
   glTexParameterfv_s
   glTexParameteriv_c
   glTexParameteriv_p
   glTexParameteriv_s
   glTexSubImage1DEXT_c
   glTexSubImage1DEXT_p
   glTexSubImage1DEXT_s
   glTexSubImage1D_c
   glTexSubImage1D_p
   glTexSubImage1D_s
   glTexSubImage2DEXT_c
   glTexSubImage2DEXT_p
   glTexSubImage2DEXT_s
   glTexSubImage2D_c
   glTexSubImage2D_p
   glTexSubImage2D_s
   glTexSubImage3D_c
   glTexSubImage3D_p
   glTexSubImage3D_s
   glUniform1fARB
   glUniform1fvARB_c
   glUniform1fvARB_p
   glUniform1fvARB_s
   glUniform1iARB
   glUniform1ivARB_c
   glUniform1ivARB_p
   glUniform1ivARB_s
   glUniform2fARB
   glUniform2fvARB_c
   glUniform2fvARB_p
   glUniform2fvARB_s
   glUniform2iARB
   glUniform2ivARB_c
   glUniform2ivARB_p
   glUniform2ivARB_s
   glUniform3fARB
   glUniform3fvARB_c
   glUniform3fvARB_p
   glUniform3fvARB_s
   glUniform3iARB
   glUniform3ivARB_c
   glUniform3ivARB_p
   glUniform3ivARB_s
   glUniform4fARB
   glUniform4fvARB_c
   glUniform4fvARB_p
   glUniform4fvARB_s
   glUniform4iARB
   glUniform4ivARB_c
   glUniform4ivARB_p
   glUniform4ivARB_s
   glUniformMatrix2fvARB_c
   glUniformMatrix2fvARB_p
   glUniformMatrix2fvARB_s
   glUniformMatrix3fvARB_c
   glUniformMatrix3fvARB_p
   glUniformMatrix3fvARB_s
   glUniformMatrix4fvARB_c
   glUniformMatrix4fvARB_p
   glUniformMatrix4fvARB_s
   glUnmapBufferARB
   glUseProgramObjectARB
   glValidateProgramARB
   glVertex2dv_c
   glVertex2dv_p
   glVertex2dv_s
   glVertex2fv_c
   glVertex2fv_p
   glVertex2fv_s
   glVertex2iv_c
   glVertex2iv_p
   glVertex2iv_s
   glVertex2sv_c
   glVertex2sv_p
   glVertex2sv_s
   glVertex3dv_c
   glVertex3dv_p
   glVertex3dv_s
   glVertex3fv_c
   glVertex3fv_p
   glVertex3fv_s
   glVertex3iv_c
   glVertex3iv_p
   glVertex3iv_s
   glVertex3sv_c
   glVertex3sv_p
   glVertex3sv_s
   glVertex4dv_c
   glVertex4dv_p
   glVertex4dv_s
   glVertex4fv_c
   glVertex4fv_p
   glVertex4fv_s
   glVertex4iv_c
   glVertex4iv_p
   glVertex4iv_s
   glVertex4sv_c
   glVertex4sv_p
   glVertex4sv_s
   glVertexAttrib1dARB
   glVertexAttrib1dvARB_c
   glVertexAttrib1dvARB_p
   glVertexAttrib1dvARB_s
   glVertexAttrib1fARB
   glVertexAttrib1fvARB_c
   glVertexAttrib1fvARB_p
   glVertexAttrib1fvARB_s
   glVertexAttrib1sARB
   glVertexAttrib1svARB_c
   glVertexAttrib1svARB_p
   glVertexAttrib1svARB_s
   glVertexAttrib2dARB
   glVertexAttrib2dvARB_c
   glVertexAttrib2dvARB_p
   glVertexAttrib2dvARB_s
   glVertexAttrib2fARB
   glVertexAttrib2fvARB_c
   glVertexAttrib2fvARB_p
   glVertexAttrib2fvARB_s
   glVertexAttrib2sARB
   glVertexAttrib2svARB_c
   glVertexAttrib2svARB_p
   glVertexAttrib2svARB_s
   glVertexAttrib3dARB
   glVertexAttrib3dvARB_c
   glVertexAttrib3dvARB_p
   glVertexAttrib3dvARB_s
   glVertexAttrib3fARB
   glVertexAttrib3fvARB_c
   glVertexAttrib3fvARB_p
   glVertexAttrib3fvARB_s
   glVertexAttrib3sARB
   glVertexAttrib3svARB_c
   glVertexAttrib3svARB_p
   glVertexAttrib3svARB_s
   glVertexAttrib4NbvARB_c
   glVertexAttrib4NbvARB_p
   glVertexAttrib4NbvARB_s
   glVertexAttrib4NivARB_c
   glVertexAttrib4NivARB_p
   glVertexAttrib4NivARB_s
   glVertexAttrib4NsvARB_c
   glVertexAttrib4NsvARB_p
   glVertexAttrib4NsvARB_s
   glVertexAttrib4NubARB
   glVertexAttrib4NubvARB_c
   glVertexAttrib4NubvARB_p
   glVertexAttrib4NubvARB_s
   glVertexAttrib4NuivARB_c
   glVertexAttrib4NuivARB_p
   glVertexAttrib4NuivARB_s
   glVertexAttrib4NusvARB_c
   glVertexAttrib4NusvARB_p
   glVertexAttrib4NusvARB_s
   glVertexAttrib4bvARB_c
   glVertexAttrib4bvARB_p
   glVertexAttrib4bvARB_s
   glVertexAttrib4dARB
   glVertexAttrib4dvARB_c
   glVertexAttrib4dvARB_p
   glVertexAttrib4dvARB_s
   glVertexAttrib4fARB
   glVertexAttrib4fvARB_c
   glVertexAttrib4fvARB_p
   glVertexAttrib4fvARB_s
   glVertexAttrib4ivARB_c
   glVertexAttrib4ivARB_p
   glVertexAttrib4ivARB_s
   glVertexAttrib4sARB
   glVertexAttrib4svARB_c
   glVertexAttrib4svARB_p
   glVertexAttrib4svARB_s
   glVertexAttrib4ubvARB_c
   glVertexAttrib4ubvARB_p
   glVertexAttrib4ubvARB_s
   glVertexAttrib4uivARB_c
   glVertexAttrib4uivARB_p
   glVertexAttrib4uivARB_s
   glVertexAttrib4usvARB_c
   glVertexAttrib4usvARB_p
   glVertexAttrib4usvARB_s
   glVertexAttribPointerARB_c
   glVertexAttribPointerARB_p
   glVertexPointerEXT_c
   glVertexPointerEXT_p
   glVertexPointerEXT_s
   glVertexPointer_c
   glVertexPointer_p
   glVertexPointer_s
   glWindowPos2dMESA
   glWindowPos2iMESA
   glWindowPos3dMESA
   glWindowPos3iMESA
   glWindowPos4dMESA
   glWindowPos4iMESA
   glpCheckExtension
   glpFullScreen
   glpHasGLUT
   glpRestoreScreen
));

my @gl_const_common = qw(
   GL_1PASS_SGIS
   GL_2D
   GL_2PASS_0_SGIS
   GL_2PASS_1_SGIS
   GL_2_BYTES
   GL_3D
   GL_3D_COLOR
   GL_3D_COLOR_TEXTURE
   GL_3_BYTES
   GL_4D_COLOR_TEXTURE
   GL_4PASS_0_SGIS
   GL_4PASS_1_SGIS
   GL_4PASS_2_SGIS
   GL_4PASS_3_SGIS
   GL_4_BYTES
   GL_ABGR_EXT
   GL_ACCUM
   GL_ACCUM_ALPHA_BITS
   GL_ACCUM_BLUE_BITS
   GL_ACCUM_BUFFER_BIT
   GL_ACCUM_CLEAR_VALUE
   GL_ACCUM_GREEN_BITS
   GL_ACCUM_RED_BITS
   GL_ADD
   GL_ALL_ATTRIB_BITS
   GL_ALPHA
   GL_ALPHA12_EXT
   GL_ALPHA16_EXT
   GL_ALPHA4_EXT
   GL_ALPHA8_EXT
   GL_ALPHA_BIAS
   GL_ALPHA_BITS
   GL_ALPHA_SCALE
   GL_ALPHA_TEST
   GL_ALPHA_TEST_FUNC
   GL_ALPHA_TEST_REF
   GL_ALWAYS
   GL_AMBIENT
   GL_AMBIENT_AND_DIFFUSE
   GL_AND
   GL_AND_INVERTED
   GL_AND_REVERSE
   GL_ATTRIB_STACK_DEPTH
   GL_AUTO_NORMAL
   GL_AUX0
   GL_AUX1
   GL_AUX2
   GL_AUX3
   GL_AUX_BUFFERS
   GL_BACK
   GL_BACK_LEFT
   GL_BACK_RIGHT
   GL_BITMAP
   GL_BITMAP_TOKEN
   GL_BLEND
   GL_BLEND_COLOR_EXT
   GL_BLEND_DST
   GL_BLEND_EQUATION_EXT
   GL_BLEND_SRC
   GL_BLUE
   GL_BLUE_BIAS
   GL_BLUE_BITS
   GL_BLUE_SCALE
   GL_BYTE
   GL_CCW
   GL_CLAMP
   GL_CLEAR
   GL_CLIP_PLANE0
   GL_CLIP_PLANE1
   GL_CLIP_PLANE2
   GL_CLIP_PLANE3
   GL_CLIP_PLANE4
   GL_CLIP_PLANE5
   GL_COEFF
   GL_COLOR
   GL_COLOR_BUFFER_BIT
   GL_COLOR_CLEAR_VALUE
   GL_COLOR_INDEX
   GL_COLOR_INDEXES
   GL_COLOR_MATERIAL
   GL_COLOR_MATERIAL_FACE
   GL_COLOR_MATERIAL_PARAMETER
   GL_COLOR_WRITEMASK
   GL_COMPILE
   GL_COMPILE_AND_EXECUTE
   GL_CONSTANT_ALPHA_EXT
   GL_CONSTANT_ATTENUATION
   GL_CONSTANT_COLOR_EXT
   GL_CONVOLUTION_1D_EXT
   GL_CONVOLUTION_2D_EXT
   GL_CONVOLUTION_BORDER_MODE_EXT
   GL_CONVOLUTION_FILTER_BIAS_EXT
   GL_CONVOLUTION_FILTER_SCALE_EXT
   GL_CONVOLUTION_FORMAT_EXT
   GL_CONVOLUTION_HEIGHT_EXT
   GL_CONVOLUTION_WIDTH_EXT
   GL_COPY
   GL_COPY_INVERTED
   GL_COPY_PIXEL_TOKEN
   GL_CULL_FACE
   GL_CULL_FACE_MODE
   GL_CURRENT_BIT
   GL_CURRENT_COLOR
   GL_CURRENT_INDEX
   GL_CURRENT_NORMAL
   GL_CURRENT_RASTER_COLOR
   GL_CURRENT_RASTER_DISTANCE
   GL_CURRENT_RASTER_INDEX
   GL_CURRENT_RASTER_POSITION
   GL_CURRENT_RASTER_POSITION_VALID
   GL_CURRENT_RASTER_TEXTURE_COORDS
   GL_CURRENT_TEXTURE_COORDS
   GL_CW
   GL_DECAL
   GL_DECR
   GL_DEPTH
   GL_DEPTH_BIAS
   GL_DEPTH_BITS
   GL_DEPTH_BUFFER_BIT
   GL_DEPTH_CLEAR_VALUE
   GL_DEPTH_COMPONENT
   GL_DEPTH_FUNC
   GL_DEPTH_RANGE
   GL_DEPTH_SCALE
   GL_DEPTH_TEST
   GL_DEPTH_WRITEMASK
   GL_DETAIL_TEXTURE_2D_BINDING_SGIS
   GL_DETAIL_TEXTURE_2D_SGIS
   GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS
   GL_DETAIL_TEXTURE_LEVEL_SGIS
   GL_DETAIL_TEXTURE_MODE_SGIS
   GL_DIFFUSE
   GL_DITHER
   GL_DOMAIN
   GL_DONT_CARE
   GL_DOUBLEBUFFER
   GL_DRAW_BUFFER
   GL_DRAW_PIXEL_TOKEN
   GL_DST_ALPHA
   GL_DST_COLOR
   GL_EDGE_FLAG
   GL_EMISSION
   GL_ENABLE_BIT
   GL_EQUAL
   GL_EQUIV
   GL_EVAL_BIT
   GL_EXP
   GL_EXP2
   GL_EXTENSIONS
   GL_EYE_LINEAR
   GL_EYE_PLANE
   GL_FALSE
   GL_FASTEST
   GL_FEEDBACK
   GL_FILL
   GL_FLAT
   GL_FLOAT
   GL_FOG
   GL_FOG_BIT
   GL_FOG_COLOR
   GL_FOG_DENSITY
   GL_FOG_END
   GL_FOG_HINT
   GL_FOG_INDEX
   GL_FOG_MODE
   GL_FOG_START
   GL_FRONT
   GL_FRONT_AND_BACK
   GL_FRONT_FACE
   GL_FRONT_LEFT
   GL_FRONT_RIGHT
   GL_FUNC_ADD_EXT
   GL_FUNC_REVERSE_SUBTRACT_EXT
   GL_FUNC_SUBTRACT_EXT
   GL_GEQUAL
   GL_GREATER
   GL_GREEN
   GL_GREEN_BIAS
   GL_GREEN_BITS
   GL_GREEN_SCALE
   GL_HINT_BIT
   GL_HISTOGRAM_ALPHA_SIZE_EXT
   GL_HISTOGRAM_BLUE_SIZE_EXT
   GL_HISTOGRAM_EXT
   GL_HISTOGRAM_FORMAT_EXT
   GL_HISTOGRAM_GREEN_SIZE_EXT
   GL_LEQUAL
   GL_LESS
   GL_LIGHTING_BIT
   GL_LINES
   GL_LINE_BIT
   GL_LINE_LOOP
   GL_LINE_STRIP
   GL_LIST_BIT
   GL_LOAD
   GL_MULT
   GL_NEVER
   GL_NOTEQUAL
   GL_PIXEL_MODE_BIT
   GL_POINTS
   GL_POINT_BIT
   GL_POLYGON
   GL_POLYGON_BIT
   GL_POLYGON_STIPPLE_BIT
   GL_QUADS
   GL_QUAD_STRIP
   GL_RETURN
   GL_SCISSOR_BIT
   GL_STENCIL_BUFFER_BIT
   GL_TEXTURE_BIT
   GL_TRANSFORM_BIT
   GL_TRIANGLES
   GL_TRIANGLE_FAN
   GL_TRIANGLE_STRIP
   GL_TRUE
   GL_VIEWPORT_BIT
   GL_HISTOGRAM_LUMINANCE_SIZE_EXT
   GL_HISTOGRAM_RED_SIZE_EXT
   GL_HISTOGRAM_SINK_EXT
   GL_HISTOGRAM_WIDTH_EXT
   GL_INCR
   GL_INDEX_BITS
   GL_INDEX_CLEAR_VALUE
   GL_INDEX_MODE
   GL_INDEX_OFFSET
   GL_INDEX_SHIFT
   GL_INDEX_WRITEMASK
   GL_INT
   GL_INTENSITY12_EXT
   GL_INTENSITY16_EXT
   GL_INTENSITY4_EXT
   GL_INTENSITY8_EXT
   GL_INTENSITY_EXT
   GL_INVALID_ENUM
   GL_INVALID_OPERATION
   GL_INVALID_VALUE
   GL_INVERT
   GL_KEEP
   GL_LEFT
   GL_LIGHT0
   GL_LIGHT1
   GL_LIGHT2
   GL_LIGHT3
   GL_LIGHT4
   GL_LIGHT5
   GL_LIGHT6
   GL_LIGHT7
   GL_LIGHTING
   GL_LIGHT_MODEL_AMBIENT
   GL_LIGHT_MODEL_LOCAL_VIEWER
   GL_LIGHT_MODEL_TWO_SIDE
   GL_LINE
   GL_LINEAR
   GL_LINEAR_ATTENUATION
   GL_LINEAR_DETAIL_ALPHA_SGIS
   GL_LINEAR_DETAIL_COLOR_SGIS
   GL_LINEAR_DETAIL_SGIS
   GL_LINEAR_MIPMAP_LINEAR
   GL_LINEAR_MIPMAP_NEAREST
   GL_LINEAR_SHARPEN_ALPHA_SGIS
   GL_LINEAR_SHARPEN_COLOR_SGIS
   GL_LINEAR_SHARPEN_SGIS
   GL_LINE_RESET_TOKEN
   GL_LINE_SMOOTH
   GL_LINE_SMOOTH_HINT
   GL_LINE_STIPPLE
   GL_LINE_STIPPLE_PATTERN
   GL_LINE_STIPPLE_REPEAT
   GL_LINE_TOKEN
   GL_LINE_WIDTH
   GL_LINE_WIDTH_GRANULARITY
   GL_LINE_WIDTH_RANGE
   GL_LIST_BASE
   GL_LIST_INDEX
   GL_LIST_MODE
   GL_LOGIC_OP
   GL_LOGIC_OP_MODE
   GL_LUMINANCE
   GL_LUMINANCE12_ALPHA12_EXT
   GL_LUMINANCE12_ALPHA4_EXT
   GL_LUMINANCE12_EXT
   GL_LUMINANCE16_ALPHA16_EXT
   GL_LUMINANCE16_EXT
   GL_LUMINANCE4_ALPHA4_EXT
   GL_LUMINANCE4_EXT
   GL_LUMINANCE6_ALPHA2_EXT
   GL_LUMINANCE8_ALPHA8_EXT
   GL_LUMINANCE8_EXT
   GL_LUMINANCE_ALPHA
   GL_MAP1_COLOR_4
   GL_MAP1_GRID_DOMAIN
   GL_MAP1_GRID_SEGMENTS
   GL_MAP1_INDEX
   GL_MAP1_NORMAL
   GL_MAP1_TEXTURE_COORD_1
   GL_MAP1_TEXTURE_COORD_2
   GL_MAP1_TEXTURE_COORD_3
   GL_MAP1_TEXTURE_COORD_4
   GL_MAP1_VERTEX_3
   GL_MAP1_VERTEX_4
   GL_MAP2_COLOR_4
   GL_MAP2_GRID_DOMAIN
   GL_MAP2_GRID_SEGMENTS
   GL_MAP2_INDEX
   GL_MAP2_NORMAL
   GL_MAP2_TEXTURE_COORD_1
   GL_MAP2_TEXTURE_COORD_2
   GL_MAP2_TEXTURE_COORD_3
   GL_MAP2_TEXTURE_COORD_4
   GL_MAP2_VERTEX_3
   GL_MAP2_VERTEX_4
   GL_MAP_COLOR
   GL_MAP_STENCIL
   GL_MATRIX_MODE
   GL_MAX_3D_TEXTURE_SIZE_EXT
   GL_MAX_ATTRIB_STACK_DEPTH
   GL_MAX_CLIP_PLANES
   GL_MAX_CONVOLUTION_HEIGHT_EXT
   GL_MAX_CONVOLUTION_WIDTH_EXT
   GL_MAX_EVAL_ORDER
   GL_MAX_EXT
   GL_MAX_LIGHTS
   GL_MAX_LIST_NESTING
   GL_MAX_MODELVIEW_STACK_DEPTH
   GL_MAX_NAME_STACK_DEPTH
   GL_MAX_PIXEL_MAP_TABLE
   GL_MAX_PROJECTION_STACK_DEPTH
   GL_MAX_TEXTURE_SIZE
   GL_MAX_TEXTURE_STACK_DEPTH
   GL_MAX_VIEWPORT_DIMS
   GL_MINMAX_EXT
   GL_MINMAX_FORMAT_EXT
   GL_MINMAX_SINK_EXT
   GL_MIN_EXT
   GL_MODELVIEW
   GL_MODELVIEW_MATRIX
   GL_MODELVIEW_STACK_DEPTH
   GL_MODULATE
   GL_MULTISAMPLE_BIT_EXT
   GL_MULTISAMPLE_SGIS
   GL_NAME_STACK_DEPTH
   GL_NAND
   GL_NEAREST
   GL_NEAREST_MIPMAP_LINEAR
   GL_NEAREST_MIPMAP_NEAREST
   GL_NICEST
   GL_NONE
   GL_NOOP
   GL_NOR
   GL_NORMALIZE
   GL_NO_ERROR
   GL_OBJECT_LINEAR
   GL_OBJECT_PLANE
   GL_ONE
   GL_ONE_MINUS_CONSTANT_ALPHA_EXT
   GL_ONE_MINUS_CONSTANT_COLOR_EXT
   GL_ONE_MINUS_DST_ALPHA
   GL_ONE_MINUS_DST_COLOR
   GL_ONE_MINUS_SRC_ALPHA
   GL_ONE_MINUS_SRC_COLOR
   GL_OR
   GL_ORDER
   GL_OR_INVERTED
   GL_OR_REVERSE
   GL_OUT_OF_MEMORY
   GL_PACK_ALIGNMENT
   GL_PACK_IMAGE_HEIGHT_EXT
   GL_PACK_LSB_FIRST
   GL_PACK_ROW_LENGTH
   GL_PACK_SKIP_IMAGES_EXT
   GL_PACK_SKIP_PIXELS
   GL_PACK_SKIP_ROWS
   GL_PACK_SWAP_BYTES
   GL_PASS_THROUGH_TOKEN
   GL_PERSPECTIVE_CORRECTION_HINT
   GL_PIXEL_MAP_A_TO_A
   GL_PIXEL_MAP_A_TO_A_SIZE
   GL_PIXEL_MAP_B_TO_B
   GL_PIXEL_MAP_B_TO_B_SIZE
   GL_PIXEL_MAP_G_TO_G
   GL_PIXEL_MAP_G_TO_G_SIZE
   GL_PIXEL_MAP_I_TO_A
   GL_PIXEL_MAP_I_TO_A_SIZE
   GL_PIXEL_MAP_I_TO_B
   GL_PIXEL_MAP_I_TO_B_SIZE
   GL_PIXEL_MAP_I_TO_G
   GL_PIXEL_MAP_I_TO_G_SIZE
   GL_PIXEL_MAP_I_TO_I
   GL_PIXEL_MAP_I_TO_I_SIZE
   GL_PIXEL_MAP_I_TO_R
   GL_PIXEL_MAP_I_TO_R_SIZE
   GL_PIXEL_MAP_R_TO_R
   GL_PIXEL_MAP_R_TO_R_SIZE
   GL_PIXEL_MAP_S_TO_S
   GL_PIXEL_MAP_S_TO_S_SIZE
   GL_POINT
   GL_POINT_SIZE
   GL_POINT_SIZE_GRANULARITY
   GL_POINT_SIZE_RANGE
   GL_POINT_SMOOTH
   GL_POINT_SMOOTH_HINT
   GL_POINT_TOKEN
   GL_POLYGON_MODE
   GL_POLYGON_OFFSET_BIAS_EXT
   GL_POLYGON_OFFSET_EXT
   GL_POLYGON_OFFSET_FACTOR_EXT
   GL_POLYGON_SMOOTH
   GL_POLYGON_SMOOTH_HINT
   GL_POLYGON_STIPPLE
   GL_POLYGON_TOKEN
   GL_POSITION
   GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
   GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
   GL_POST_CONVOLUTION_BLUE_BIAS_EXT
   GL_POST_CONVOLUTION_BLUE_SCALE_EXT
   GL_POST_CONVOLUTION_GREEN_BIAS_EXT
   GL_POST_CONVOLUTION_GREEN_SCALE_EXT
   GL_POST_CONVOLUTION_RED_BIAS_EXT
   GL_POST_CONVOLUTION_RED_SCALE_EXT
   GL_PROJECTION
   GL_PROJECTION_MATRIX
   GL_PROJECTION_STACK_DEPTH
   GL_PROXY_HISTOGRAM_EXT
   GL_PROXY_TEXTURE_1D_EXT
   GL_PROXY_TEXTURE_2D_EXT
   GL_PROXY_TEXTURE_3D_EXT
   GL_Q
   GL_QUADRATIC_ATTENUATION
   GL_R
   GL_READ_BUFFER
   GL_RED
   GL_REDUCE_EXT
   GL_RED_BIAS
   GL_RED_BITS
   GL_RED_SCALE
   GL_RENDER
   GL_RENDERER
   GL_RENDER_MODE
   GL_REPEAT
   GL_REPLACE
   GL_REPLACE_EXT
   GL_RGB
   GL_RGB10_A2_EXT
   GL_RGB10_EXT
   GL_RGB12_EXT
   GL_RGB16_EXT
   GL_RGB2_EXT
   GL_RGB4_EXT
   GL_RGB5_A1_EXT
   GL_RGB5_EXT
   GL_RGB8_EXT
   GL_RGBA
   GL_RGBA12_EXT
   GL_RGBA16_EXT
   GL_RGBA2_EXT
   GL_RGBA4_EXT
   GL_RGBA8_EXT
   GL_RGBA_MODE
   GL_RIGHT
   GL_S
   GL_SAMPLES_SGIS
   GL_SAMPLE_ALPHA_TO_MASK_SGIS
   GL_SAMPLE_ALPHA_TO_ONE_SGIS
   GL_SAMPLE_BUFFERS_SGIS
   GL_SAMPLE_MASK_INVERT_SGIS
   GL_SAMPLE_MASK_SGIS
   GL_SAMPLE_MASK_VALUE_SGIS
   GL_SAMPLE_PATTERN_SGIS
   GL_SCISSOR_BOX
   GL_SCISSOR_TEST
   GL_SELECT
   GL_SEPARABLE_2D_EXT
   GL_SET
   GL_SHADE_MODEL
   GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS
   GL_SHININESS
   GL_SHORT
   GL_SMOOTH
   GL_SPECULAR
   GL_SPHERE_MAP
   GL_SPOT_CUTOFF
   GL_SPOT_DIRECTION
   GL_SPOT_EXPONENT
   GL_SRC_ALPHA
   GL_SRC_ALPHA_SATURATE
   GL_SRC_COLOR
   GL_STACK_OVERFLOW
   GL_STACK_UNDERFLOW
   GL_STENCIL
   GL_STENCIL_BITS
   GL_STENCIL_CLEAR_VALUE
   GL_STENCIL_FAIL
   GL_STENCIL_FUNC
   GL_STENCIL_INDEX
   GL_STENCIL_PASS_DEPTH_FAIL
   GL_STENCIL_PASS_DEPTH_PASS
   GL_STENCIL_REF
   GL_STENCIL_TEST
   GL_STENCIL_VALUE_MASK
   GL_STENCIL_WRITEMASK
   GL_STEREO
   GL_SUBPIXEL_BITS
   GL_T
   GL_TABLE_TOO_LARGE_EXT
   GL_TEXTURE
   GL_TEXTURE_1D
   GL_TEXTURE_2D
   GL_TEXTURE_3D_EXT
   GL_TEXTURE_ALPHA_SIZE_EXT
   GL_TEXTURE_BLUE_SIZE_EXT
   GL_TEXTURE_BORDER
   GL_TEXTURE_BORDER_COLOR
   GL_TEXTURE_COMPONENTS
   GL_TEXTURE_DEPTH_EXT
   GL_TEXTURE_ENV
   GL_TEXTURE_ENV_COLOR
   GL_TEXTURE_ENV_MODE
   GL_TEXTURE_GEN_MODE
   GL_TEXTURE_GEN_Q
   GL_TEXTURE_GEN_R
   GL_TEXTURE_GEN_S
   GL_TEXTURE_GEN_T
   GL_TEXTURE_GREEN_SIZE_EXT
   GL_TEXTURE_HEIGHT
   GL_TEXTURE_INTENSITY_SIZE_EXT
   GL_TEXTURE_LUMINANCE_SIZE_EXT
   GL_TEXTURE_MAG_FILTER
   GL_TEXTURE_MATRIX
   GL_TEXTURE_MIN_FILTER
   GL_TEXTURE_RED_SIZE_EXT
   GL_TEXTURE_STACK_DEPTH
   GL_TEXTURE_TOO_LARGE_EXT
   GL_TEXTURE_WIDTH
   GL_TEXTURE_WRAP_R_EXT
   GL_TEXTURE_WRAP_S
   GL_TEXTURE_WRAP_T
   GL_UNPACK_ALIGNMENT
   GL_UNPACK_IMAGE_HEIGHT_EXT
   GL_UNPACK_LSB_FIRST
   GL_UNPACK_ROW_LENGTH
   GL_UNPACK_SKIP_IMAGES_EXT
   GL_UNPACK_SKIP_PIXELS
   GL_UNPACK_SKIP_ROWS
   GL_UNPACK_SWAP_BYTES
   GL_UNSIGNED_BYTE
   GL_UNSIGNED_INT
   GL_UNSIGNED_SHORT
   GL_VENDOR
   GL_VERSION
   GL_VIEWPORT
   GL_XOR
   GL_ZERO
   GL_ZOOM_X
   GL_ZOOM_Y
);
our @gl_const = (@gl_const_common, qw(
   GL_1PASS_EXT
   GL_2PASS_0_EXT
   GL_2PASS_1_EXT
   GL_2X_BIT_ATI
   GL_422_AVERAGE_EXT
   GL_422_EXT
   GL_422_REV_AVERAGE_EXT
   GL_422_REV_EXT
   GL_4PASS_0_EXT
   GL_4PASS_1_EXT
   GL_4PASS_2_EXT
   GL_4PASS_3_EXT
   GL_4X_BIT_ATI
   GL_8X_BIT_ATI
   GL_ACTIVE_ATTRIBUTES
   GL_ACTIVE_ATTRIBUTE_MAX_LENGTH
   GL_ACTIVE_STENCIL_FACE_EXT
   GL_ACTIVE_TEXTURE
   GL_ACTIVE_TEXTURE_ARB
   GL_ACTIVE_UNIFORMS
   GL_ACTIVE_UNIFORM_MAX_LENGTH
   GL_ACTIVE_VERTEX_UNITS_ARB
   GL_ADD_ATI
   GL_ADD_SIGNED
   GL_ADD_SIGNED_ARB
   GL_ADD_SIGNED_EXT
   GL_ALIASED_LINE_WIDTH_RANGE
   GL_ALIASED_POINT_SIZE_RANGE
   GL_ALLOW_DRAW_FRG_HINT_PGI
   GL_ALLOW_DRAW_MEM_HINT_PGI
   GL_ALLOW_DRAW_OBJ_HINT_PGI
   GL_ALLOW_DRAW_WIN_HINT_PGI
   GL_ALL_CLIENT_ATTRIB_BITS
   GL_ALL_COMPLETED_NV
   GL_ALPHA12
   GL_ALPHA16
   GL_ALPHA16F_ARB
   GL_ALPHA32F_ARB
   GL_ALPHA4
   GL_ALPHA8
   GL_ALPHA_FLOAT16_ATI
   GL_ALPHA_FLOAT32_ATI
   GL_ALPHA_MAX_CLAMP_INGR
   GL_ALPHA_MAX_SGIX
   GL_ALPHA_MIN_CLAMP_INGR
   GL_ALPHA_MIN_SGIX
   GL_ALWAYS_FAST_HINT_PGI
   GL_ALWAYS_SOFT_HINT_PGI
   GL_ARRAY_BUFFER
   GL_ARRAY_BUFFER_ARB
   GL_ARRAY_BUFFER_BINDING
   GL_ARRAY_BUFFER_BINDING_ARB
   GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
   GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
   GL_ARRAY_OBJECT_BUFFER_ATI
   GL_ARRAY_OBJECT_OFFSET_ATI
   GL_ASYNC_DRAW_PIXELS_SGIX
   GL_ASYNC_HISTOGRAM_SGIX
   GL_ASYNC_MARKER_SGIX
   GL_ASYNC_READ_PIXELS_SGIX
   GL_ASYNC_TEX_IMAGE_SGIX
   GL_ATTACHED_SHADERS
   GL_ATTENUATION_EXT
   GL_ATTRIB_ARRAY_POINTER_NV
   GL_ATTRIB_ARRAY_SIZE_NV
   GL_ATTRIB_ARRAY_STRIDE_NV
   GL_ATTRIB_ARRAY_TYPE_NV
   GL_AVERAGE_EXT
   GL_AVERAGE_HP
   GL_BACK_NORMALS_HINT_PGI
   GL_BGR
   GL_BGRA
   GL_BGRA_EXT
   GL_BGR_EXT
   GL_BIAS_BIT_ATI
   GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
   GL_BINORMAL_ARRAY_EXT
   GL_BINORMAL_ARRAY_POINTER_EXT
   GL_BINORMAL_ARRAY_STRIDE_EXT
   GL_BINORMAL_ARRAY_TYPE_EXT
   GL_BLEND_COLOR
   GL_BLEND_DST_ALPHA
   GL_BLEND_DST_ALPHA_EXT
   GL_BLEND_DST_RGB
   GL_BLEND_DST_RGB_EXT
   GL_BLEND_EQUATION
   GL_BLEND_EQUATION_ALPHA
   GL_BLEND_EQUATION_ALPHA_EXT
   GL_BLEND_EQUATION_RGB
   GL_BLEND_EQUATION_RGB_EXT
   GL_BLEND_SRC_ALPHA
   GL_BLEND_SRC_ALPHA_EXT
   GL_BLEND_SRC_RGB
   GL_BLEND_SRC_RGB_EXT
   GL_BLUE_BIT_ATI
   GL_BLUE_MAX_CLAMP_INGR
   GL_BLUE_MIN_CLAMP_INGR
   GL_BOOL
   GL_BOOL_ARB
   GL_BOOL_VEC2
   GL_BOOL_VEC2_ARB
   GL_BOOL_VEC3
   GL_BOOL_VEC3_ARB
   GL_BOOL_VEC4
   GL_BOOL_VEC4_ARB
   GL_BUFFER_ACCESS
   GL_BUFFER_ACCESS_ARB
   GL_BUFFER_MAPPED
   GL_BUFFER_MAPPED_ARB
   GL_BUFFER_MAP_POINTER
   GL_BUFFER_MAP_POINTER_ARB
   GL_BUFFER_SIZE
   GL_BUFFER_SIZE_ARB
   GL_BUFFER_USAGE
   GL_BUFFER_USAGE_ARB
   GL_BUMP_ENVMAP_ATI
   GL_BUMP_NUM_TEX_UNITS_ATI
   GL_BUMP_ROT_MATRIX_ATI
   GL_BUMP_ROT_MATRIX_SIZE_ATI
   GL_BUMP_TARGET_ATI
   GL_BUMP_TEX_UNITS_ATI
   GL_C3F_V3F
   GL_C4F_N3F_V3F
   GL_C4UB_V2F
   GL_C4UB_V3F
   GL_CALLIGRAPHIC_FRAGMENT_SGIX
   GL_CG_FRAGMENT_SHADER_EXT
   GL_CG_VERTEX_SHADER_EXT
   GL_CLAMP_FRAGMENT_COLOR_ARB
   GL_CLAMP_READ_COLOR_ARB
   GL_CLAMP_TO_BORDER
   GL_CLAMP_TO_BORDER_ARB
   GL_CLAMP_TO_BORDER_SGIS
   GL_CLAMP_TO_EDGE
   GL_CLAMP_TO_EDGE_SGIS
   GL_CLAMP_VERTEX_COLOR_ARB
   GL_CLIENT_ACTIVE_TEXTURE
   GL_CLIENT_ACTIVE_TEXTURE_ARB
   GL_CLIENT_ALL_ATTRIB_BITS
   GL_CLIENT_ATTRIB_STACK_DEPTH
   GL_CLIENT_PIXEL_STORE_BIT
   GL_CLIENT_VERTEX_ARRAY_BIT
   GL_CLIP_FAR_HINT_PGI
   GL_CLIP_NEAR_HINT_PGI
   GL_CLIP_VOLUME_CLIPPING_HINT_EXT
   GL_CMYK
   GL_CMYKA
   GL_CMYKA_EXT
   GL_CMYK_EXT
   GL_CND0_ATI
   GL_CND_ATI
   GL_COLOR3_BIT_PGI
   GL_COLOR4_BIT_PGI
   GL_COLOR_ALPHA_PAIRING_ATI
   GL_COLOR_ARRAY
   GL_COLOR_ARRAY_BUFFER_BINDING
   GL_COLOR_ARRAY_BUFFER_BINDING_ARB
   GL_COLOR_ARRAY_COUNT_EXT
   GL_COLOR_ARRAY_EXT
   GL_COLOR_ARRAY_LIST_IBM
   GL_COLOR_ARRAY_LIST_STRIDE_IBM
   GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL
   GL_COLOR_ARRAY_POINTER
   GL_COLOR_ARRAY_POINTER_EXT
   GL_COLOR_ARRAY_SIZE
   GL_COLOR_ARRAY_SIZE_EXT
   GL_COLOR_ARRAY_STRIDE
   GL_COLOR_ARRAY_STRIDE_EXT
   GL_COLOR_ARRAY_TYPE
   GL_COLOR_ARRAY_TYPE_EXT
   GL_COLOR_ATTACHMENT0_EXT
   GL_COLOR_ATTACHMENT10_EXT
   GL_COLOR_ATTACHMENT11_EXT
   GL_COLOR_ATTACHMENT12_EXT
   GL_COLOR_ATTACHMENT13_EXT
   GL_COLOR_ATTACHMENT14_EXT
   GL_COLOR_ATTACHMENT15_EXT
   GL_COLOR_ATTACHMENT1_EXT
   GL_COLOR_ATTACHMENT2_EXT
   GL_COLOR_ATTACHMENT3_EXT
   GL_COLOR_ATTACHMENT4_EXT
   GL_COLOR_ATTACHMENT5_EXT
   GL_COLOR_ATTACHMENT6_EXT
   GL_COLOR_ATTACHMENT7_EXT
   GL_COLOR_ATTACHMENT8_EXT
   GL_COLOR_ATTACHMENT9_EXT
   GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI
   GL_COLOR_INDEX12_EXT
   GL_COLOR_INDEX16_EXT
   GL_COLOR_INDEX1_EXT
   GL_COLOR_INDEX2_EXT
   GL_COLOR_INDEX4_EXT
   GL_COLOR_INDEX8_EXT
   GL_COLOR_LOGIC_OP
   GL_COLOR_MATRIX
   GL_COLOR_MATRIX_SGI
   GL_COLOR_MATRIX_STACK_DEPTH
   GL_COLOR_MATRIX_STACK_DEPTH_SGI
   GL_COLOR_SUM
   GL_COLOR_SUM_ARB
   GL_COLOR_SUM_CLAMP_NV
   GL_COLOR_SUM_EXT
   GL_COLOR_TABLE
   GL_COLOR_TABLE_ALPHA_SIZE
   GL_COLOR_TABLE_ALPHA_SIZE_EXT
   GL_COLOR_TABLE_ALPHA_SIZE_SGI
   GL_COLOR_TABLE_BIAS
   GL_COLOR_TABLE_BIAS_SGI
   GL_COLOR_TABLE_BLUE_SIZE
   GL_COLOR_TABLE_BLUE_SIZE_EXT
   GL_COLOR_TABLE_BLUE_SIZE_SGI
   GL_COLOR_TABLE_FORMAT
   GL_COLOR_TABLE_FORMAT_EXT
   GL_COLOR_TABLE_FORMAT_SGI
   GL_COLOR_TABLE_GREEN_SIZE
   GL_COLOR_TABLE_GREEN_SIZE_EXT
   GL_COLOR_TABLE_GREEN_SIZE_SGI
   GL_COLOR_TABLE_INTENSITY_SIZE
   GL_COLOR_TABLE_INTENSITY_SIZE_EXT
   GL_COLOR_TABLE_INTENSITY_SIZE_SGI
   GL_COLOR_TABLE_LUMINANCE_SIZE
   GL_COLOR_TABLE_LUMINANCE_SIZE_EXT
   GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
   GL_COLOR_TABLE_RED_SIZE
   GL_COLOR_TABLE_RED_SIZE_EXT
   GL_COLOR_TABLE_RED_SIZE_SGI
   GL_COLOR_TABLE_SCALE
   GL_COLOR_TABLE_SCALE_SGI
   GL_COLOR_TABLE_SGI
   GL_COLOR_TABLE_WIDTH
   GL_COLOR_TABLE_WIDTH_EXT
   GL_COLOR_TABLE_WIDTH_SGI
   GL_COMBINE
   GL_COMBINE4_NV
   GL_COMBINER0_NV
   GL_COMBINER1_NV
   GL_COMBINER2_NV
   GL_COMBINER3_NV
   GL_COMBINER4_NV
   GL_COMBINER5_NV
   GL_COMBINER6_NV
   GL_COMBINER7_NV
   GL_COMBINER_AB_DOT_PRODUCT_NV
   GL_COMBINER_AB_OUTPUT_NV
   GL_COMBINER_BIAS_NV
   GL_COMBINER_CD_DOT_PRODUCT_NV
   GL_COMBINER_CD_OUTPUT_NV
   GL_COMBINER_COMPONENT_USAGE_NV
   GL_COMBINER_INPUT_NV
   GL_COMBINER_MAPPING_NV
   GL_COMBINER_MUX_SUM_NV
   GL_COMBINER_SCALE_NV
   GL_COMBINER_SUM_OUTPUT_NV
   GL_COMBINE_ALPHA
   GL_COMBINE_ALPHA_ARB
   GL_COMBINE_ALPHA_EXT
   GL_COMBINE_ARB
   GL_COMBINE_EXT
   GL_COMBINE_RGB
   GL_COMBINE_RGB_ARB
   GL_COMBINE_RGB_EXT
   GL_COMPARE_R_TO_TEXTURE
   GL_COMPARE_R_TO_TEXTURE_ARB
   GL_COMPILE_STATUS
   GL_COMPRESSED_ALPHA
   GL_COMPRESSED_ALPHA_ARB
   GL_COMPRESSED_INTENSITY
   GL_COMPRESSED_INTENSITY_ARB
   GL_COMPRESSED_LUMINANCE
   GL_COMPRESSED_LUMINANCE_ALPHA
   GL_COMPRESSED_LUMINANCE_ALPHA_ARB
   GL_COMPRESSED_LUMINANCE_ARB
   GL_COMPRESSED_RGB
   GL_COMPRESSED_RGBA
   GL_COMPRESSED_RGBA_ARB
   GL_COMPRESSED_RGBA_FXT1_3DFX
   GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
   GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
   GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
   GL_COMPRESSED_RGB_ARB
   GL_COMPRESSED_RGB_FXT1_3DFX
   GL_COMPRESSED_RGB_S3TC_DXT1_EXT
   GL_COMPRESSED_TEXTURE_FORMATS
   GL_COMPRESSED_TEXTURE_FORMATS_ARB
   GL_COMP_BIT_ATI
   GL_CONSERVE_MEMORY_HINT_PGI
   GL_CONSTANT
   GL_CONSTANT_ALPHA
   GL_CONSTANT_ARB
   GL_CONSTANT_BORDER
   GL_CONSTANT_BORDER_HP
   GL_CONSTANT_COLOR
   GL_CONSTANT_COLOR0_NV
   GL_CONSTANT_COLOR1_NV
   GL_CONSTANT_EXT
   GL_CONST_EYE_NV
   GL_CONVOLUTION_1D
   GL_CONVOLUTION_2D
   GL_CONVOLUTION_BORDER_COLOR
   GL_CONVOLUTION_BORDER_COLOR_HP
   GL_CONVOLUTION_BORDER_MODE
   GL_CONVOLUTION_FILTER_BIAS
   GL_CONVOLUTION_FILTER_SCALE
   GL_CONVOLUTION_FORMAT
   GL_CONVOLUTION_HEIGHT
   GL_CONVOLUTION_HINT_SGIX
   GL_CONVOLUTION_WIDTH
   GL_CON_0_ATI
   GL_CON_10_ATI
   GL_CON_11_ATI
   GL_CON_12_ATI
   GL_CON_13_ATI
   GL_CON_14_ATI
   GL_CON_15_ATI
   GL_CON_16_ATI
   GL_CON_17_ATI
   GL_CON_18_ATI
   GL_CON_19_ATI
   GL_CON_1_ATI
   GL_CON_20_ATI
   GL_CON_21_ATI
   GL_CON_22_ATI
   GL_CON_23_ATI
   GL_CON_24_ATI
   GL_CON_25_ATI
   GL_CON_26_ATI
   GL_CON_27_ATI
   GL_CON_28_ATI
   GL_CON_29_ATI
   GL_CON_2_ATI
   GL_CON_30_ATI
   GL_CON_31_ATI
   GL_CON_3_ATI
   GL_CON_4_ATI
   GL_CON_5_ATI
   GL_CON_6_ATI
   GL_CON_7_ATI
   GL_CON_8_ATI
   GL_CON_9_ATI
   GL_COORD_REPLACE
   GL_COORD_REPLACE_ARB
   GL_COORD_REPLACE_NV
   GL_CUBIC_EXT
   GL_CUBIC_HP
   GL_CULL_FRAGMENT_NV
   GL_CULL_MODES_NV
   GL_CULL_VERTEX_EXT
   GL_CULL_VERTEX_EYE_POSITION_EXT
   GL_CULL_VERTEX_IBM
   GL_CULL_VERTEX_OBJECT_POSITION_EXT
   GL_CURRENT_ATTRIB_NV
   GL_CURRENT_BINORMAL_EXT
   GL_CURRENT_FOG_COORD
   GL_CURRENT_FOG_COORDINATE
   GL_CURRENT_FOG_COORDINATE_EXT
   GL_CURRENT_MATRIX_ARB
   GL_CURRENT_MATRIX_INDEX_ARB
   GL_CURRENT_MATRIX_NV
   GL_CURRENT_MATRIX_STACK_DEPTH_ARB
   GL_CURRENT_MATRIX_STACK_DEPTH_NV
   GL_CURRENT_OCCLUSION_QUERY_ID_NV
   GL_CURRENT_PALETTE_MATRIX_ARB
   GL_CURRENT_PROGRAM
   GL_CURRENT_QUERY
   GL_CURRENT_QUERY_ARB
   GL_CURRENT_RASTER_NORMAL_SGIX
   GL_CURRENT_SECONDARY_COLOR
   GL_CURRENT_SECONDARY_COLOR_EXT
   GL_CURRENT_TANGENT_EXT
   GL_CURRENT_VERTEX_ATTRIB
   GL_CURRENT_VERTEX_ATTRIB_ARB
   GL_CURRENT_VERTEX_EXT
   GL_CURRENT_VERTEX_WEIGHT_EXT
   GL_CURRENT_WEIGHT_ARB
   GL_DECR_WRAP
   GL_DECR_WRAP_EXT
   GL_DEFORMATIONS_MASK_SGIX
   GL_DELETE_STATUS
   GL_DEPENDENT_AR_TEXTURE_2D_NV
   GL_DEPENDENT_GB_TEXTURE_2D_NV
   GL_DEPENDENT_HILO_TEXTURE_2D_NV
   GL_DEPENDENT_RGB_TEXTURE_3D_NV
   GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
   GL_DEPTH_ATTACHMENT_EXT
   GL_DEPTH_BOUNDS_EXT
   GL_DEPTH_BOUNDS_TEST_EXT
   GL_DEPTH_CLAMP_NV
   GL_DEPTH_COMPONENT16
   GL_DEPTH_COMPONENT16_ARB
   GL_DEPTH_COMPONENT16_SGIX
   GL_DEPTH_COMPONENT24
   GL_DEPTH_COMPONENT24_ARB
   GL_DEPTH_COMPONENT24_SGIX
   GL_DEPTH_COMPONENT32
   GL_DEPTH_COMPONENT32_ARB
   GL_DEPTH_COMPONENT32_SGIX
   GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX
   GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX
   GL_DEPTH_PASS_INSTRUMENT_SGIX
   GL_DEPTH_STENCIL_NV
   GL_DEPTH_STENCIL_TO_BGRA_NV
   GL_DEPTH_STENCIL_TO_RGBA_NV
   GL_DEPTH_TEXTURE_MODE
   GL_DEPTH_TEXTURE_MODE_ARB
   GL_DISCARD_ATI
   GL_DISCARD_NV
   GL_DISTANCE_ATTENUATION_EXT
   GL_DISTANCE_ATTENUATION_SGIS
   GL_DOT2_ADD_ATI
   GL_DOT3_ATI
   GL_DOT3_RGB
   GL_DOT3_RGBA
   GL_DOT3_RGBA_ARB
   GL_DOT3_RGBA_EXT
   GL_DOT3_RGB_ARB
   GL_DOT3_RGB_EXT
   GL_DOT4_ATI
   GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
   GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
   GL_DOT_PRODUCT_DEPTH_REPLACE_NV
   GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
   GL_DOT_PRODUCT_NV
   GL_DOT_PRODUCT_PASS_THROUGH_NV
   GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
   GL_DOT_PRODUCT_TEXTURE_1D_NV
   GL_DOT_PRODUCT_TEXTURE_2D_NV
   GL_DOT_PRODUCT_TEXTURE_3D_NV
   GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
   GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
   GL_DOUBLE
   GL_DRAW_BUFFER0
   GL_DRAW_BUFFER0_ARB
   GL_DRAW_BUFFER0_ATI
   GL_DRAW_BUFFER1
   GL_DRAW_BUFFER10
   GL_DRAW_BUFFER10_ARB
   GL_DRAW_BUFFER10_ATI
   GL_DRAW_BUFFER11
   GL_DRAW_BUFFER11_ARB
   GL_DRAW_BUFFER11_ATI
   GL_DRAW_BUFFER12
   GL_DRAW_BUFFER12_ARB
   GL_DRAW_BUFFER12_ATI
   GL_DRAW_BUFFER13
   GL_DRAW_BUFFER13_ARB
   GL_DRAW_BUFFER13_ATI
   GL_DRAW_BUFFER14
   GL_DRAW_BUFFER14_ARB
   GL_DRAW_BUFFER14_ATI
   GL_DRAW_BUFFER15
   GL_DRAW_BUFFER15_ARB
   GL_DRAW_BUFFER15_ATI
   GL_DRAW_BUFFER1_ARB
   GL_DRAW_BUFFER1_ATI
   GL_DRAW_BUFFER2
   GL_DRAW_BUFFER2_ARB
   GL_DRAW_BUFFER2_ATI
   GL_DRAW_BUFFER3
   GL_DRAW_BUFFER3_ARB
   GL_DRAW_BUFFER3_ATI
   GL_DRAW_BUFFER4
   GL_DRAW_BUFFER4_ARB
   GL_DRAW_BUFFER4_ATI
   GL_DRAW_BUFFER5
   GL_DRAW_BUFFER5_ARB
   GL_DRAW_BUFFER5_ATI
   GL_DRAW_BUFFER6
   GL_DRAW_BUFFER6_ARB
   GL_DRAW_BUFFER6_ATI
   GL_DRAW_BUFFER7
   GL_DRAW_BUFFER7_ARB
   GL_DRAW_BUFFER7_ATI
   GL_DRAW_BUFFER8
   GL_DRAW_BUFFER8_ARB
   GL_DRAW_BUFFER8_ATI
   GL_DRAW_BUFFER9
   GL_DRAW_BUFFER9_ARB
   GL_DRAW_BUFFER9_ATI
   GL_DRAW_PIXELS_APPLE
   GL_DSDT8_MAG8_INTENSITY8_NV
   GL_DSDT8_MAG8_NV
   GL_DSDT8_NV
   GL_DSDT_MAG_INTENSITY_NV
   GL_DSDT_MAG_NV
   GL_DSDT_MAG_VIB_NV
   GL_DSDT_NV
   GL_DS_BIAS_NV
   GL_DS_SCALE_NV
   GL_DT_BIAS_NV
   GL_DT_SCALE_NV
   GL_DU8DV8_ATI
   GL_DUAL_ALPHA12_SGIS
   GL_DUAL_ALPHA16_SGIS
   GL_DUAL_ALPHA4_SGIS
   GL_DUAL_ALPHA8_SGIS
   GL_DUAL_INTENSITY12_SGIS
   GL_DUAL_INTENSITY16_SGIS
   GL_DUAL_INTENSITY4_SGIS
   GL_DUAL_INTENSITY8_SGIS
   GL_DUAL_LUMINANCE12_SGIS
   GL_DUAL_LUMINANCE16_SGIS
   GL_DUAL_LUMINANCE4_SGIS
   GL_DUAL_LUMINANCE8_SGIS
   GL_DUAL_LUMINANCE_ALPHA4_SGIS
   GL_DUAL_LUMINANCE_ALPHA8_SGIS
   GL_DUAL_TEXTURE_SELECT_SGIS
   GL_DUDV_ATI
   GL_DYNAMIC_ATI
   GL_DYNAMIC_COPY
   GL_DYNAMIC_COPY_ARB
   GL_DYNAMIC_DRAW
   GL_DYNAMIC_DRAW_ARB
   GL_DYNAMIC_READ
   GL_DYNAMIC_READ_ARB
   GL_EDGEFLAG_BIT_PGI
   GL_EDGE_FLAG_ARRAY
   GL_EDGE_FLAG_ARRAY_BUFFER_BINDING
   GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
   GL_EDGE_FLAG_ARRAY_COUNT_EXT
   GL_EDGE_FLAG_ARRAY_EXT
   GL_EDGE_FLAG_ARRAY_LIST_IBM
   GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
   GL_EDGE_FLAG_ARRAY_POINTER
   GL_EDGE_FLAG_ARRAY_POINTER_EXT
   GL_EDGE_FLAG_ARRAY_STRIDE
   GL_EDGE_FLAG_ARRAY_STRIDE_EXT
   GL_EIGHTH_BIT_ATI
   GL_ELEMENT_ARRAY_APPLE
   GL_ELEMENT_ARRAY_ATI
   GL_ELEMENT_ARRAY_BUFFER
   GL_ELEMENT_ARRAY_BUFFER_ARB
   GL_ELEMENT_ARRAY_BUFFER_BINDING
   GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
   GL_ELEMENT_ARRAY_POINTER_APPLE
   GL_ELEMENT_ARRAY_POINTER_ATI
   GL_ELEMENT_ARRAY_TYPE_APPLE
   GL_ELEMENT_ARRAY_TYPE_ATI
   GL_EMBOSS_CONSTANT_NV
   GL_EMBOSS_LIGHT_NV
   GL_EMBOSS_MAP_NV
   GL_EVAL_2D_NV
   GL_EVAL_FRACTIONAL_TESSELLATION_NV
   GL_EVAL_TRIANGULAR_2D_NV
   GL_EVAL_VERTEX_ATTRIB0_NV
   GL_EVAL_VERTEX_ATTRIB10_NV
   GL_EVAL_VERTEX_ATTRIB11_NV
   GL_EVAL_VERTEX_ATTRIB12_NV
   GL_EVAL_VERTEX_ATTRIB13_NV
   GL_EVAL_VERTEX_ATTRIB14_NV
   GL_EVAL_VERTEX_ATTRIB15_NV
   GL_EVAL_VERTEX_ATTRIB1_NV
   GL_EVAL_VERTEX_ATTRIB2_NV
   GL_EVAL_VERTEX_ATTRIB3_NV
   GL_EVAL_VERTEX_ATTRIB4_NV
   GL_EVAL_VERTEX_ATTRIB5_NV
   GL_EVAL_VERTEX_ATTRIB6_NV
   GL_EVAL_VERTEX_ATTRIB7_NV
   GL_EVAL_VERTEX_ATTRIB8_NV
   GL_EVAL_VERTEX_ATTRIB9_NV
   GL_EXPAND_NEGATE_NV
   GL_EXPAND_NORMAL_NV
   GL_EYE_DISTANCE_TO_LINE_SGIS
   GL_EYE_DISTANCE_TO_POINT_SGIS
   GL_EYE_LINE_SGIS
   GL_EYE_PLANE_ABSOLUTE_NV
   GL_EYE_POINT_SGIS
   GL_EYE_RADIAL_NV
   GL_E_TIMES_F_NV
   GL_FEEDBACK_BUFFER_POINTER
   GL_FEEDBACK_BUFFER_SIZE
   GL_FEEDBACK_BUFFER_TYPE
   GL_FENCE_APPLE
   GL_FENCE_CONDITION_NV
   GL_FENCE_STATUS_NV
   GL_FILTER4_SGIS
   GL_FIXED_ONLY_ARB
   GL_FLOAT_CLEAR_COLOR_VALUE_NV
   GL_FLOAT_MAT2
   GL_FLOAT_MAT2_ARB
   GL_FLOAT_MAT3
   GL_FLOAT_MAT3_ARB
   GL_FLOAT_MAT4
   GL_FLOAT_MAT4_ARB
   GL_FLOAT_R16_NV
   GL_FLOAT_R32_NV
   GL_FLOAT_RG16_NV
   GL_FLOAT_RG32_NV
   GL_FLOAT_RGB16_NV
   GL_FLOAT_RGB32_NV
   GL_FLOAT_RGBA16_NV
   GL_FLOAT_RGBA32_NV
   GL_FLOAT_RGBA_MODE_NV
   GL_FLOAT_RGBA_NV
   GL_FLOAT_RGB_NV
   GL_FLOAT_RG_NV
   GL_FLOAT_R_NV
   GL_FLOAT_VEC2
   GL_FLOAT_VEC2_ARB
   GL_FLOAT_VEC3
   GL_FLOAT_VEC3_ARB
   GL_FLOAT_VEC4
   GL_FLOAT_VEC4_ARB
   GL_FOG_COORD
   GL_FOG_COORDINATE
   GL_FOG_COORDINATE_ARRAY
   GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
   GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
   GL_FOG_COORDINATE_ARRAY_EXT
   GL_FOG_COORDINATE_ARRAY_LIST_IBM
   GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
   GL_FOG_COORDINATE_ARRAY_POINTER
   GL_FOG_COORDINATE_ARRAY_POINTER_EXT
   GL_FOG_COORDINATE_ARRAY_STRIDE
   GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
   GL_FOG_COORDINATE_ARRAY_TYPE
   GL_FOG_COORDINATE_ARRAY_TYPE_EXT
   GL_FOG_COORDINATE_EXT
   GL_FOG_COORDINATE_SOURCE
   GL_FOG_COORDINATE_SOURCE_EXT
   GL_FOG_COORD_ARRAY
   GL_FOG_COORD_ARRAY_BUFFER_BINDING
   GL_FOG_COORD_ARRAY_POINTER
   GL_FOG_COORD_ARRAY_STRIDE
   GL_FOG_COORD_ARRAY_TYPE
   GL_FOG_COORD_SRC
   GL_FOG_DISTANCE_MODE_NV
   GL_FOG_FUNC_POINTS_SGIS
   GL_FOG_FUNC_SGIS
   GL_FOG_OFFSET_SGIX
   GL_FOG_OFFSET_VALUE_SGIX
   GL_FOG_SPECULAR_TEXTURE_WIN
   GL_FORCE_BLUE_TO_ONE_NV
   GL_FORMAT_SUBSAMPLE_244_244_OML
   GL_FORMAT_SUBSAMPLE_24_24_OML
   GL_FRAGMENT_COLOR_EXT
   GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX
   GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX
   GL_FRAGMENT_COLOR_MATERIAL_SGIX
   GL_FRAGMENT_DEPTH
   GL_FRAGMENT_DEPTH_EXT
   GL_FRAGMENT_LIGHT0_SGIX
   GL_FRAGMENT_LIGHT1_SGIX
   GL_FRAGMENT_LIGHT2_SGIX
   GL_FRAGMENT_LIGHT3_SGIX
   GL_FRAGMENT_LIGHT4_SGIX
   GL_FRAGMENT_LIGHT5_SGIX
   GL_FRAGMENT_LIGHT6_SGIX
   GL_FRAGMENT_LIGHT7_SGIX
   GL_FRAGMENT_LIGHTING_SGIX
   GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX
   GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX
   GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX
   GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX
   GL_FRAGMENT_MATERIAL_EXT
   GL_FRAGMENT_NORMAL_EXT
   GL_FRAGMENT_PROGRAM_ARB
   GL_FRAGMENT_PROGRAM_BINDING_NV
   GL_FRAGMENT_PROGRAM_NV
   GL_FRAGMENT_SHADER
   GL_FRAGMENT_SHADER_ARB
   GL_FRAGMENT_SHADER_ATI
   GL_FRAGMENT_SHADER_DERIVATIVE_HINT
   GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB
   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT
   GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT
   GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT
   GL_FRAMEBUFFER_BINDING_EXT
   GL_FRAMEBUFFER_COMPLETE_EXT
   GL_FRAMEBUFFER_EXT
   GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT
   GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT
   GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT
   GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT
   GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT
   GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT
   GL_FRAMEBUFFER_UNSUPPORTED_EXT
   GL_FRAMEZOOM_FACTOR_SGIX
   GL_FRAMEZOOM_SGIX
   GL_FULL_RANGE_EXT
   GL_FULL_STIPPLE_HINT_PGI
   GL_FUNC_ADD
   GL_FUNC_REVERSE_SUBTRACT
   GL_FUNC_SUBTRACT
   GL_GENERATE_MIPMAP
   GL_GENERATE_MIPMAP_HINT
   GL_GENERATE_MIPMAP_HINT_SGIS
   GL_GENERATE_MIPMAP_SGIS
   GL_GEOMETRY_DEFORMATION_BIT_SGIX
   GL_GEOMETRY_DEFORMATION_SGIX
   GL_GLEXT_VERSION
   GL_GLOBAL_ALPHA_FACTOR_SUN
   GL_GLOBAL_ALPHA_SUN
   GL_GREEN_BIT_ATI
   GL_GREEN_MAX_CLAMP_INGR
   GL_GREEN_MIN_CLAMP_INGR
   GL_HALF_BIAS_NEGATE_NV
   GL_HALF_BIAS_NORMAL_NV
   GL_HALF_BIT_ATI
   GL_HALF_FLOAT_ARB
   GL_HALF_FLOAT_NV
   GL_HILO16_NV
   GL_HILO8_NV
   GL_HILO_NV
   GL_HISTOGRAM
   GL_HISTOGRAM_ALPHA_SIZE
   GL_HISTOGRAM_BLUE_SIZE
   GL_HISTOGRAM_FORMAT
   GL_HISTOGRAM_GREEN_SIZE
   GL_HISTOGRAM_LUMINANCE_SIZE
   GL_HISTOGRAM_RED_SIZE
   GL_HISTOGRAM_SINK
   GL_HISTOGRAM_WIDTH
   GL_HI_BIAS_NV
   GL_HI_SCALE_NV
   GL_IDENTITY_NV
   GL_IGNORE_BORDER_HP
   GL_IMAGE_CUBIC_WEIGHT_HP
   GL_IMAGE_MAG_FILTER_HP
   GL_IMAGE_MIN_FILTER_HP
   GL_IMAGE_ROTATE_ANGLE_HP
   GL_IMAGE_ROTATE_ORIGIN_X_HP
   GL_IMAGE_ROTATE_ORIGIN_Y_HP
   GL_IMAGE_SCALE_X_HP
   GL_IMAGE_SCALE_Y_HP
   GL_IMAGE_TRANSFORM_2D_HP
   GL_IMAGE_TRANSLATE_X_HP
   GL_IMAGE_TRANSLATE_Y_HP
   GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES
   GL_IMPLEMENTATION_COLOR_READ_TYPE_OES
   GL_INCR_WRAP
   GL_INCR_WRAP_EXT
   GL_INDEX_ARRAY
   GL_INDEX_ARRAY_BUFFER_BINDING
   GL_INDEX_ARRAY_BUFFER_BINDING_ARB
   GL_INDEX_ARRAY_COUNT_EXT
   GL_INDEX_ARRAY_EXT
   GL_INDEX_ARRAY_LIST_IBM
   GL_INDEX_ARRAY_LIST_STRIDE_IBM
   GL_INDEX_ARRAY_POINTER
   GL_INDEX_ARRAY_POINTER_EXT
   GL_INDEX_ARRAY_STRIDE
   GL_INDEX_ARRAY_STRIDE_EXT
   GL_INDEX_ARRAY_TYPE
   GL_INDEX_ARRAY_TYPE_EXT
   GL_INDEX_BIT_PGI
   GL_INDEX_LOGIC_OP
   GL_INDEX_MATERIAL_EXT
   GL_INDEX_MATERIAL_FACE_EXT
   GL_INDEX_MATERIAL_PARAMETER_EXT
   GL_INDEX_TEST_EXT
   GL_INDEX_TEST_FUNC_EXT
   GL_INDEX_TEST_REF_EXT
   GL_INFO_LOG_LENGTH
   GL_INSTRUMENT_BUFFER_POINTER_SGIX
   GL_INSTRUMENT_MEASUREMENTS_SGIX
   GL_INTENSITY
   GL_INTENSITY12
   GL_INTENSITY16
   GL_INTENSITY16F_ARB
   GL_INTENSITY32F_ARB
   GL_INTENSITY4
   GL_INTENSITY8
   GL_INTENSITY_FLOAT16_ATI
   GL_INTENSITY_FLOAT32_ATI
   GL_INTERLACE_OML
   GL_INTERLACE_READ_INGR
   GL_INTERLACE_READ_OML
   GL_INTERLACE_SGIX
   GL_INTERPOLATE
   GL_INTERPOLATE_ARB
   GL_INTERPOLATE_EXT
   GL_INT_VEC2
   GL_INT_VEC2_ARB
   GL_INT_VEC3
   GL_INT_VEC3_ARB
   GL_INT_VEC4
   GL_INT_VEC4_ARB
   GL_INVALID_FRAMEBUFFER_OPERATION_EXT
   GL_INVARIANT_DATATYPE_EXT
   GL_INVARIANT_EXT
   GL_INVARIANT_VALUE_EXT
   GL_INVERSE_NV
   GL_INVERSE_TRANSPOSE_NV
   GL_INVERTED_SCREEN_W_REND
   GL_IR_INSTRUMENT1_SGIX
   GL_IUI_N3F_V2F_EXT
   GL_IUI_N3F_V3F_EXT
   GL_IUI_V2F_EXT
   GL_IUI_V3F_EXT
   GL_LERP_ATI
   GL_LIGHT_ENV_MODE_SGIX
   GL_LIGHT_MODEL_COLOR_CONTROL
   GL_LIGHT_MODEL_COLOR_CONTROL_EXT
   GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE
   GL_LINEAR_CLIPMAP_LINEAR_SGIX
   GL_LINEAR_CLIPMAP_NEAREST_SGIX
   GL_LINK_STATUS
   GL_LIST_PRIORITY_SGIX
   GL_LOCAL_CONSTANT_DATATYPE_EXT
   GL_LOCAL_CONSTANT_EXT
   GL_LOCAL_CONSTANT_VALUE_EXT
   GL_LOCAL_EXT
   GL_LOWER_LEFT
   GL_LO_BIAS_NV
   GL_LO_SCALE_NV
   GL_LUMINANCE12
   GL_LUMINANCE12_ALPHA12
   GL_LUMINANCE12_ALPHA4
   GL_LUMINANCE16
   GL_LUMINANCE16F_ARB
   GL_LUMINANCE16_ALPHA16
   GL_LUMINANCE32F_ARB
   GL_LUMINANCE4
   GL_LUMINANCE4_ALPHA4
   GL_LUMINANCE6_ALPHA2
   GL_LUMINANCE8
   GL_LUMINANCE8_ALPHA8
   GL_LUMINANCE_ALPHA16F_ARB
   GL_LUMINANCE_ALPHA32F_ARB
   GL_LUMINANCE_ALPHA_FLOAT16_ATI
   GL_LUMINANCE_ALPHA_FLOAT32_ATI
   GL_LUMINANCE_FLOAT16_ATI
   GL_LUMINANCE_FLOAT32_ATI
   GL_MAD_ATI
   GL_MAGNITUDE_BIAS_NV
   GL_MAGNITUDE_SCALE_NV
   GL_MAP1_BINORMAL_EXT
   GL_MAP1_TANGENT_EXT
   GL_MAP1_VERTEX_ATTRIB0_4_NV
   GL_MAP1_VERTEX_ATTRIB10_4_NV
   GL_MAP1_VERTEX_ATTRIB11_4_NV
   GL_MAP1_VERTEX_ATTRIB12_4_NV
   GL_MAP1_VERTEX_ATTRIB13_4_NV
   GL_MAP1_VERTEX_ATTRIB14_4_NV
   GL_MAP1_VERTEX_ATTRIB15_4_NV
   GL_MAP1_VERTEX_ATTRIB1_4_NV
   GL_MAP1_VERTEX_ATTRIB2_4_NV
   GL_MAP1_VERTEX_ATTRIB3_4_NV
   GL_MAP1_VERTEX_ATTRIB4_4_NV
   GL_MAP1_VERTEX_ATTRIB5_4_NV
   GL_MAP1_VERTEX_ATTRIB6_4_NV
   GL_MAP1_VERTEX_ATTRIB7_4_NV
   GL_MAP1_VERTEX_ATTRIB8_4_NV
   GL_MAP1_VERTEX_ATTRIB9_4_NV
   GL_MAP2_BINORMAL_EXT
   GL_MAP2_TANGENT_EXT
   GL_MAP2_VERTEX_ATTRIB0_4_NV
   GL_MAP2_VERTEX_ATTRIB10_4_NV
   GL_MAP2_VERTEX_ATTRIB11_4_NV
   GL_MAP2_VERTEX_ATTRIB12_4_NV
   GL_MAP2_VERTEX_ATTRIB13_4_NV
   GL_MAP2_VERTEX_ATTRIB14_4_NV
   GL_MAP2_VERTEX_ATTRIB15_4_NV
   GL_MAP2_VERTEX_ATTRIB1_4_NV
   GL_MAP2_VERTEX_ATTRIB2_4_NV
   GL_MAP2_VERTEX_ATTRIB3_4_NV
   GL_MAP2_VERTEX_ATTRIB4_4_NV
   GL_MAP2_VERTEX_ATTRIB5_4_NV
   GL_MAP2_VERTEX_ATTRIB6_4_NV
   GL_MAP2_VERTEX_ATTRIB7_4_NV
   GL_MAP2_VERTEX_ATTRIB8_4_NV
   GL_MAP2_VERTEX_ATTRIB9_4_NV
   GL_MAP_ATTRIB_U_ORDER_NV
   GL_MAP_ATTRIB_V_ORDER_NV
   GL_MAP_TESSELLATION_NV
   GL_MATERIAL_SIDE_HINT_PGI
   GL_MATRIX0_ARB
   GL_MATRIX0_NV
   GL_MATRIX10_ARB
   GL_MATRIX11_ARB
   GL_MATRIX12_ARB
   GL_MATRIX13_ARB
   GL_MATRIX14_ARB
   GL_MATRIX15_ARB
   GL_MATRIX16_ARB
   GL_MATRIX17_ARB
   GL_MATRIX18_ARB
   GL_MATRIX19_ARB
   GL_MATRIX1_ARB
   GL_MATRIX1_NV
   GL_MATRIX20_ARB
   GL_MATRIX21_ARB
   GL_MATRIX22_ARB
   GL_MATRIX23_ARB
   GL_MATRIX24_ARB
   GL_MATRIX25_ARB
   GL_MATRIX26_ARB
   GL_MATRIX27_ARB
   GL_MATRIX28_ARB
   GL_MATRIX29_ARB
   GL_MATRIX2_ARB
   GL_MATRIX2_NV
   GL_MATRIX30_ARB
   GL_MATRIX31_ARB
   GL_MATRIX3_ARB
   GL_MATRIX3_NV
   GL_MATRIX4_ARB
   GL_MATRIX4_NV
   GL_MATRIX5_ARB
   GL_MATRIX5_NV
   GL_MATRIX6_ARB
   GL_MATRIX6_NV
   GL_MATRIX7_ARB
   GL_MATRIX7_NV
   GL_MATRIX8_ARB
   GL_MATRIX9_ARB
   GL_MATRIX_EXT
   GL_MATRIX_INDEX_ARRAY_ARB
   GL_MATRIX_INDEX_ARRAY_POINTER_ARB
   GL_MATRIX_INDEX_ARRAY_SIZE_ARB
   GL_MATRIX_INDEX_ARRAY_STRIDE_ARB
   GL_MATRIX_INDEX_ARRAY_TYPE_ARB
   GL_MATRIX_PALETTE_ARB
   GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI
   GL_MAT_AMBIENT_BIT_PGI
   GL_MAT_COLOR_INDEXES_BIT_PGI
   GL_MAT_DIFFUSE_BIT_PGI
   GL_MAT_EMISSION_BIT_PGI
   GL_MAT_SHININESS_BIT_PGI
   GL_MAT_SPECULAR_BIT_PGI
   GL_MAX
   GL_MAX_3D_TEXTURE_SIZE
   GL_MAX_4D_TEXTURE_SIZE_SGIS
   GL_MAX_ACTIVE_LIGHTS_SGIX
   GL_MAX_ASYNC_DRAW_PIXELS_SGIX
   GL_MAX_ASYNC_HISTOGRAM_SGIX
   GL_MAX_ASYNC_READ_PIXELS_SGIX
   GL_MAX_ASYNC_TEX_IMAGE_SGIX
   GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
   GL_MAX_CLIPMAP_DEPTH_SGIX
   GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX
   GL_MAX_COLOR_ATTACHMENTS_EXT
   GL_MAX_COLOR_MATRIX_STACK_DEPTH
   GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
   GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS
   GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
   GL_MAX_CONVOLUTION_HEIGHT
   GL_MAX_CONVOLUTION_WIDTH
   GL_MAX_CUBE_MAP_TEXTURE_SIZE
   GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
   GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT
   GL_MAX_DEFORMATION_ORDER_SGIX
   GL_MAX_DRAW_BUFFERS
   GL_MAX_DRAW_BUFFERS_ARB
   GL_MAX_DRAW_BUFFERS_ATI
   GL_MAX_ELEMENTS_INDICES
   GL_MAX_ELEMENTS_INDICES_EXT
   GL_MAX_ELEMENTS_VERTICES
   GL_MAX_ELEMENTS_VERTICES_EXT
   GL_MAX_FOG_FUNC_POINTS_SGIS
   GL_MAX_FRAGMENT_LIGHTS_SGIX
   GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
   GL_MAX_FRAGMENT_UNIFORM_COMPONENTS
   GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
   GL_MAX_FRAMEZOOM_FACTOR_SGIX
   GL_MAX_GENERAL_COMBINERS_NV
   GL_MAX_MAP_TESSELLATION_NV
   GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
   GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
   GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
   GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
   GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
   GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
   GL_MAX_PALETTE_MATRICES_ARB
   GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
   GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
   GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
   GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
   GL_MAX_PROGRAM_ATTRIBS_ARB
   GL_MAX_PROGRAM_CALL_DEPTH_NV
   GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
   GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV
   GL_MAX_PROGRAM_IF_DEPTH_NV
   GL_MAX_PROGRAM_INSTRUCTIONS_ARB
   GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
   GL_MAX_PROGRAM_LOOP_COUNT_NV
   GL_MAX_PROGRAM_LOOP_DEPTH_NV
   GL_MAX_PROGRAM_MATRICES_ARB
   GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
   GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
   GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
   GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
   GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
   GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
   GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
   GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
   GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
   GL_MAX_PROGRAM_PARAMETERS_ARB
   GL_MAX_PROGRAM_TEMPORARIES_ARB
   GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
   GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
   GL_MAX_RATIONAL_EVAL_ORDER_NV
   GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB
   GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
   GL_MAX_RENDERBUFFER_SIZE_EXT
   GL_MAX_SHININESS_NV
   GL_MAX_SPOT_EXPONENT_NV
   GL_MAX_TEXTURE_COORDS
   GL_MAX_TEXTURE_COORDS_ARB
   GL_MAX_TEXTURE_COORDS_NV
   GL_MAX_TEXTURE_IMAGE_UNITS
   GL_MAX_TEXTURE_IMAGE_UNITS_ARB
   GL_MAX_TEXTURE_IMAGE_UNITS_NV
   GL_MAX_TEXTURE_LOD_BIAS
   GL_MAX_TEXTURE_LOD_BIAS_EXT
   GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
   GL_MAX_TEXTURE_UNITS
   GL_MAX_TEXTURE_UNITS_ARB
   GL_MAX_TRACK_MATRICES_NV
   GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
   GL_MAX_VARYING_FLOATS
   GL_MAX_VARYING_FLOATS_ARB
   GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
   GL_MAX_VERTEX_ATTRIBS
   GL_MAX_VERTEX_ATTRIBS_ARB
   GL_MAX_VERTEX_HINT_PGI
   GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
   GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
   GL_MAX_VERTEX_SHADER_LOCALS_EXT
   GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
   GL_MAX_VERTEX_SHADER_VARIANTS_EXT
   GL_MAX_VERTEX_STREAMS_ATI
   GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS
   GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
   GL_MAX_VERTEX_UNIFORM_COMPONENTS
   GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
   GL_MAX_VERTEX_UNITS_ARB
   GL_MIN
   GL_MINMAX
   GL_MINMAX_FORMAT
   GL_MINMAX_SINK
   GL_MIRRORED_REPEAT
   GL_MIRRORED_REPEAT_ARB
   GL_MIRRORED_REPEAT_IBM
   GL_MIRROR_CLAMP_ATI
   GL_MIRROR_CLAMP_EXT
   GL_MIRROR_CLAMP_TO_BORDER_EXT
   GL_MIRROR_CLAMP_TO_EDGE_ATI
   GL_MIRROR_CLAMP_TO_EDGE_EXT
   GL_MISC_BIT_EXT
   GL_MODELVIEW0_ARB
   GL_MODELVIEW0_EXT
   GL_MODELVIEW0_MATRIX_EXT
   GL_MODELVIEW0_STACK_DEPTH_EXT
   GL_MODELVIEW10_ARB
   GL_MODELVIEW11_ARB
   GL_MODELVIEW12_ARB
   GL_MODELVIEW13_ARB
   GL_MODELVIEW14_ARB
   GL_MODELVIEW15_ARB
   GL_MODELVIEW16_ARB
   GL_MODELVIEW17_ARB
   GL_MODELVIEW18_ARB
   GL_MODELVIEW19_ARB
   GL_MODELVIEW1_ARB
   GL_MODELVIEW1_EXT
   GL_MODELVIEW1_MATRIX_EXT
   GL_MODELVIEW1_STACK_DEPTH_EXT
   GL_MODELVIEW20_ARB
   GL_MODELVIEW21_ARB
   GL_MODELVIEW22_ARB
   GL_MODELVIEW23_ARB
   GL_MODELVIEW24_ARB
   GL_MODELVIEW25_ARB
   GL_MODELVIEW26_ARB
   GL_MODELVIEW27_ARB
   GL_MODELVIEW28_ARB
   GL_MODELVIEW29_ARB
   GL_MODELVIEW2_ARB
   GL_MODELVIEW30_ARB
   GL_MODELVIEW31_ARB
   GL_MODELVIEW3_ARB
   GL_MODELVIEW4_ARB
   GL_MODELVIEW5_ARB
   GL_MODELVIEW6_ARB
   GL_MODELVIEW7_ARB
   GL_MODELVIEW8_ARB
   GL_MODELVIEW9_ARB
   GL_MODELVIEW_PROJECTION_NV
   GL_MODULATE_ADD_ATI
   GL_MODULATE_SIGNED_ADD_ATI
   GL_MODULATE_SUBTRACT_ATI
   GL_MOV_ATI
   GL_MULTISAMPLE
   GL_MULTISAMPLE_3DFX
   GL_MULTISAMPLE_ARB
   GL_MULTISAMPLE_BIT
   GL_MULTISAMPLE_BIT_3DFX
   GL_MULTISAMPLE_BIT_ARB
   GL_MULTISAMPLE_EXT
   GL_MULTISAMPLE_FILTER_HINT_NV
   GL_MUL_ATI
   GL_MVP_MATRIX_EXT
   GL_N3F_V3F
   GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI
   GL_NATIVE_GRAPHICS_END_HINT_PGI
   GL_NATIVE_GRAPHICS_HANDLE_PGI
   GL_NEAREST_CLIPMAP_LINEAR_SGIX
   GL_NEAREST_CLIPMAP_NEAREST_SGIX
   GL_NEGATE_BIT_ATI
   GL_NEGATIVE_ONE_EXT
   GL_NEGATIVE_W_EXT
   GL_NEGATIVE_X_EXT
   GL_NEGATIVE_Y_EXT
   GL_NEGATIVE_Z_EXT
   GL_NORMALIZED_RANGE_EXT
   GL_NORMAL_ARRAY
   GL_NORMAL_ARRAY_BUFFER_BINDING
   GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
   GL_NORMAL_ARRAY_COUNT_EXT
   GL_NORMAL_ARRAY_EXT
   GL_NORMAL_ARRAY_LIST_IBM
   GL_NORMAL_ARRAY_LIST_STRIDE_IBM
   GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL
   GL_NORMAL_ARRAY_POINTER
   GL_NORMAL_ARRAY_POINTER_EXT
   GL_NORMAL_ARRAY_STRIDE
   GL_NORMAL_ARRAY_STRIDE_EXT
   GL_NORMAL_ARRAY_TYPE
   GL_NORMAL_ARRAY_TYPE_EXT
   GL_NORMAL_BIT_PGI
   GL_NORMAL_MAP
   GL_NORMAL_MAP_ARB
   GL_NORMAL_MAP_EXT
   GL_NORMAL_MAP_NV
   GL_NUM_COMPRESSED_TEXTURE_FORMATS
   GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
   GL_NUM_FRAGMENT_CONSTANTS_ATI
   GL_NUM_FRAGMENT_REGISTERS_ATI
   GL_NUM_GENERAL_COMBINERS_NV
   GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI
   GL_NUM_INSTRUCTIONS_PER_PASS_ATI
   GL_NUM_INSTRUCTIONS_TOTAL_ATI
   GL_NUM_LOOPBACK_COMPONENTS_ATI
   GL_NUM_PASSES_ATI
   GL_OBJECT_ACTIVE_ATTRIBUTES_ARB
   GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
   GL_OBJECT_ACTIVE_UNIFORMS_ARB
   GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB
   GL_OBJECT_ATTACHED_OBJECTS_ARB
   GL_OBJECT_BUFFER_SIZE_ATI
   GL_OBJECT_BUFFER_USAGE_ATI
   GL_OBJECT_COMPILE_STATUS_ARB
   GL_OBJECT_DELETE_STATUS_ARB
   GL_OBJECT_DISTANCE_TO_LINE_SGIS
   GL_OBJECT_DISTANCE_TO_POINT_SGIS
   GL_OBJECT_INFO_LOG_LENGTH_ARB
   GL_OBJECT_LINE_SGIS
   GL_OBJECT_LINK_STATUS_ARB
   GL_OBJECT_POINT_SGIS
   GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
   GL_OBJECT_SUBTYPE_ARB
   GL_OBJECT_TYPE_ARB
   GL_OBJECT_VALIDATE_STATUS_ARB
   GL_OCCLUSION_TEST_HP
   GL_OCCLUSION_TEST_RESULT_HP
   GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
   GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
   GL_OFFSET_HILO_TEXTURE_2D_NV
   GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
   GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
   GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
   GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
   GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
   GL_OFFSET_TEXTURE_2D_BIAS_NV
   GL_OFFSET_TEXTURE_2D_MATRIX_NV
   GL_OFFSET_TEXTURE_2D_NV
   GL_OFFSET_TEXTURE_2D_SCALE_NV
   GL_OFFSET_TEXTURE_BIAS_NV
   GL_OFFSET_TEXTURE_MATRIX_NV
   GL_OFFSET_TEXTURE_RECTANGLE_NV
   GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
   GL_OFFSET_TEXTURE_SCALE_NV
   GL_ONE_EXT
   GL_ONE_MINUS_CONSTANT_ALPHA
   GL_ONE_MINUS_CONSTANT_COLOR
   GL_OPERAND0_ALPHA
   GL_OPERAND0_ALPHA_ARB
   GL_OPERAND0_ALPHA_EXT
   GL_OPERAND0_RGB
   GL_OPERAND0_RGB_ARB
   GL_OPERAND0_RGB_EXT
   GL_OPERAND1_ALPHA
   GL_OPERAND1_ALPHA_ARB
   GL_OPERAND1_ALPHA_EXT
   GL_OPERAND1_RGB
   GL_OPERAND1_RGB_ARB
   GL_OPERAND1_RGB_EXT
   GL_OPERAND2_ALPHA
   GL_OPERAND2_ALPHA_ARB
   GL_OPERAND2_ALPHA_EXT
   GL_OPERAND2_RGB
   GL_OPERAND2_RGB_ARB
   GL_OPERAND2_RGB_EXT
   GL_OPERAND3_ALPHA_NV
   GL_OPERAND3_RGB_NV
   GL_OP_ADD_EXT
   GL_OP_CLAMP_EXT
   GL_OP_CROSS_PRODUCT_EXT
   GL_OP_DOT3_EXT
   GL_OP_DOT4_EXT
   GL_OP_EXP_BASE_2_EXT
   GL_OP_FLOOR_EXT
   GL_OP_FRAC_EXT
   GL_OP_INDEX_EXT
   GL_OP_LOG_BASE_2_EXT
   GL_OP_MADD_EXT
   GL_OP_MAX_EXT
   GL_OP_MIN_EXT
   GL_OP_MOV_EXT
   GL_OP_MULTIPLY_MATRIX_EXT
   GL_OP_MUL_EXT
   GL_OP_NEGATE_EXT
   GL_OP_POWER_EXT
   GL_OP_RECIP_EXT
   GL_OP_RECIP_SQRT_EXT
   GL_OP_ROUND_EXT
   GL_OP_SET_GE_EXT
   GL_OP_SET_LT_EXT
   GL_OP_SUB_EXT
   GL_OUTPUT_COLOR0_EXT
   GL_OUTPUT_COLOR1_EXT
   GL_OUTPUT_FOG_EXT
   GL_OUTPUT_TEXTURE_COORD0_EXT
   GL_OUTPUT_TEXTURE_COORD10_EXT
   GL_OUTPUT_TEXTURE_COORD11_EXT
   GL_OUTPUT_TEXTURE_COORD12_EXT
   GL_OUTPUT_TEXTURE_COORD13_EXT
   GL_OUTPUT_TEXTURE_COORD14_EXT
   GL_OUTPUT_TEXTURE_COORD15_EXT
   GL_OUTPUT_TEXTURE_COORD16_EXT
   GL_OUTPUT_TEXTURE_COORD17_EXT
   GL_OUTPUT_TEXTURE_COORD18_EXT
   GL_OUTPUT_TEXTURE_COORD19_EXT
   GL_OUTPUT_TEXTURE_COORD1_EXT
   GL_OUTPUT_TEXTURE_COORD20_EXT
   GL_OUTPUT_TEXTURE_COORD21_EXT
   GL_OUTPUT_TEXTURE_COORD22_EXT
   GL_OUTPUT_TEXTURE_COORD23_EXT
   GL_OUTPUT_TEXTURE_COORD24_EXT
   GL_OUTPUT_TEXTURE_COORD25_EXT
   GL_OUTPUT_TEXTURE_COORD26_EXT
   GL_OUTPUT_TEXTURE_COORD27_EXT
   GL_OUTPUT_TEXTURE_COORD28_EXT
   GL_OUTPUT_TEXTURE_COORD29_EXT
   GL_OUTPUT_TEXTURE_COORD2_EXT
   GL_OUTPUT_TEXTURE_COORD30_EXT
   GL_OUTPUT_TEXTURE_COORD31_EXT
   GL_OUTPUT_TEXTURE_COORD3_EXT
   GL_OUTPUT_TEXTURE_COORD4_EXT
   GL_OUTPUT_TEXTURE_COORD5_EXT
   GL_OUTPUT_TEXTURE_COORD6_EXT
   GL_OUTPUT_TEXTURE_COORD7_EXT
   GL_OUTPUT_TEXTURE_COORD8_EXT
   GL_OUTPUT_TEXTURE_COORD9_EXT
   GL_OUTPUT_VERTEX_EXT
   GL_PACK_CMYK_HINT
   GL_PACK_CMYK_HINT_EXT
   GL_PACK_IMAGE_DEPTH_SGIS
   GL_PACK_IMAGE_HEIGHT
   GL_PACK_INVERT_MESA
   GL_PACK_RESAMPLE_OML
   GL_PACK_RESAMPLE_SGIX
   GL_PACK_SKIP_IMAGES
   GL_PACK_SKIP_VOLUMES_SGIS
   GL_PACK_SUBSAMPLE_RATE_SGIX
   GL_PARALLEL_ARRAYS_INTEL
   GL_PASS_THROUGH_NV
   GL_PERTURB_EXT
   GL_PER_STAGE_CONSTANTS_NV
   GL_PHONG_HINT_WIN
   GL_PHONG_WIN
   GL_PIXEL_COUNTER_BITS_NV
   GL_PIXEL_COUNT_AVAILABLE_NV
   GL_PIXEL_COUNT_NV
   GL_PIXEL_CUBIC_WEIGHT_EXT
   GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS
   GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS
   GL_PIXEL_GROUP_COLOR_SGIS
   GL_PIXEL_MAG_FILTER_EXT
   GL_PIXEL_MIN_FILTER_EXT
   GL_PIXEL_PACK_BUFFER_ARB
   GL_PIXEL_PACK_BUFFER_BINDING_ARB
   GL_PIXEL_PACK_BUFFER_BINDING_EXT
   GL_PIXEL_PACK_BUFFER_EXT
   GL_PIXEL_SUBSAMPLE_2424_SGIX
   GL_PIXEL_SUBSAMPLE_4242_SGIX
   GL_PIXEL_SUBSAMPLE_4444_SGIX
   GL_PIXEL_TEXTURE_SGIS
   GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX
   GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX
   GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX
   GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX
   GL_PIXEL_TEX_GEN_MODE_SGIX
   GL_PIXEL_TEX_GEN_Q_CEILING_SGIX
   GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX
   GL_PIXEL_TEX_GEN_Q_ROUND_SGIX
   GL_PIXEL_TEX_GEN_SGIX
   GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX
   GL_PIXEL_TILE_CACHE_INCREMENT_SGIX
   GL_PIXEL_TILE_CACHE_SIZE_SGIX
   GL_PIXEL_TILE_GRID_DEPTH_SGIX
   GL_PIXEL_TILE_GRID_HEIGHT_SGIX
   GL_PIXEL_TILE_GRID_WIDTH_SGIX
   GL_PIXEL_TILE_HEIGHT_SGIX
   GL_PIXEL_TILE_WIDTH_SGIX
   GL_PIXEL_TRANSFORM_2D_EXT
   GL_PIXEL_TRANSFORM_2D_MATRIX_EXT
   GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
   GL_PIXEL_UNPACK_BUFFER_ARB
   GL_PIXEL_UNPACK_BUFFER_BINDING_ARB
   GL_PIXEL_UNPACK_BUFFER_BINDING_EXT
   GL_PIXEL_UNPACK_BUFFER_EXT
   GL_PN_TRIANGLES_ATI
   GL_PN_TRIANGLES_NORMAL_MODE_ATI
   GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
   GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
   GL_PN_TRIANGLES_POINT_MODE_ATI
   GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
   GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
   GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
   GL_POINT_DISTANCE_ATTENUATION
   GL_POINT_DISTANCE_ATTENUATION_ARB
   GL_POINT_FADE_THRESHOLD_SIZE
   GL_POINT_FADE_THRESHOLD_SIZE_ARB
   GL_POINT_FADE_THRESHOLD_SIZE_EXT
   GL_POINT_FADE_THRESHOLD_SIZE_SGIS
   GL_POINT_SIZE_MAX
   GL_POINT_SIZE_MAX_ARB
   GL_POINT_SIZE_MAX_EXT
   GL_POINT_SIZE_MAX_SGIS
   GL_POINT_SIZE_MIN
   GL_POINT_SIZE_MIN_ARB
   GL_POINT_SIZE_MIN_EXT
   GL_POINT_SIZE_MIN_SGIS
   GL_POINT_SPRITE
   GL_POINT_SPRITE_ARB
   GL_POINT_SPRITE_COORD_ORIGIN
   GL_POINT_SPRITE_NV
   GL_POINT_SPRITE_R_MODE_NV
   GL_POLYGON_OFFSET_FACTOR
   GL_POLYGON_OFFSET_FILL
   GL_POLYGON_OFFSET_LINE
   GL_POLYGON_OFFSET_POINT
   GL_POLYGON_OFFSET_UNITS
   GL_POST_COLOR_MATRIX_ALPHA_BIAS
   GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
   GL_POST_COLOR_MATRIX_ALPHA_SCALE
   GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
   GL_POST_COLOR_MATRIX_BLUE_BIAS
   GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
   GL_POST_COLOR_MATRIX_BLUE_SCALE
   GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
   GL_POST_COLOR_MATRIX_COLOR_TABLE
   GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
   GL_POST_COLOR_MATRIX_GREEN_BIAS
   GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
   GL_POST_COLOR_MATRIX_GREEN_SCALE
   GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
   GL_POST_COLOR_MATRIX_RED_BIAS
   GL_POST_COLOR_MATRIX_RED_BIAS_SGI
   GL_POST_COLOR_MATRIX_RED_SCALE
   GL_POST_COLOR_MATRIX_RED_SCALE_SGI
   GL_POST_CONVOLUTION_ALPHA_BIAS
   GL_POST_CONVOLUTION_ALPHA_SCALE
   GL_POST_CONVOLUTION_BLUE_BIAS
   GL_POST_CONVOLUTION_BLUE_SCALE
   GL_POST_CONVOLUTION_COLOR_TABLE
   GL_POST_CONVOLUTION_COLOR_TABLE_SGI
   GL_POST_CONVOLUTION_GREEN_BIAS
   GL_POST_CONVOLUTION_GREEN_SCALE
   GL_POST_CONVOLUTION_RED_BIAS
   GL_POST_CONVOLUTION_RED_SCALE
   GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
   GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX
   GL_POST_TEXTURE_FILTER_BIAS_SGIX
   GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX
   GL_POST_TEXTURE_FILTER_SCALE_SGIX
   GL_PREFER_DOUBLEBUFFER_HINT_PGI
   GL_PRESERVE_ATI
   GL_PREVIOUS
   GL_PREVIOUS_ARB
   GL_PREVIOUS_EXT
   GL_PREVIOUS_TEXTURE_INPUT_NV
   GL_PRIMARY_COLOR
   GL_PRIMARY_COLOR_ARB
   GL_PRIMARY_COLOR_EXT
   GL_PRIMARY_COLOR_NV
   GL_PRIMITIVE_RESTART_INDEX_NV
   GL_PRIMITIVE_RESTART_NV
   GL_PROGRAM_ADDRESS_REGISTERS_ARB
   GL_PROGRAM_ALU_INSTRUCTIONS_ARB
   GL_PROGRAM_ATTRIBS_ARB
   GL_PROGRAM_BINDING_ARB
   GL_PROGRAM_ERROR_POSITION_ARB
   GL_PROGRAM_ERROR_POSITION_NV
   GL_PROGRAM_ERROR_STRING_ARB
   GL_PROGRAM_ERROR_STRING_NV
   GL_PROGRAM_FORMAT_ARB
   GL_PROGRAM_FORMAT_ASCII_ARB
   GL_PROGRAM_INSTRUCTIONS_ARB
   GL_PROGRAM_LENGTH_ARB
   GL_PROGRAM_LENGTH_NV
   GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
   GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
   GL_PROGRAM_NATIVE_ATTRIBS_ARB
   GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
   GL_PROGRAM_NATIVE_PARAMETERS_ARB
   GL_PROGRAM_NATIVE_TEMPORARIES_ARB
   GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
   GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
   GL_PROGRAM_OBJECT_ARB
   GL_PROGRAM_PARAMETERS_ARB
   GL_PROGRAM_PARAMETER_NV
   GL_PROGRAM_RESIDENT_NV
   GL_PROGRAM_STRING_ARB
   GL_PROGRAM_STRING_NV
   GL_PROGRAM_TARGET_NV
   GL_PROGRAM_TEMPORARIES_ARB
   GL_PROGRAM_TEX_INDIRECTIONS_ARB
   GL_PROGRAM_TEX_INSTRUCTIONS_ARB
   GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
   GL_PROXY_COLOR_TABLE
   GL_PROXY_COLOR_TABLE_SGI
   GL_PROXY_HISTOGRAM
   GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
   GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
   GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
   GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
   GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
   GL_PROXY_TEXTURE_1D
   GL_PROXY_TEXTURE_2D
   GL_PROXY_TEXTURE_3D
   GL_PROXY_TEXTURE_4D_SGIS
   GL_PROXY_TEXTURE_COLOR_TABLE_SGI
   GL_PROXY_TEXTURE_CUBE_MAP
   GL_PROXY_TEXTURE_CUBE_MAP_ARB
   GL_PROXY_TEXTURE_CUBE_MAP_EXT
   GL_PROXY_TEXTURE_RECTANGLE_ARB
   GL_PROXY_TEXTURE_RECTANGLE_NV
   GL_QUAD_ALPHA4_SGIS
   GL_QUAD_ALPHA8_SGIS
   GL_QUAD_INTENSITY4_SGIS
   GL_QUAD_INTENSITY8_SGIS
   GL_QUAD_LUMINANCE4_SGIS
   GL_QUAD_LUMINANCE8_SGIS
   GL_QUAD_MESH_SUN
   GL_QUAD_TEXTURE_SELECT_SGIS
   GL_QUARTER_BIT_ATI
   GL_QUERY_COUNTER_BITS
   GL_QUERY_COUNTER_BITS_ARB
   GL_QUERY_RESULT
   GL_QUERY_RESULT_ARB
   GL_QUERY_RESULT_AVAILABLE
   GL_QUERY_RESULT_AVAILABLE_ARB
   GL_R1UI_C3F_V3F_SUN
   GL_R1UI_C4F_N3F_V3F_SUN
   GL_R1UI_C4UB_V3F_SUN
   GL_R1UI_N3F_V3F_SUN
   GL_R1UI_T2F_C4F_N3F_V3F_SUN
   GL_R1UI_T2F_N3F_V3F_SUN
   GL_R1UI_T2F_V3F_SUN
   GL_R1UI_V3F_SUN
   GL_R3_G3_B2
   GL_R3_G3_B2_EXT
   GL_RASTER_POSITION_UNCLIPPED_IBM
   GL_READ_ONLY
   GL_READ_ONLY_ARB
   GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
   GL_READ_PIXEL_DATA_RANGE_NV
   GL_READ_PIXEL_DATA_RANGE_POINTER_NV
   GL_READ_WRITE
   GL_READ_WRITE_ARB
   GL_RECLAIM_MEMORY_HINT_PGI
   GL_REDUCE
   GL_RED_BIT_ATI
   GL_RED_MAX_CLAMP_INGR
   GL_RED_MIN_CLAMP_INGR
   GL_REFERENCE_PLANE_EQUATION_SGIX
   GL_REFERENCE_PLANE_SGIX
   GL_REFLECTION_MAP
   GL_REFLECTION_MAP_ARB
   GL_REFLECTION_MAP_EXT
   GL_REFLECTION_MAP_NV
   GL_REGISTER_COMBINERS_NV
   GL_REG_0_ATI
   GL_REG_10_ATI
   GL_REG_11_ATI
   GL_REG_12_ATI
   GL_REG_13_ATI
   GL_REG_14_ATI
   GL_REG_15_ATI
   GL_REG_16_ATI
   GL_REG_17_ATI
   GL_REG_18_ATI
   GL_REG_19_ATI
   GL_REG_1_ATI
   GL_REG_20_ATI
   GL_REG_21_ATI
   GL_REG_22_ATI
   GL_REG_23_ATI
   GL_REG_24_ATI
   GL_REG_25_ATI
   GL_REG_26_ATI
   GL_REG_27_ATI
   GL_REG_28_ATI
   GL_REG_29_ATI
   GL_REG_2_ATI
   GL_REG_30_ATI
   GL_REG_31_ATI
   GL_REG_3_ATI
   GL_REG_4_ATI
   GL_REG_5_ATI
   GL_REG_6_ATI
   GL_REG_7_ATI
   GL_REG_8_ATI
   GL_REG_9_ATI
   GL_RENDERBUFFER_ALPHA_SIZE_EXT
   GL_RENDERBUFFER_BINDING_EXT
   GL_RENDERBUFFER_BLUE_SIZE_EXT
   GL_RENDERBUFFER_DEPTH_SIZE_EXT
   GL_RENDERBUFFER_EXT
   GL_RENDERBUFFER_GREEN_SIZE_EXT
   GL_RENDERBUFFER_HEIGHT_EXT
   GL_RENDERBUFFER_INTERNAL_FORMAT_EXT
   GL_RENDERBUFFER_RED_SIZE_EXT
   GL_RENDERBUFFER_STENCIL_SIZE_EXT
   GL_RENDERBUFFER_WIDTH_EXT
   GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN
   GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN
   GL_REPLACEMENT_CODE_ARRAY_SUN
   GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN
   GL_REPLACEMENT_CODE_SUN
   GL_REPLACE_MIDDLE_SUN
   GL_REPLACE_OLDEST_SUN
   GL_REPLICATE_BORDER
   GL_REPLICATE_BORDER_HP
   GL_RESAMPLE_AVERAGE_OML
   GL_RESAMPLE_DECIMATE_OML
   GL_RESAMPLE_DECIMATE_SGIX
   GL_RESAMPLE_REPLICATE_OML
   GL_RESAMPLE_REPLICATE_SGIX
   GL_RESAMPLE_ZERO_FILL_OML
   GL_RESAMPLE_ZERO_FILL_SGIX
   GL_RESCALE_NORMAL
   GL_RESCALE_NORMAL_EXT
   GL_RESTART_SUN
   GL_RGB10
   GL_RGB10_A2
   GL_RGB12
   GL_RGB16
   GL_RGB16F_ARB
   GL_RGB32F_ARB
   GL_RGB4
   GL_RGB4_S3TC
   GL_RGB5
   GL_RGB5_A1
   GL_RGB8
   GL_RGBA12
   GL_RGBA16
   GL_RGBA16F_ARB
   GL_RGBA2
   GL_RGBA32F_ARB
   GL_RGBA4
   GL_RGBA4_S3TC
   GL_RGBA8
   GL_RGBA_FLOAT16_ATI
   GL_RGBA_FLOAT32_ATI
   GL_RGBA_FLOAT_MODE_ARB
   GL_RGBA_S3TC
   GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
   GL_RGB_FLOAT16_ATI
   GL_RGB_FLOAT32_ATI
   GL_RGB_S3TC
   GL_RGB_SCALE
   GL_RGB_SCALE_ARB
   GL_RGB_SCALE_EXT
   GL_SAMPLER_1D
   GL_SAMPLER_1D_ARB
   GL_SAMPLER_1D_SHADOW
   GL_SAMPLER_1D_SHADOW_ARB
   GL_SAMPLER_2D
   GL_SAMPLER_2D_ARB
   GL_SAMPLER_2D_RECT_ARB
   GL_SAMPLER_2D_RECT_SHADOW_ARB
   GL_SAMPLER_2D_SHADOW
   GL_SAMPLER_2D_SHADOW_ARB
   GL_SAMPLER_3D
   GL_SAMPLER_3D_ARB
   GL_SAMPLER_CUBE
   GL_SAMPLER_CUBE_ARB
   GL_SAMPLES
   GL_SAMPLES_3DFX
   GL_SAMPLES_ARB
   GL_SAMPLES_EXT
   GL_SAMPLES_PASSED
   GL_SAMPLES_PASSED_ARB
   GL_SAMPLE_ALPHA_TO_COVERAGE
   GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
   GL_SAMPLE_ALPHA_TO_MASK_EXT
   GL_SAMPLE_ALPHA_TO_ONE
   GL_SAMPLE_ALPHA_TO_ONE_ARB
   GL_SAMPLE_ALPHA_TO_ONE_EXT
   GL_SAMPLE_BUFFERS
   GL_SAMPLE_BUFFERS_3DFX
   GL_SAMPLE_BUFFERS_ARB
   GL_SAMPLE_BUFFERS_EXT
   GL_SAMPLE_COVERAGE
   GL_SAMPLE_COVERAGE_ARB
   GL_SAMPLE_COVERAGE_INVERT
   GL_SAMPLE_COVERAGE_INVERT_ARB
   GL_SAMPLE_COVERAGE_VALUE
   GL_SAMPLE_COVERAGE_VALUE_ARB
   GL_SAMPLE_MASK_EXT
   GL_SAMPLE_MASK_INVERT_EXT
   GL_SAMPLE_MASK_VALUE_EXT
   GL_SAMPLE_PATTERN_EXT
   GL_SATURATE_BIT_ATI
   GL_SCALAR_EXT
   GL_SCALEBIAS_HINT_SGIX
   GL_SCALE_BY_FOUR_NV
   GL_SCALE_BY_ONE_HALF_NV
   GL_SCALE_BY_TWO_NV
   GL_SCREEN_COORDINATES_REND
   GL_SECONDARY_COLOR_ARRAY
   GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING
   GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
   GL_SECONDARY_COLOR_ARRAY_EXT
   GL_SECONDARY_COLOR_ARRAY_LIST_IBM
   GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
   GL_SECONDARY_COLOR_ARRAY_POINTER
   GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
   GL_SECONDARY_COLOR_ARRAY_SIZE
   GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
   GL_SECONDARY_COLOR_ARRAY_STRIDE
   GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
   GL_SECONDARY_COLOR_ARRAY_TYPE
   GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
   GL_SECONDARY_COLOR_NV
   GL_SECONDARY_INTERPOLATOR_ATI
   GL_SELECTION_BUFFER_POINTER
   GL_SELECTION_BUFFER_SIZE
   GL_SEPARABLE_2D
   GL_SEPARATE_SPECULAR_COLOR
   GL_SEPARATE_SPECULAR_COLOR_EXT
   GL_SHADER_CONSISTENT_NV
   GL_SHADER_OBJECT_ARB
   GL_SHADER_OPERATION_NV
   GL_SHADER_SOURCE_LENGTH
   GL_SHADER_TYPE
   GL_SHADING_LANGUAGE_VERSION
   GL_SHADING_LANGUAGE_VERSION_ARB
   GL_SHADOW_AMBIENT_SGIX
   GL_SHADOW_ATTENUATION_EXT
   GL_SHARED_TEXTURE_PALETTE_EXT
   GL_SIGNED_ALPHA8_NV
   GL_SIGNED_ALPHA_NV
   GL_SIGNED_HILO16_NV
   GL_SIGNED_HILO8_NV
   GL_SIGNED_HILO_NV
   GL_SIGNED_IDENTITY_NV
   GL_SIGNED_INTENSITY8_NV
   GL_SIGNED_INTENSITY_NV
   GL_SIGNED_LUMINANCE8_ALPHA8_NV
   GL_SIGNED_LUMINANCE8_NV
   GL_SIGNED_LUMINANCE_ALPHA_NV
   GL_SIGNED_LUMINANCE_NV
   GL_SIGNED_NEGATE_NV
   GL_SIGNED_RGB8_NV
   GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
   GL_SIGNED_RGBA8_NV
   GL_SIGNED_RGBA_NV
   GL_SIGNED_RGB_NV
   GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
   GL_SINGLE_COLOR
   GL_SINGLE_COLOR_EXT
   GL_SLICE_ACCUM_SUN
   GL_SMOOTH_LINE_WIDTH_GRANULARITY
   GL_SMOOTH_LINE_WIDTH_RANGE
   GL_SMOOTH_POINT_SIZE_GRANULARITY
   GL_SMOOTH_POINT_SIZE_RANGE
   GL_SOURCE0_ALPHA
   GL_SOURCE0_ALPHA_ARB
   GL_SOURCE0_ALPHA_EXT
   GL_SOURCE0_RGB
   GL_SOURCE0_RGB_ARB
   GL_SOURCE0_RGB_EXT
   GL_SOURCE1_ALPHA
   GL_SOURCE1_ALPHA_ARB
   GL_SOURCE1_ALPHA_EXT
   GL_SOURCE1_RGB
   GL_SOURCE1_RGB_ARB
   GL_SOURCE1_RGB_EXT
   GL_SOURCE2_ALPHA
   GL_SOURCE2_ALPHA_ARB
   GL_SOURCE2_ALPHA_EXT
   GL_SOURCE2_RGB
   GL_SOURCE2_RGB_ARB
   GL_SOURCE2_RGB_EXT
   GL_SOURCE3_ALPHA_NV
   GL_SOURCE3_RGB_NV
   GL_SPARE0_NV
   GL_SPARE0_PLUS_SECONDARY_COLOR_NV
   GL_SPARE1_NV
   GL_SPRITE_AXIAL_SGIX
   GL_SPRITE_AXIS_SGIX
   GL_SPRITE_EYE_ALIGNED_SGIX
   GL_SPRITE_MODE_SGIX
   GL_SPRITE_OBJECT_ALIGNED_SGIX
   GL_SPRITE_SGIX
   GL_SPRITE_TRANSLATION_SGIX
   GL_SRC0_ALPHA
   GL_SRC0_RGB
   GL_SRC1_ALPHA
   GL_SRC1_RGB
   GL_SRC2_ALPHA
   GL_SRC2_RGB
   GL_STATIC_ATI
   GL_STATIC_COPY
   GL_STATIC_COPY_ARB
   GL_STATIC_DRAW
   GL_STATIC_DRAW_ARB
   GL_STATIC_READ
   GL_STATIC_READ_ARB
   GL_STENCIL_ATTACHMENT_EXT
   GL_STENCIL_BACK_FAIL
   GL_STENCIL_BACK_FAIL_ATI
   GL_STENCIL_BACK_FUNC
   GL_STENCIL_BACK_FUNC_ATI
   GL_STENCIL_BACK_PASS_DEPTH_FAIL
   GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
   GL_STENCIL_BACK_PASS_DEPTH_PASS
   GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
   GL_STENCIL_BACK_REF
   GL_STENCIL_BACK_VALUE_MASK
   GL_STENCIL_BACK_WRITEMASK
   GL_STENCIL_INDEX16_EXT
   GL_STENCIL_INDEX1_EXT
   GL_STENCIL_INDEX4_EXT
   GL_STENCIL_INDEX8_EXT
   GL_STENCIL_TEST_TWO_SIDE_EXT
   GL_STORAGE_CACHED_APPLE
   GL_STORAGE_SHARED_APPLE
   GL_STREAM_COPY
   GL_STREAM_COPY_ARB
   GL_STREAM_DRAW
   GL_STREAM_DRAW_ARB
   GL_STREAM_READ
   GL_STREAM_READ_ARB
   GL_STRICT_DEPTHFUNC_HINT_PGI
   GL_STRICT_LIGHTING_HINT_PGI
   GL_STRICT_SCISSOR_HINT_PGI
   GL_SUBTRACT
   GL_SUBTRACT_ARB
   GL_SUB_ATI
   GL_SWIZZLE_STQ_ATI
   GL_SWIZZLE_STQ_DQ_ATI
   GL_SWIZZLE_STRQ_ATI
   GL_SWIZZLE_STRQ_DQ_ATI
   GL_SWIZZLE_STR_ATI
   GL_SWIZZLE_STR_DR_ATI
   GL_T2F_C3F_V3F
   GL_T2F_C4F_N3F_V3F
   GL_T2F_C4UB_V3F
   GL_T2F_IUI_N3F_V2F_EXT
   GL_T2F_IUI_N3F_V3F_EXT
   GL_T2F_IUI_V2F_EXT
   GL_T2F_IUI_V3F_EXT
   GL_T2F_N3F_V3F
   GL_T2F_V3F
   GL_T4F_C4F_N3F_V4F
   GL_T4F_V4F
   GL_TABLE_TOO_LARGE
   GL_TANGENT_ARRAY_EXT
   GL_TANGENT_ARRAY_POINTER_EXT
   GL_TANGENT_ARRAY_STRIDE_EXT
   GL_TANGENT_ARRAY_TYPE_EXT
   GL_TEXCOORD1_BIT_PGI
   GL_TEXCOORD2_BIT_PGI
   GL_TEXCOORD3_BIT_PGI
   GL_TEXCOORD4_BIT_PGI
   GL_TEXTURE0
   GL_TEXTURE0_ARB
   GL_TEXTURE1
   GL_TEXTURE10
   GL_TEXTURE10_ARB
   GL_TEXTURE11
   GL_TEXTURE11_ARB
   GL_TEXTURE12
   GL_TEXTURE12_ARB
   GL_TEXTURE13
   GL_TEXTURE13_ARB
   GL_TEXTURE14
   GL_TEXTURE14_ARB
   GL_TEXTURE15
   GL_TEXTURE15_ARB
   GL_TEXTURE16
   GL_TEXTURE16_ARB
   GL_TEXTURE17
   GL_TEXTURE17_ARB
   GL_TEXTURE18
   GL_TEXTURE18_ARB
   GL_TEXTURE19
   GL_TEXTURE19_ARB
   GL_TEXTURE1_ARB
   GL_TEXTURE2
   GL_TEXTURE20
   GL_TEXTURE20_ARB
   GL_TEXTURE21
   GL_TEXTURE21_ARB
   GL_TEXTURE22
   GL_TEXTURE22_ARB
   GL_TEXTURE23
   GL_TEXTURE23_ARB
   GL_TEXTURE24
   GL_TEXTURE24_ARB
   GL_TEXTURE25
   GL_TEXTURE25_ARB
   GL_TEXTURE26
   GL_TEXTURE26_ARB
   GL_TEXTURE27
   GL_TEXTURE27_ARB
   GL_TEXTURE28
   GL_TEXTURE28_ARB
   GL_TEXTURE29
   GL_TEXTURE29_ARB
   GL_TEXTURE2_ARB
   GL_TEXTURE3
   GL_TEXTURE30
   GL_TEXTURE30_ARB
   GL_TEXTURE31
   GL_TEXTURE31_ARB
   GL_TEXTURE3_ARB
   GL_TEXTURE4
   GL_TEXTURE4_ARB
   GL_TEXTURE5
   GL_TEXTURE5_ARB
   GL_TEXTURE6
   GL_TEXTURE6_ARB
   GL_TEXTURE7
   GL_TEXTURE7_ARB
   GL_TEXTURE8
   GL_TEXTURE8_ARB
   GL_TEXTURE9
   GL_TEXTURE9_ARB
   GL_TEXTURE_1D_BINDING_EXT
   GL_TEXTURE_2D_BINDING_EXT
   GL_TEXTURE_3D
   GL_TEXTURE_3D_BINDING_EXT
   GL_TEXTURE_4DSIZE_SGIS
   GL_TEXTURE_4D_BINDING_SGIS
   GL_TEXTURE_4D_SGIS
   GL_TEXTURE_ALPHA_SIZE
   GL_TEXTURE_ALPHA_TYPE_ARB
   GL_TEXTURE_APPLICATION_MODE_EXT
   GL_TEXTURE_BASE_LEVEL
   GL_TEXTURE_BASE_LEVEL_SGIS
   GL_TEXTURE_BINDING_1D
   GL_TEXTURE_BINDING_2D
   GL_TEXTURE_BINDING_3D
   GL_TEXTURE_BINDING_CUBE_MAP
   GL_TEXTURE_BINDING_CUBE_MAP_ARB
   GL_TEXTURE_BINDING_CUBE_MAP_EXT
   GL_TEXTURE_BINDING_RECTANGLE_ARB
   GL_TEXTURE_BINDING_RECTANGLE_NV
   GL_TEXTURE_BLUE_SIZE
   GL_TEXTURE_BLUE_TYPE_ARB
   GL_TEXTURE_BORDER_VALUES_NV
   GL_TEXTURE_CLIPMAP_CENTER_SGIX
   GL_TEXTURE_CLIPMAP_DEPTH_SGIX
   GL_TEXTURE_CLIPMAP_FRAME_SGIX
   GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX
   GL_TEXTURE_CLIPMAP_OFFSET_SGIX
   GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX
   GL_TEXTURE_COLOR_TABLE_SGI
   GL_TEXTURE_COLOR_WRITEMASK_SGIS
   GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
   GL_TEXTURE_COMPARE_FUNC
   GL_TEXTURE_COMPARE_FUNC_ARB
   GL_TEXTURE_COMPARE_MODE
   GL_TEXTURE_COMPARE_MODE_ARB
   GL_TEXTURE_COMPARE_OPERATOR_SGIX
   GL_TEXTURE_COMPARE_SGIX
   GL_TEXTURE_COMPRESSED
   GL_TEXTURE_COMPRESSED_ARB
   GL_TEXTURE_COMPRESSED_IMAGE_SIZE
   GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
   GL_TEXTURE_COMPRESSION_HINT
   GL_TEXTURE_COMPRESSION_HINT_ARB
   GL_TEXTURE_CONSTANT_DATA_SUNX
   GL_TEXTURE_COORD_ARRAY
   GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING
   GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
   GL_TEXTURE_COORD_ARRAY_COUNT_EXT
   GL_TEXTURE_COORD_ARRAY_EXT
   GL_TEXTURE_COORD_ARRAY_LIST_IBM
   GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
   GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL
   GL_TEXTURE_COORD_ARRAY_POINTER
   GL_TEXTURE_COORD_ARRAY_POINTER_EXT
   GL_TEXTURE_COORD_ARRAY_SIZE
   GL_TEXTURE_COORD_ARRAY_SIZE_EXT
   GL_TEXTURE_COORD_ARRAY_STRIDE
   GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
   GL_TEXTURE_COORD_ARRAY_TYPE
   GL_TEXTURE_COORD_ARRAY_TYPE_EXT
   GL_TEXTURE_CUBE_MAP
   GL_TEXTURE_CUBE_MAP_ARB
   GL_TEXTURE_CUBE_MAP_EXT
   GL_TEXTURE_CUBE_MAP_NEGATIVE_X
   GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
   GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
   GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
   GL_TEXTURE_CUBE_MAP_POSITIVE_X
   GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
   GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
   GL_TEXTURE_CUBE_MAP_POSITIVE_Y
   GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
   GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
   GL_TEXTURE_CUBE_MAP_POSITIVE_Z
   GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
   GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
   GL_TEXTURE_DEFORMATION_BIT_SGIX
   GL_TEXTURE_DEFORMATION_SGIX
   GL_TEXTURE_DEPTH
   GL_TEXTURE_DEPTH_SIZE
   GL_TEXTURE_DEPTH_SIZE_ARB
   GL_TEXTURE_DEPTH_TYPE_ARB
   GL_TEXTURE_DS_SIZE_NV
   GL_TEXTURE_DT_SIZE_NV
   GL_TEXTURE_ENV_BIAS_SGIX
   GL_TEXTURE_FILTER4_SIZE_SGIS
   GL_TEXTURE_FILTER_CONTROL
   GL_TEXTURE_FILTER_CONTROL_EXT
   GL_TEXTURE_FLOAT_COMPONENTS_NV
   GL_TEXTURE_GEQUAL_R_SGIX
   GL_TEXTURE_GREEN_SIZE
   GL_TEXTURE_GREEN_TYPE_ARB
   GL_TEXTURE_HI_SIZE_NV
   GL_TEXTURE_INDEX_SIZE_EXT
   GL_TEXTURE_INTENSITY_SIZE
   GL_TEXTURE_INTENSITY_TYPE_ARB
   GL_TEXTURE_INTERNAL_FORMAT
   GL_TEXTURE_LEQUAL_R_SGIX
   GL_TEXTURE_LIGHTING_MODE_HP
   GL_TEXTURE_LIGHT_EXT
   GL_TEXTURE_LOD_BIAS
   GL_TEXTURE_LOD_BIAS_EXT
   GL_TEXTURE_LOD_BIAS_R_SGIX
   GL_TEXTURE_LOD_BIAS_S_SGIX
   GL_TEXTURE_LOD_BIAS_T_SGIX
   GL_TEXTURE_LO_SIZE_NV
   GL_TEXTURE_LUMINANCE_SIZE
   GL_TEXTURE_LUMINANCE_TYPE_ARB
   GL_TEXTURE_MAG_SIZE_NV
   GL_TEXTURE_MATERIAL_FACE_EXT
   GL_TEXTURE_MATERIAL_PARAMETER_EXT
   GL_TEXTURE_MAX_ANISOTROPY_EXT
   GL_TEXTURE_MAX_CLAMP_R_SGIX
   GL_TEXTURE_MAX_CLAMP_S_SGIX
   GL_TEXTURE_MAX_CLAMP_T_SGIX
   GL_TEXTURE_MAX_LEVEL
   GL_TEXTURE_MAX_LEVEL_SGIS
   GL_TEXTURE_MAX_LOD
   GL_TEXTURE_MAX_LOD_SGIS
   GL_TEXTURE_MIN_LOD
   GL_TEXTURE_MIN_LOD_SGIS
   GL_TEXTURE_MULTI_BUFFER_HINT_SGIX
   GL_TEXTURE_NORMAL_EXT
   GL_TEXTURE_POST_SPECULAR_HP
   GL_TEXTURE_PRE_SPECULAR_HP
   GL_TEXTURE_PRIORITY
   GL_TEXTURE_PRIORITY_EXT
   GL_TEXTURE_RECTANGLE_ARB
   GL_TEXTURE_RECTANGLE_NV
   GL_TEXTURE_RED_SIZE
   GL_TEXTURE_RED_TYPE_ARB
   GL_TEXTURE_RESIDENT
   GL_TEXTURE_RESIDENT_EXT
   GL_TEXTURE_SHADER_NV
   GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
   GL_TEXTURE_WRAP_Q_SGIS
   GL_TEXTURE_WRAP_R
   GL_TEXT_FRAGMENT_SHADER_ATI
   GL_TRACK_MATRIX_NV
   GL_TRACK_MATRIX_TRANSFORM_NV
   GL_TRANSFORM_HINT_APPLE
   GL_TRANSPOSE_COLOR_MATRIX
   GL_TRANSPOSE_COLOR_MATRIX_ARB
   GL_TRANSPOSE_CURRENT_MATRIX_ARB
   GL_TRANSPOSE_MODELVIEW_MATRIX
   GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
   GL_TRANSPOSE_NV
   GL_TRANSPOSE_PROJECTION_MATRIX
   GL_TRANSPOSE_PROJECTION_MATRIX_ARB
   GL_TRANSPOSE_TEXTURE_MATRIX
   GL_TRANSPOSE_TEXTURE_MATRIX_ARB
   GL_TRIANGLE_LIST_SUN
   GL_TRIANGLE_MESH_SUN
   GL_UNPACK_CLIENT_STORAGE_APPLE
   GL_UNPACK_CMYK_HINT
   GL_UNPACK_CMYK_HINT_EXT
   GL_UNPACK_CONSTANT_DATA_SUNX
   GL_UNPACK_IMAGE_DEPTH_SGIS
   GL_UNPACK_IMAGE_HEIGHT
   GL_UNPACK_RESAMPLE_OML
   GL_UNPACK_RESAMPLE_SGIX
   GL_UNPACK_SKIP_IMAGES
   GL_UNPACK_SKIP_VOLUMES_SGIS
   GL_UNPACK_SUBSAMPLE_RATE_SGIX
   GL_UNSIGNED_BYTE_2_3_3_REV
   GL_UNSIGNED_BYTE_3_3_2
   GL_UNSIGNED_BYTE_3_3_2_EXT
   GL_UNSIGNED_IDENTITY_NV
   GL_UNSIGNED_INT_10_10_10_2
   GL_UNSIGNED_INT_10_10_10_2_EXT
   GL_UNSIGNED_INT_24_8_NV
   GL_UNSIGNED_INT_2_10_10_10_REV
   GL_UNSIGNED_INT_8_8_8_8
   GL_UNSIGNED_INT_8_8_8_8_EXT
   GL_UNSIGNED_INT_8_8_8_8_REV
   GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
   GL_UNSIGNED_INT_S8_S8_8_8_NV
   GL_UNSIGNED_INVERT_NV
   GL_UNSIGNED_NORMALIZED_ARB
   GL_UNSIGNED_SHORT_1_5_5_5_REV
   GL_UNSIGNED_SHORT_4_4_4_4
   GL_UNSIGNED_SHORT_4_4_4_4_EXT
   GL_UNSIGNED_SHORT_4_4_4_4_REV
   GL_UNSIGNED_SHORT_5_5_5_1
   GL_UNSIGNED_SHORT_5_5_5_1_EXT
   GL_UNSIGNED_SHORT_5_6_5
   GL_UNSIGNED_SHORT_5_6_5_REV
   GL_UNSIGNED_SHORT_8_8_APPLE
   GL_UNSIGNED_SHORT_8_8_MESA
   GL_UNSIGNED_SHORT_8_8_REV_APPLE
   GL_UNSIGNED_SHORT_8_8_REV_MESA
   GL_UPPER_LEFT
   GL_V2F
   GL_V3F
   GL_VALIDATE_STATUS
   GL_VARIABLE_A_NV
   GL_VARIABLE_B_NV
   GL_VARIABLE_C_NV
   GL_VARIABLE_D_NV
   GL_VARIABLE_E_NV
   GL_VARIABLE_F_NV
   GL_VARIABLE_G_NV
   GL_VARIANT_ARRAY_EXT
   GL_VARIANT_ARRAY_POINTER_EXT
   GL_VARIANT_ARRAY_STRIDE_EXT
   GL_VARIANT_ARRAY_TYPE_EXT
   GL_VARIANT_DATATYPE_EXT
   GL_VARIANT_EXT
   GL_VARIANT_VALUE_EXT
   GL_VECTOR_EXT
   GL_VERTEX23_BIT_PGI
   GL_VERTEX4_BIT_PGI
   GL_VERTEX_ARRAY
   GL_VERTEX_ARRAY_BINDING_APPLE
   GL_VERTEX_ARRAY_BUFFER_BINDING
   GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
   GL_VERTEX_ARRAY_COUNT_EXT
   GL_VERTEX_ARRAY_EXT
   GL_VERTEX_ARRAY_LIST_IBM
   GL_VERTEX_ARRAY_LIST_STRIDE_IBM
   GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL
   GL_VERTEX_ARRAY_POINTER
   GL_VERTEX_ARRAY_POINTER_EXT
   GL_VERTEX_ARRAY_RANGE_APPLE
   GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
   GL_VERTEX_ARRAY_RANGE_LENGTH_NV
   GL_VERTEX_ARRAY_RANGE_NV
   GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
   GL_VERTEX_ARRAY_RANGE_POINTER_NV
   GL_VERTEX_ARRAY_RANGE_VALID_NV
   GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
   GL_VERTEX_ARRAY_SIZE
   GL_VERTEX_ARRAY_SIZE_EXT
   GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
   GL_VERTEX_ARRAY_STRIDE
   GL_VERTEX_ARRAY_STRIDE_EXT
   GL_VERTEX_ARRAY_TYPE
   GL_VERTEX_ARRAY_TYPE_EXT
   GL_VERTEX_ATTRIB_ARRAY0_NV
   GL_VERTEX_ATTRIB_ARRAY10_NV
   GL_VERTEX_ATTRIB_ARRAY11_NV
   GL_VERTEX_ATTRIB_ARRAY12_NV
   GL_VERTEX_ATTRIB_ARRAY13_NV
   GL_VERTEX_ATTRIB_ARRAY14_NV
   GL_VERTEX_ATTRIB_ARRAY15_NV
   GL_VERTEX_ATTRIB_ARRAY1_NV
   GL_VERTEX_ATTRIB_ARRAY2_NV
   GL_VERTEX_ATTRIB_ARRAY3_NV
   GL_VERTEX_ATTRIB_ARRAY4_NV
   GL_VERTEX_ATTRIB_ARRAY5_NV
   GL_VERTEX_ATTRIB_ARRAY6_NV
   GL_VERTEX_ATTRIB_ARRAY7_NV
   GL_VERTEX_ATTRIB_ARRAY8_NV
   GL_VERTEX_ATTRIB_ARRAY9_NV
   GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
   GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
   GL_VERTEX_ATTRIB_ARRAY_ENABLED
   GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
   GL_VERTEX_ATTRIB_ARRAY_NORMALIZED
   GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
   GL_VERTEX_ATTRIB_ARRAY_POINTER
   GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
   GL_VERTEX_ATTRIB_ARRAY_SIZE
   GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
   GL_VERTEX_ATTRIB_ARRAY_STRIDE
   GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
   GL_VERTEX_ATTRIB_ARRAY_TYPE
   GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
   GL_VERTEX_BLEND_ARB
   GL_VERTEX_CONSISTENT_HINT_PGI
   GL_VERTEX_DATA_HINT_PGI
   GL_VERTEX_PRECLIP_HINT_SGIX
   GL_VERTEX_PRECLIP_SGIX
   GL_VERTEX_PROGRAM_ARB
   GL_VERTEX_PROGRAM_BINDING_NV
   GL_VERTEX_PROGRAM_NV
   GL_VERTEX_PROGRAM_POINT_SIZE
   GL_VERTEX_PROGRAM_POINT_SIZE_ARB
   GL_VERTEX_PROGRAM_POINT_SIZE_NV
   GL_VERTEX_PROGRAM_TWO_SIDE
   GL_VERTEX_PROGRAM_TWO_SIDE_ARB
   GL_VERTEX_PROGRAM_TWO_SIDE_NV
   GL_VERTEX_SHADER
   GL_VERTEX_SHADER_ARB
   GL_VERTEX_SHADER_BINDING_EXT
   GL_VERTEX_SHADER_EXT
   GL_VERTEX_SHADER_INSTRUCTIONS_EXT
   GL_VERTEX_SHADER_INVARIANTS_EXT
   GL_VERTEX_SHADER_LOCALS_EXT
   GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
   GL_VERTEX_SHADER_OPTIMIZED_EXT
   GL_VERTEX_SHADER_VARIANTS_EXT
   GL_VERTEX_SOURCE_ATI
   GL_VERTEX_STATE_PROGRAM_NV
   GL_VERTEX_STREAM0_ATI
   GL_VERTEX_STREAM1_ATI
   GL_VERTEX_STREAM2_ATI
   GL_VERTEX_STREAM3_ATI
   GL_VERTEX_STREAM4_ATI
   GL_VERTEX_STREAM5_ATI
   GL_VERTEX_STREAM6_ATI
   GL_VERTEX_STREAM7_ATI
   GL_VERTEX_WEIGHTING_EXT
   GL_VERTEX_WEIGHT_ARRAY_EXT
   GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
   GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
   GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
   GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
   GL_VIBRANCE_BIAS_NV
   GL_VIBRANCE_SCALE_NV
   GL_VOLUME_CLIPPING_HINT_EXT
   GL_WEIGHT_ARRAY_ARB
   GL_WEIGHT_ARRAY_BUFFER_BINDING
   GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
   GL_WEIGHT_ARRAY_POINTER_ARB
   GL_WEIGHT_ARRAY_SIZE_ARB
   GL_WEIGHT_ARRAY_STRIDE_ARB
   GL_WEIGHT_ARRAY_TYPE_ARB
   GL_WEIGHT_SUM_UNITY_ARB
   GL_WIDE_LINE_HINT_PGI
   GL_WRAP_BORDER_SUN
   GL_WRITE_ONLY
   GL_WRITE_ONLY_ARB
   GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
   GL_WRITE_PIXEL_DATA_RANGE_NV
   GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
   GL_W_EXT
   GL_X_EXT
   GL_YCBCR_422_APPLE
   GL_YCBCR_MESA
   GL_YCRCBA_SGIX
   GL_YCRCB_422_SGIX
   GL_YCRCB_444_SGIX
   GL_YCRCB_SGIX
   GL_Y_EXT
   GL_ZERO_EXT
   GL_Z_EXT
));

my @oldfuncs_common = qw(
	glBitmap
	glCallLists
	glClipPlane
	glColor3bv
	glColor3dv
	glColor3fv
	glColor3iv
	glColor3sv
	glColor3ubv
	glColor3uiv
	glColor3usv
	glColor4bv
	glColor4dv
	glColor4fv
	glColor4iv
	glColor4sv
	glColor4ubv
	glColor4uiv
	glColor4usv
	glConvolutionFilter1DEXT
	glConvolutionFilter2DEXT
	glConvolutionParameterfvEXT
	glConvolutionParameterivEXT
	glDetailTexFuncSGIS
	glDrawPixels
	glEvalCoord1dv
	glEvalCoord1fv
	glEvalCoord2dv
	glEvalCoord2fv
	glFeedbackBuffer
	glFogfv
	glFogiv
	glGetBooleanv
	glGetClipPlane
	glGetConvolutionFilterEXT
	glGetConvolutionParameterfvEXT
	glGetConvolutionParameterivEXT
	glGetDetailTexFuncSGIS
	glGetDoublev
	glGetFloatv
	glGetHistogramEXT
	glGetHistogramParameterfvEXT
	glGetHistogramParameterivEXT
	glGetIntegerv
	glGetLightfv
	glGetLightiv
	glGetMapdv
	glGetMapfv
	glGetMapiv
	glGetMaterialfv
	glGetMaterialiv
	glGetMinmaxEXT
	glGetMinmaxParameterfvEXT
	glGetMinmaxParameterivEXT
	glGetPixelMapfv
	glGetPixelMapuiv
	glGetPixelMapusv
	glGetPolygonStipple
	glGetSeparableFilterEXT
	glGetSharpenTexFuncSGIS
	glGetTexEnvfv
	glGetTexEnviv
	glGetTexGendv
	glGetTexGenfv
	glGetTexGeniv
	glGetTexImage
	glGetTexLevelParameterfv
	glGetTexLevelParameteriv
	glGetTexParameterfv
	glGetTexParameteriv
	glIndexdv
	glIndexfv
	glIndexiv
	glIndexsv
	glLightModelfv
	glLightModeliv
	glLightfv
	glLightiv
	glLoadMatrixd
	glLoadMatrixf
	glMap1d
	glMap1f
	glMap2d
	glMap2f
	glMaterialfv
	glMaterialiv
	glMultMatrixd
	glMultMatrixf
	glNormal3bv
	glNormal3dv
	glNormal3fv
	glNormal3iv
	glNormal3sv
	glPixelMapfv
	glPixelMapuiv
	glPixelMapusv
	glPolygonStipple
	glRasterPos2dv
	glRasterPos2fv
	glRasterPos2iv
	glRasterPos2sv
	glRasterPos3dv
	glRasterPos3fv
	glRasterPos3iv
	glRasterPos3sv
	glRasterPos4dv
	glRasterPos4fv
	glRasterPos4iv
	glRasterPos4sv
	glReadPixels
	glRectdv
	glRectfv
	glRectiv
	glRectsv
	glSeparableFilter2DEXT
	glSharpenTexFuncSGIS
	glTexCoord1dv
	glTexCoord1fv
	glTexCoord1iv
	glTexCoord1sv
	glTexCoord2dv
	glTexCoord2fv
	glTexCoord2iv
	glTexCoord2sv
	glTexCoord3dv
	glTexCoord3fv
	glTexCoord3iv
	glTexCoord3sv
	glTexCoord4dv
	glTexCoord4fv
	glTexCoord4iv
	glTexCoord4sv
	glTexEnvfv
	glTexEnviv
	glTexGendv
	glTexGenfv
	glTexGeniv
	glTexImage1D
	glTexImage2D
	glTexImage3DEXT
	glTexParameterfv
	glTexParameteriv
	glTexSubImage1DEXT
	glTexSubImage2DEXT
	glTexSubImage3DEXT
	glVertex2dv
	glVertex2fv
	glVertex2iv
	glVertex2sv
	glVertex3dv
	glVertex3fv
	glVertex3iv
	glVertex3sv
	glVertex4dv
	glVertex4fv
	glVertex4iv
	glVertex4sv
);
our @oldfunctions = (@oldfuncs_common, qw(
	glpOpenWindow
	glpMainLoop
	glpMoveResizeWindow
	glpMoveWindow
	glpResizeWindow
	glpDisplay
), @OpenGL::GLX::func, @gl_func_common, qw(
	glColor3us
	glColor4b
	glConvolutionParameterfEXT
	glConvolutionParameteriEXT
	glCopyConvolutionFilter1DEXT
	glCopyConvolutionFilter2DEXT
	glEdgeFlagv
	glHistogramEXT
	glIndexf
	glIndexs
	glMinmaxEXT
	glResetHistogramEXT
	glResetMinmaxEXT
	glSampleMaskSGIS
	glSamplePatternSGIS
	glSelectBuffer
	glTagSampleBufferSGIX
	glpClipPlane
	glpFlush
	glpGetClipPlane
	glpLoadMatrixf glpLoadMatrixd glpMultMatrixf glpMultMatrixd
	glpReadTex
	glpSolidSphere
	gluLookAt
	gluOrtho2D
	gluPerspective
), @OpenGL::GLX::const_old_functions);

our @oldconstants = (@gl_const_common, @OpenGL::GLX::const_common, @OpenGL::GLU::const_common, qw(
	GLU_VERSION_1_1
	GLXBadContext
	GLXBadContextState
	GLXBadContextTag
	GLXBadCurrentWindow
	GLXBadDrawable
	GLXBadLargeRequest
	GLXBadPixmap
	GLXBadRenderRequest
	GLXUnsupportedPrivateRequest
	GLX_BAD_ATTRIBUTE
	GLX_BAD_CONTEXT
	GLX_BAD_ENUM
	GLX_BAD_SCREEN
	GLX_BAD_VALUE
	GLX_BAD_VISUAL
	GLX_EXTENSIONS
	GLX_EXTENSION_ALIAS
	GLX_EXTENSION_NAME
	GLX_MUXPIPE0_SGI
	GLX_MUXPIPE1_SGI
	GLX_MUXPIPE2_SGI
	GLX_NO_EXTENSION
	GLX_SAMPLES_SGIS
	GLX_SAMPLE_BUFFER_SGIS
	GLX_SGIS_multisample
	GLX_SGI_swap_control
	GLX_SGI_video_sync
	GLX_SWAP_DEFAULT_SGI
	GLX_SWAP_GANG_SGI
	GLX_SWAP_MUXPIPE_SGI
	GLX_VENDOR
	GLX_VERSION
	GL_EXT_abgr
	GL_EXT_blend_color
	GL_EXT_blend_logic_op
	GL_EXT_blend_minmax
	GL_EXT_blend_subtract
	GL_EXT_convolution
	GL_EXT_histogram
	GL_EXT_polygon_offset
	GL_EXT_subtexture
	GL_EXT_texture
	GL_EXT_texture3D
	GL_SGIS_detail_texture
	GL_SGIS_multisample
	GL_SGIS_sharpen_texture
	__GLX_NUMBER_ERRORS
	__GLX_NUMBER_EVENTS
));

our @EXPORT = (@oldfunctions, @oldconstants);

my @constants = (@gl_const, @OpenGL::GLU::const, @OpenGL::GLUT::const, @OpenGL::GLX::const);
my @functions = (@gl_func, @OpenGL::GLU::func, @OpenGL::GLUT::func, @OpenGL::GLX::func);
# Other items we are prepared to export if requested
our @EXPORT_OK = (@constants, @functions);

our %EXPORT_TAGS = (
  constants => \@constants, functions => \@functions, all => \@EXPORT_OK, old => \@EXPORT,
  glconstants => \@gl_const, gluconstants => \@OpenGL::GLU::const, glutconstants => \@OpenGL::GLUT::const, glxconstants => \@OpenGL::GLX::const,
  glfunctions => \@gl_func, glufunctions => \@OpenGL::GLU::func, glutfunctions => \@OpenGL::GLUT::func, glxfunctions => \@OpenGL::GLX::func,
  oldfunctions => \@oldfunctions, oldconstants => \@oldconstants,
);

our @rename_old = (@oldfuncs_common, qw(
	glTranslated
	glTranslatef
	glViewport
));
my %rename_p; @rename_p{@rename_old} = (); # "p" = predicate

sub AUTOLOAD {
  # This AUTOLOAD is used to 'autoload' constants from the constant()
  # XS function.
  # NOTE: THIS AUTOLOAD FUNCTION IS FLAWED (but is the best we can do for now).
  # Avoid old-style ``&CONST'' usage. Either remove the ``&'' or add ``()''.
  if (@_ > 0) {
      # Is it an old OpenGL-0.4 function? If so, remap it to newer variant
    (my $constname = our $AUTOLOAD) =~ s/.*:://;
    die "AUTOLOAD: unknown function '$constname'" if !exists $rename_p{$constname};
    no strict 'refs';
    *$AUTOLOAD = \&{"${AUTOLOAD}_s"};
    goto &$AUTOLOAD;
  }
  (my $constname = our $AUTOLOAD) =~ s/.*:://;
  my $val = constant($constname, @_ ? $_[0] : 0);
  if (not defined $val) {
    die "AUTOLOAD: unknown function '$constname'" if $! =~ /Invalid/;
    my (undef,$file,$line) = caller;
    die "Your vendor has not defined OpenGL macro $constname, used at $file line $line.
";
  }
  no strict 'refs';
  *$AUTOLOAD = sub { $val };
  goto &$AUTOLOAD;
}

# The following material is directly copied from Stan Melax's original OpenGL-0.4

our %window_defaults=(
   'x'         => 0,
   'y'         => 0,
   'width'     => 500,
   'height'    => 500,
   'parent'    => 0,
   'steal'     => 0,
   'mask'      => (_have_glx() ? StructureNotifyMask() : 0),
   'attributes'=> [],
);


sub glpOpenWindow {
        # default values
        my(%a) = @_;
        my(%p) = %window_defaults;
        foreach my $k (keys(%a)){
                exists($p{$k}) || warn "Not a valid parameter to glpOpenWindow: `$k'\n";
                #print "parameter $k now ",$a{$k}," was ",$p{$k},"\n";  
                $p{$k} = $a{$k};
        }
        #
        # glpcOpenWindow() no longer exported.  Use fully qualified
        # package name or (better!) glpOpenWindow()
        #
        glpcOpenWindow($p{'x'},$p{'y'},$p{'width'},$p{'height'},
                       $p{'parent'},$p{'mask'},$p{'steal'},
                       @{$p{'attributes'}});
}

# The following material is original to OpenGL-0.5, and provides compatibility
# with some of Stan's functions.

sub glpClipPlane { glClipPlane_p(@_) }

sub glpGetClipPlane { glGetClipPlane_p(@_) }

sub glpLoadMatrixd { glLoadMatrixd_p(@_) }

sub glpMultMatrixd { glMultMatrixd_p(@_) }

sub glpLoadMatrixf { glLoadMatrixf_p(@_) }

sub glpMultMatrixf { glMultMatrixf_p(@_) }

sub glpMainLoop {
  print "Type <Enter> to quit...\n";
  until(<>){;}
}

sub glpFlush {
  &glFlush;
  glXSwapBuffers() if __had_dbuffer_hack();
}

sub OpenGL::Quad::DESTROY ($) {gluDeleteQuadric(shift)}
@OpenGL::Quad::ISA = 'GLUquadricObjPtr';
sub __new_gluQuad () {bless gluNewQuadric(), 'OpenGL::Quad'}

sub glpSolidSphere ($$$) {
  gluSphere(__new_gluQuad, shift, shift, shift);
}
unless (_have_glut()) {
  *glutSolidSphere = \&glpSolidSphere;
}


sub glpFullScreen
{
  my $params = {};

  $params->{original_x} = glutGet(0x0064);	# GLUT_WINDOW_X
  $params->{original_y} = glutGet(0x0065);	# GLUT_WINDOW_Y
  $params->{original_w} = glutGet(0x0066);	# GLUT_WINDOW_WIDTH
  $params->{original_h} = glutGet(0x0067);	# GLUT_WINDOW_HEIGHT

  glutFullScreen();

  $params->{w} = glutGet(0x0066);		# GLUT_WINDOW_WIDTH
  $params->{h} = glutGet(0x0067);		# GLUT_WINDOW_HEIGHT

  return $params;
}

sub glpRestoreScreen
{
  my($params) = @_;

  glutPositionWindow($params->{original_x},$params->{original_y});
  glutReshapeWindow($params->{original_w},$params->{original_h});
  glutPostRedisplay();
}

sub glpCheckExtension
{
  my(@extensions) = @_;

  # Get/cache OpenGL Version
  if (!$gl_version)
  {
    $gl_version = glGetString(0x1F02); #GL_VERSION
    return 'Unable to retrieve OpenGL version; need context?' if (!$gl_version);
  }
  return "Not a numeric version: '$gl_version'" if ($gl_version !~ m|^(\d+\.\d+)|);
  $gl_version = $1;

  # Get/cache OpenGL Extension Installations
  if (!scalar(%$glext_installed))
  {
    my $inst = glGetString(0x1F03); #GL_EXTENSIONS
    foreach my $ext (split(' ',$inst))
    {
      $glext_installed->{$ext} = $glext_dependencies->{$ext} || 0;
    }
  }
  if (!scalar(%$glext_installed))
  {
    return 'Unable to retrieve extensions; need context?' 
  }

  foreach my $ext (@extensions)
  {
    return "$ext not installed" if (!defined($glext_installed->{$ext}));

    # Check implementation
    my($ver,$deps) = split(';',$glext_installed->{$ext});
    return "$ext not implemented" if (!$ver);
    return "Needs at least OpenGL $ver" if ($gl_version < $ver);
    next if (!$deps);

    # Check dependencies
    foreach my $dep (split(',',$deps))
    {
      my $stat = glpCheckExtension("GL_$dep");
      return "Depends on $deps" if ($stat);
    }
  }
  return 0;
}

1;
