exit 0 if $ENV{AUTOMATED_TESTING};
use File::Which;
die "php-cgi not found; aborting" if not which("php-cgi");
# This Makefile.PL for Plack-App-BeanstalkConsole was generated by
# inc::DownloadShareDirContent <self>.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

BEGIN {
my %configure_requires = (
    'File::Spec' => '0',
    'Module::Build::Tiny' => '0.030',
    'File::ShareDir::Install' => '0.03',
    'Archive::Extract' => '0',
    'HTTP::Tiny' => '0',
    'ExtUtils::MakeMaker' => '6.30',
    'File::Which' => '0',
    'File::Temp' => '0',
);

my @missing = grep {
    ! eval "require $_; $_->VERSION($configure_requires{$_}); 1"
} keys %configure_requires;

if (not @missing)
{
    print "Congratulations, your toolchain understands 'configure_requires'!\n\n";
}
else
{
    warn <<'EOW';
*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***

If you're seeing this warning, your toolchain is really, really old and you'll
almost certainly have problems installing CPAN modules from this century. But
never fear, dear user, for we have the technology to fix this!

If you're using CPAN.pm to install things, then you can upgrade it using:

    cpan CPAN

If you're using CPANPLUS to install things, then you can upgrade it using:

    cpanp CPANPLUS

If you're using cpanminus, you shouldn't be seeing this message in the first
place, so please file an issue on github.

If you're installing manually, please retrain your fingers to run Build.PL
when present instead.

This public service announcement was brought to you by the Perl Toolchain
Gang, the irc.perl.org #toolchain IRC channel, and the number 42.

EOW

    sleep 10 if -t STDIN && (-t STDOUT || !(-f STDOUT || -c STDOUT));
}
}

use 5.006;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
# begin inc::DownloadShareDirContent (1)
use File::Spec;
use File::Temp 'tempdir';
use HTTP::Tiny;
use Archive::Extract;

my $archive_file = File::Spec->catfile(tempdir(CLEANUP => 1), "beanstalk_console.zip");
print "downloading https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip to $archive_file...
";
my $response = HTTP::Tiny->new->mirror('https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip', $archive_file);
$response->{success} or die "failed to download https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip into $archive_file";

my $extract_dir = 'share';
my $ae = Archive::Extract->new(archive => $archive_file);
$ae->extract(to => $extract_dir) or die "failed to extract $archive_file to $extract_dir ";
# end inc::DownloadShareDirContent (1)

# begin inc::DownloadShareDirContent (2)
install_share dist => $extract_dir;
# end inc::DownloadShareDirContent (2)


my %WriteMakefileArgs = (
  "ABSTRACT" => "a web application that provides access to Beanstalk statistics and tools",
  "AUTHOR" => "Karen Etheridge <ether\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Archive::Extract" => 0,
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03",
    "File::Spec" => 0,
    "File::Temp" => 0,
    "File::Which" => 0,
    "HTTP::Tiny" => 0,
    "Module::Build::Tiny" => "0.030"
  },
  "DISTNAME" => "Plack-App-BeanstalkConsole",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Plack::App::BeanstalkConsole",
  "PREREQ_PM" => {
    "File::ShareDir" => 0,
    "Plack::App::PHPCGIFile" => 0,
    "Scalar::Util" => 0,
    "namespace::autoclean" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec::Functions" => 0,
    "HTTP::Request::Common" => 0,
    "List::Util" => 0,
    "Plack::Test" => 0,
    "Test::File::ShareDir" => 0,
    "Test::More" => 0,
    "Test::Warnings" => 0
  },
  "VERSION" => "0.007",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


