exit 0 if $ENV{AUTOMATED_TESTING};
# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
# begin inc::DownloadShareDirContent
use File::Spec;
use File::Temp 'tempdir';
use HTTP::Tiny;
use Archive::Extract;

my $archive_file = File::Spec->catfile(tempdir(CLEANUP => 1), "beanstalk_console.zip");
print "downloading https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip to $archive_file...
";
my $response = HTTP::Tiny->new->mirror('https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip', $archive_file);
$response->{success} or die "failed to download https://github.com/downloads/ptrofimov/beanstalk_console/beanstalk_console.zip into $archive_file";

my $extract_dir = tempdir;
my $ae = Archive::Extract->new(archive => $archive_file);
$ae->extract(to => $extract_dir) or die "failed to extract $archive_file to $extract_dir ";

install_share dist => $extract_dir;
# end inc::DownloadShareDirContent


my %WriteMakefileArgs = (
  "ABSTRACT" => "a web application that provides access to Beanstalk statistics and tools",
  "AUTHOR" => "Karen Etheridge <ether\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Archive::Extract" => 0,
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03",
    "File::Spec" => 0,
    "File::Temp" => 0,
    "HTTP::Tiny" => 0
  },
  "DISTNAME" => "Plack-App-BeanstalkConsole",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Plack::App::BeanstalkConsole",
  "PREREQ_PM" => {
    "File::ShareDir" => 0,
    "Plack::App::PHPCGIFile" => 0,
    "Scalar::Util" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Find" => 0,
    "File::Temp" => 0,
    "HTTP::Request::Common" => 0,
    "Plack::Test" => 0,
    "Test::CheckDeps" => "0.002",
    "Test::More" => "0.94",
    "Test::Warnings" => 0
  },
  "VERSION" => "0.002",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


