# ABSTRACT: Net::Object::Peer specfic Listener
package Net::Object::Peer::Listener;

use 5.10.0;

use Types::Standard qw[ ConsumerOf InstanceOf ];
use Net::Object::Peer::RefAddr;

use Moo;
use strictures 2;
use namespace::clean;
extends 'BeamX::Peer::Listener';

our $VERSION = '0.04'; # TRIAL

has +peer => (
    is  => 'ro',
    isa => ConsumerOf ['Net::Object::Peer'],
    weak_ref => 1,
);

#pod =attr  addr
#pod
#pod The reference address of the true emitter
#pod
#pod =cut

has addr => (
    is       => 'rwp',
    isa      => InstanceOf['Net::Object::Peer::RefAddr'],
    predicate => 1,
);


#pod =begin pod_coverage
#pod
#pod =head4 BUILD
#pod
#pod =head4 has_addr
#pod
#pod =end pod_coverage
#pod
#pod =cut

sub BUILD {

    # do this as soon as possible.  if it's lazy, peer may disappear
    # before a lazy builder can run
    $_[0]->_set_addr( Net::Object::Peer::RefAddr->new( $_[0]->peer ) )
      unless $_[0]->has_addr;
}

1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::Listener - Net::Object::Peer specfic Listener

=head1 VERSION

version 0.04

=head1 DESCRIPTION

B<Net::Object::Peer::Listener> is a sub-class of L<BeamX::Peer::Listener>,
which

=over

=item *

adds the requirement that the peer be a consumer of L<Net::Object::Peer>.

=item *

adds an C<addr> attribute, which contains the refaddr of C<peer>.

=back

Listener classes used with L<Net::Object::Peer> must be derived from
this class.

=head1 ATTRIBUTES

=head2 addr

The reference address of the true emitter

=begin pod_coverage

=head4 BUILD

=head4 has_addr

=end pod_coverage

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod B<Net::Object::Peer::Listener> is a sub-class of L<BeamX::Peer::Listener>,
#pod which
#pod
#pod =over
#pod
#pod =item *
#pod
#pod adds the requirement that the peer be a consumer of L<Net::Object::Peer>.
#pod
#pod =item *
#pod
#pod adds an C<addr> attribute, which contains the refaddr of C<peer>.
#pod
#pod =back
#pod
#pod Listener classes used with L<Net::Object::Peer> must be derived from
#pod this class.
