#! perl

use Test2::V0;
use Test::Lib;
use My::Variant::Form;


package My::OptArgs2 {

    use base 'CXC::Form::Tiny::OptArgs2';
    use experimental 'signatures';

    # change from nested to parallel form class hierarchy
    sub form_class ( $class, $command_class ) { return $command_class =~ s/::cmd/::form/r }
}

my $optarg = My::OptArgs2->new( command_class => 'IceCream::Bowl::cmd' );

my $base          = 'IceCream::Bowl';
my $cmd_pkg       = "${base}::cmd";
my $subcmd_pkg    = "${cmd_pkg}::clean";
my $subsubcmd_pkg = "${subcmd_pkg}::thoroughly";

my $cmd_form_pkg       = $cmd_pkg       =~ s/::cmd/::form/r;
my $subcmd_form_pkg    = $subcmd_pkg    =~ s/::cmd/::form/r;
my $subsubcmd_form_pkg = $subsubcmd_pkg =~ s/::cmd/::form/r;

my $cmd_form = Form( $cmd_form_pkg, fields => ['cone'], );

my $subcmd_form = Form(
    $subcmd_form_pkg,
    extends => $cmd_form,
    fields  => ['bowl'],
);

Form(
    $subsubcmd_form_pkg,
    extends => $subcmd_form,
    fields  => ['lick'],
);

$optarg->cmd( comment => $cmd_pkg );
$optarg->subcmd( 'clean',             comment => $subcmd_pkg );
$optarg->subcmd( 'clean::thoroughly', comment => $subsubcmd_pkg );

subtest 'command' => sub {
    local @ARGV = ( '--cone' => 'sugar' );
    my ( $class, $args ) = $optarg->class_optargs();
    is( $class, $cmd_pkg );
    is( $args,  hash { field cone => 'sugar'; end; } );
};

subtest 'sub-command' => sub {
    local @ARGV = ( 'clean', '--cone' => 'sugar', '--bowl' => 'fruit' );
    my ( $class, $args ) = $optarg->class_optargs();
    is( $class, $subcmd_pkg );
    is(
        $args,
        hash {
            field cone => 'sugar';
            field bowl => 'fruit';
            end;
        },
    );
};

subtest 'sub-sub-command' => sub {
    local @ARGV = (
        'clean',
        'thoroughly',
        '--cone' => 'sugar',
        '--bowl' => 'fruit',
        '--lick' => 'yes',
    );
    my ( $class, $args ) = $optarg->class_optargs();
    is( $class, $subsubcmd_pkg );
    is(
        $args,
        hash {
            field cone => 'sugar';
            field bowl => 'fruit';
            field lick => 'yes';
            end;
        },
    );
};

done_testing;
