#! perl

use Test::Lib;
use aliased 'CXC::Form::Tiny::OptArgs2';

## no critic ( Modules::ProhibitMultiplePackages )

package App::cmd::form {
    use Types::Standard 'Str';
    use Form::Tiny plugins => ['+CXC::Form::Tiny::Plugin::OptArgs2'];

    form_field foo => ( type => Str );
    option( comment => 'Foo' );
}

package App::cmd::form::subcmd {

    use Form::Tiny plugins => ['+CXC::Form::Tiny::Plugin::OptArgs2'];
    use Types::Standard 'Str';

    extends 'App::cmd::form';

    form_field bar => ( type => Str );
    option( comment => 'Bar' );

}

OptArgs2->cmd( 'App::cmd', comment => 'main command' );
OptArgs2->subcmd( 'subcmd', comment => 'sub command' );


1;
