$spops = {
   'classified' => {
     class        => 'OpenInteract::Classified',
     isa          => [ qw/ OpenInteract::SPOPS::DBI SPOPS::Secure
                           SPOPS::DBI::MySQL  SPOPS::DBI / ],
     field        => [ qw/ classified_id posted_on posted_by title deadline 
                           description location required_skills recommended_skills 
                           application_info contact organization phone fax email 
                           url active expires_on / ],
     id_field     => 'classified_id',
     increment_field => 1,
     sequence_name   => 'oi_classified_seq',
     base_table   => 'classified',
     no_insert    => [ qw/ classified_id / ],
     skip_undef   => [ qw/ active expires_on / ],
     no_update    => [ qw/ classified_id posted_on / ],
     sql_defaults => [ qw/ active / ],
     field_alter  => {},
     alias        => [],
     has_a        => { 'OpenInteract::User' => [ 'posted_by' ] },
     links_to     => {},
     creation_security => {
        u   => undef,
        g   => { 3 => 'WRITE' },
        w   => 'READ',
     },
     as_string_order => [ qw/ title posted_on deadline description 
                              organization location required_skills recommended_skills 
                              application_info contact phone fax email url / ],
     as_string_label => { title => 'Title', organization => 'Organization',
                          deadline => 'Deadline', description => 'Description',
                          location => 'Location', required_skills => 'Required Skills',
                          recommended_skills => 'Recommended Skills',
                          application_info => 'Application Info', contact => 'Contact',
                          phone => 'Phone', fax => 'Fax', email => 'E-mail Address',
                          url => 'Website', posted_on => 'Posted On' },
     track => { create => 1, update => 1, remove => 1 },
     display => { url => '/Classified/show/' },
     name => 'title',
     object_name => 'Classified',
   },

};