#!/usr/bin/perl

# $Id: find_by_email.pl,v 1.1 2002/08/30 11:25:00 lachoy Exp $

# find_by_email.pl
#    Simple demo script on how to find news articles by a particular
#    user, searching for the email address using a join.

use strict;
use OpenInteract::Startup;

{
    my $usage = "Usage: $0 email-pattern";
    my ( $email_pattern ) = @ARGV;
    die "$usage\n"  unless ( $email_pattern );
    my $R = OpenInteract::Startup
                   ->setup_static_environment_options( $usage, {},
                                                       { temp_lib => 'lazy' } );
    my $where = 'sys_user.email LIKE ? AND sys_user.user_id = news.posted_by';

    print "BY LIST\n", '=' x 40, "\n";
    my $news_list = $R->news->fetch_group({ from   => [ 'sys_user', 'news' ],
                                            where  => $where,
                                            value  => [ $email_pattern ] });
    foreach my $news ( @{ $news_list } ) {
        my $poster = $news->posted_by_user;
        print "$news->{title} by $poster->{login_name} on $news->{posted_on}\n";
    }

    print "\nBY ITERATOR\n", '=' x 40, "\n";
    my $iter = $R->news->fetch_iterator({ from   => [ 'sys_user', 'news' ],
                                          where  => $where,
                                          value  => [ $email_pattern ] });
    while ( my $news = $iter->get_next ) {
        my $poster = $news->posted_by_user;
        print "$news->{title} by $poster->{login_name} on $news->{posted_on}\n";
    }
    $R->db->disconnect;
}
