package OpenInteract::Error::User;

# $Id: User.pm,v 1.2 2002/01/02 02:43:56 lachoy Exp $

use strict;
use Data::Dumper    qw( Dumper );
eval "require OpenInteract::Error::Main";

@OpenInteract::Error::User::ISA     = ();
$OpenInteract::Error::User::VERSION = sprintf("%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/);

my $ERROR_HOLD = $OpenInteract::Error::Main::ERROR_HOLD;

# Increment at which we should break down
# codes if not found (change to 100 for more macro)

my $CODE_SEEK = 10;

# Match up codes with the actual handler
$OpenInteract::Error::Intranet::CODES = {
  421 => \&bad_email_address,
  422 => \&login_already_exists,
};

# Since we can handle any code, we move the checking phase to the error handler

sub can_handle_error { 
  my ( $class, $err ) = @_;

  # Just find the general handler for that particular code. Here's an
  # example of how we find a code:
  # Original code: 512
  #  1) 512 -> not found -> 510
  #  2) 510 -> not found -> 500

  my $start = $CODE_SEEK; 
  my $info = $OpenInteract::Error::Intranet::CODES->{ $err->{code} };
  while ( ! $info and $start < 1000 ) {
    my $use_code = $err->{code} - ( $err->{code} % $start );
    $start *= 10;
    $info = $OpenInteract::Error::Intranet::CODES->{ $use_code };
  }
  return $info;
}


#000

#100

#200

#300

#400

sub bad_email_address {
  my ( $err ) = @_;
  my $R = OpenInteract::Request->instance;
  $R->{ $ERROR_HOLD }->{newuser}->{message} = 
         "The email address you entered ($err->{tmp_bad_address}) was bad.<Br>" .
         "Please try again using a proper email address.";
 return undef;
}



sub login_already_exists {
  my ( $err ) = @_;
  my $R = OpenInteract::Request->instance;
  $R->{ $ERROR_HOLD }->{newuser}->{message} = 
         "The login you requested ($err->{tmp_bad_login}) is already " .
         "in use.<br>Please pick another login name.";
  return undef;
}

#500

#600

#700

#800

#900


1;

__END__

=pod

=head1 NAME

OpenInteract::Error::User - Catalog of user application error handlers

=head1 SYNOPSIS

 $R->throw( { code => 421, type => 'email' } );

=head1 DESCRIPTION

=head1 ERROR CODES

B<0-100>: emerg - system is unusable

B<100-199>: alert - action must be taken immediately

B<200-299> crit - critical conditions

B<300-399> err - error conditions

B<400-499> warning - warning conditions

=over 4

=item * 421: bad_email_address

=item * 422: login_already_exists

=item * 424: fail_contact_search (falls through to 400 error, but
raised separately)

=back

B<500-599>: notice - normal but significant condition

B<600-699> info - informational

B<700-799> debug - debug-level messages

B<800-999> user-defined - whatever you wish them to be; no base

=head1 METHODS

=head1 NOTES

=head1 TO DO

=head1 BUGS

=head1 COPYRIGHT

Copyright (c) 2001-2002 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
