package OpenInteract::SQLInstall::Theme;

# $Id: Theme.pm,v 1.2 2002/01/02 02:43:55 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Theme::ISA = qw( OpenInteract::SQLInstall );

my %files = (
  tables   => [ 'theme.sql', 'theme_prop.sql' ],
  data     => [ 'install_theme.dat', 'install_theme_prop.dat' ],
  security => [ 'install_security.dat' ],
);

%HANDLERS = (
  create_structure => { '_default_' => [ 'create_structure', 
                                         { table_file_list => $files{tables} } ] },
  install_data     => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{data} } ] },
  install_security => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{security} } ] },
);

1;

__END__

=pod

=head1 NAME

OpenInteract::SQLInstall::Theme - SQL installer for the base_theme package

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 BUGS 

=head1 TO DO

=head1 SEE ALSO

=head1 COPYRIGHT

Copyright (c) 2001-2002 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
