package OpenInteract::Session::DBI;

# $Id: DBI.pm,v 1.1.1.1 2001/02/02 06:19:19 lachoy Exp $

use strict;

@OpenInteract::Session::DBI::ISA     = qw( OpenInteract::Session );
$OpenInteract::Session::DBI::VERSION = sprintf("%d.%02d", q$Revision: 1.1.1.1 $ =~ /(\d+)\.(\d+)/);

use constant DEBUG => 0;

sub _create_session { 
  my ( $class, $session_id ) = @_;
  my $R = OpenInteract::Request->instance;
  my %session_config = %{ $R->CONFIG->{session_info} };
  my $session_class = $session_config{session_class};
  delete $session_config{session_class};
  my %session = ();
  $R->scrib( 1, "Trying to fetch session $session_id" );
  eval { tie %session, $session_class, $session_id, { Handle => $R->db, %session_config };  };
  if ( $@ ) {
    my $R = OpenInteract::Request->instance;
    my $error_msg = ( ref $@ ) ? $@->{error} : $@;
    $R->throw( { code => 310, type => 'session',
                 system_msg => $@,
                 extra => { class => $session_class, 
                            session_id => $session_id } } );
    $R->{session} = undef;
    return undef;
  }
  return \%session;
}

1;


__END__

=pod

=head1 NAME

OpenInteract::Session::DBI - Create sessions within a DBI data source

=head1 DESCRIPTION

Provide a '_create_session' method for L<OpenInteract::Session> so we
can use a DBI data source as a backend for L<Apache::Session>.

=head1 BUGS 

=head1 TO DO

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
