#!perl -T

use Test::More;# tests => 2;

BEGIN {
    use_ok( 'String::Validator::Password' ) || print "Bail out!\n";
}

diag( "Testing String::Validator::Password $String::Validator::Password::VERSION, Perl $], $^X" );

my $Validator = String::Validator::Password->new() ;

is( $Validator->isa('String::Validator::Password'), 1 ,  'New validator isa String::Validator::Password' ) ;

# Other tests check mismatched strings, but coverage doesn't see
# this being hit.
is( $Validator->Check( 'this11', 'that11'), 1,
	"Test the branch where strings dont match to improve coverage stats" );
is( $Validator->Check( 'thisthat11', 'thisthat11'), -0,
	"Test the branch where strings dont match to improve coverage stats" );
is( $Validator->errstr, '', 'just checking that on success after failure errstr is empty' );
is( $Validator->errcnt, 0, 'just checking that on success after failure errctn is 0' );


done_testing();