#!/usr/bin/perl
use strict; use warnings;

use lib 'lib';
use Test::More;
use Test::Exception;
use Finance::Asset;

new_ok('Finance::Asset' => ['frxAUDUSD']);
new_ok('Finance::Asset' => [{symbol => 'frxAUDUSD'}]);

throws_ok { Finance::Asset->new } qr/No symbol provided/, 
    'No symbol provided';
throws_ok { Finance::Asset->new({symbol => ''}) } qr/No symbol provided/, 
    'No symbol provided';

done_testing();

