package Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType;
$Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType::VERSION = '3.02';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %ConsigneeName_of : ATTR(:get<ConsigneeName>);
    my %AttentionName_of : ATTR(:get<AttentionName>);
    my %AddressLine_of : ATTR(:get<AddressLine>);
    my %PoliticalDivision2_of : ATTR(:get<PoliticalDivision2>);
    my %PoliticalDivision1_of : ATTR(:get<PoliticalDivision1>);
    my %PostcodePrimaryLow_of : ATTR(:get<PostcodePrimaryLow>);
    my %PostcodeExtendedLow_of : ATTR(:get<PostcodeExtendedLow>);
    my %Region_of : ATTR(:get<Region>);
    my %Urbanization_of : ATTR(:get<Urbanization>);
    my %CountryCode_of : ATTR(:get<CountryCode>);

    __PACKAGE__->_factory(
        [   qw(        ConsigneeName
              AttentionName
              AddressLine
              PoliticalDivision2
              PoliticalDivision1
              PostcodePrimaryLow
              PostcodeExtendedLow
              Region
              Urbanization
              CountryCode

              )
        ],
        {   'ConsigneeName'       => \%ConsigneeName_of,
            'AttentionName'       => \%AttentionName_of,
            'AddressLine'         => \%AddressLine_of,
            'PoliticalDivision2'  => \%PoliticalDivision2_of,
            'PoliticalDivision1'  => \%PoliticalDivision1_of,
            'PostcodePrimaryLow'  => \%PostcodePrimaryLow_of,
            'PostcodeExtendedLow' => \%PostcodeExtendedLow_of,
            'Region'              => \%Region_of,
            'Urbanization'        => \%Urbanization_of,
            'CountryCode'         => \%CountryCode_of,
        },
        {   'ConsigneeName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'AttentionName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'AddressLine'   => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PoliticalDivision2' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PoliticalDivision1' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PostcodePrimaryLow' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PostcodeExtendedLow' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Region'       => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Urbanization' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'CountryCode'  => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'ConsigneeName'       => 'ConsigneeName',
            'AttentionName'       => 'AttentionName',
            'AddressLine'         => 'AddressLine',
            'PoliticalDivision2'  => 'PoliticalDivision2',
            'PoliticalDivision1'  => 'PoliticalDivision1',
            'PostcodePrimaryLow'  => 'PostcodePrimaryLow',
            'PostcodeExtendedLow' => 'PostcodeExtendedLow',
            'Region'              => 'Region',
            'Urbanization'        => 'Urbanization',
            'CountryCode'         => 'CountryCode',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType

=head1 VERSION

version 3.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AddressKeyFormatType from the namespace http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ConsigneeName (min/maxOccurs: 0/1)

=item * AttentionName (min/maxOccurs: 0/1)

=item * AddressLine (min/maxOccurs: 0/unbounded)

=item * PoliticalDivision2 (min/maxOccurs: 0/1)

=item * PoliticalDivision1 (min/maxOccurs: 0/1)

=item * PostcodePrimaryLow (min/maxOccurs: 0/1)

=item * PostcodeExtendedLow (min/maxOccurs: 0/1)

=item * Region (min/maxOccurs: 0/1)

=item * Urbanization (min/maxOccurs: 0/1)

=item * CountryCode (min/maxOccurs: 1/1)

=back

=head1 NAME

Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType
   ConsigneeName =>  $some_value, # string
   AttentionName =>  $some_value, # string
   AddressLine =>  $some_value, # string
   PoliticalDivision2 =>  $some_value, # string
   PoliticalDivision1 =>  $some_value, # string
   PostcodePrimaryLow =>  $some_value, # string
   PostcodeExtendedLow =>  $some_value, # string
   Region =>  $some_value, # string
   Urbanization =>  $some_value, # string
   CountryCode =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
