#!/usr/bin/perl -w
# $Id$
use strict;
use lib 'inc';

use ExtUtils::MakeMaker;
use WWW::MLite::Helper::Install;
use Cwd;

our $MSWIN = $^O =~ /mswin/i ? 1 : 0;
our $ProjectName = "Foo";
our $ProjectNameL = "foo";

WWW::MLite::Helper::Install::install(
        DIRPROJECT => getcwd(),
    ) or exit;

my $build_requires = {
        'ExtUtils::MakeMaker'   => 6.60,
        'Test::More'            => 0.94,
    };
my $prereq_pm = {
        'CGI'                   => 3.63,
        'CGI::Session'          => 4.42,
        'CTK'                   => 1.15,
        'DBI'                   => 1.60, 
        'JSON'                  => 2.17,
        'TemplateM'             => 3.03,
        'Try::Tiny'             => 0,
        'URI'                   => 1.60,
        #'WWW::MLite'            => 0,
        'XML::Simple'           => 2.20,
        'YAML'                  => 0.84,
    };
my $exefiles = [qw(
        bin/foo_script
    )];
WriteMakefile(
    'NAME'                  => $ProjectName,
    'DISTNAME'              => $ProjectName,
    'MIN_PERL_VERSION'      => 5.008001,
    'VERSION_FROM'          => sprintf("inc/%s.pm",$ProjectName),
    'ABSTRACT_FROM'         => sprintf("inc/%s.pm",$ProjectName),
    'BUILD_REQUIRES'        => $build_requires,
    'PREREQ_PM'             => $prereq_pm,
    #'EXE_FILES'             => $exefiles,
    'AUTHOR'                => 'Mr. Anonymous <email@example.com>',
    'LICENSE'               => 'GPL',
    'META_MERGE' => { "meta-spec" => { version => 2 },
        recommends => {
            'Data::Dumper'  => 0,
        },
        resources => {
            homepage        => 'http://www.example.com',
            repository      => 'http://svn.example.com/Foo/trunk',
            license         => 'http://opensource.org/licenses/gpl-license.php',
        },
        foo => {
            GMT             => 'Wed Jul 23 14:30:54 2014 GMT',
            ProjectName	    => $ProjectName,
            ProjectNameL    => $ProjectNameL,
            ProjectVersion  => '1.00',
            DefaultCharset  => 'utf-8',
            ContentType     => 'text/html; charset=utf-8',
            Author          => 'Mr. Anonymous',
            License         => 'GPL',
        },
    },
);

1;

package MY;
use CTK;

sub postamble {
my $section = <<'MAKE_FRAG';

PROJECTNAME = [PROJECTNAME]
PROJECTNAMEL = [PROJECTNAMEL]
PERM_DIR_X = 777

pure_all :: index.cgi \
            log$(DFSEP).exists \
            cache$(DFSEP).exists META.yml
	$(NOECHO) $(NOOP)

pure_install :: index.cgi
[INCLUDEBUILD]

index.cgi : share$(DFSEP)skel$(DFSEP)index.cgi
	$(NOECHO) $(ECHO) "Test done."
#	$(CP) src$(DFSEP)$(PROJECTNAME).conf $(PROJECTNAMEL).conf

# Create log directory
log$(DFSEP).exists :: Makefile.PL
	$(NOECHO) $(MKPATH) log
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) log
	$(NOECHO) $(TOUCH) log$(DFSEP).exists

# Create cache directory
cache$(DFSEP).exists :: Makefile.PL
	$(NOECHO) $(MKPATH) cache
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) cache
	$(NOECHO) $(TOUCH) cache$(DFSEP).exists

META.yml : MYMETA.yml
	-$(CP) MYMETA.yml META.yml

clean :: Makefile.PL
	-$(RM_F) $(MAKEFILE_OLD)

MAKE_FRAG

my $c = new CTK;
my $includebuild = <<'INCLUDEBUILD';
	$(NOECHO) $(ECHO)
	$(NOECHO) $(ECHO) " ++++++++++++++++++++++++++++++++++++++++++++"
	$(NOECHO) $(ECHO) " | See http://www.network-science.de/ascii/ |"
	$(NOECHO) $(ECHO) " |                                          |"
	$(NOECHO) $(ECHO) " |                  Configured & Installed. |"
	$(NOECHO) $(ECHO) " ++++++++++++++++++++++++++++++++++++++++++++"
	$(NOECHO) $(ECHO)
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) data
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) files
INCLUDEBUILD
#if ($c->isostype('Unix')) {
#    $includebuild = "\t".'$(CP) src$(DFSEP)httpd-include-unix.conf httpd-include.conf'
#} elsif ($c->isostype('Windows')) {
#    $includebuild = "\t".'$(CP) src$(DFSEP)httpd-include-win32.conf httpd-include.conf'
#} else {
#    $includebuild = "\t".'$(NOECHO) $(ECHO) "Skipped. OS unsupported: '.$^O.'"'
#}

return CTK::dformat($section, {
        INCLUDEBUILD => $includebuild,
        PROJECTNAME  => $ProjectName,
        PROJECTNAMEL => $ProjectNameL,
    });
}

1;

__END__
