/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnparsedTextIterator
implements SequenceIterator<StringValue> {
    LineNumberReader reader;
    NameChecker checker;
    URI absoluteURI;
    XPathContext context;
    StringValue current = null;
    int position = 0;
    String encoding = null;
    SourceLocator location;

    public UnparsedTextIterator(URI absoluteURI, XPathContext context, String encoding, SourceLocator location) throws XPathException {
        Configuration config = context.getConfiguration();
        Reader reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        this.reader = new LineNumberReader(reader);
        this.absoluteURI = absoluteURI;
        this.context = context;
        this.checker = context.getConfiguration().getNameChecker();
        this.encoding = encoding;
        this.location = location;
    }

    @Override
    public StringValue next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        try {
            String s = this.reader.readLine();
            if (s == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.checkLine(this.checker, s);
            this.current = new StringValue(s);
            ++this.position;
            return this.current;
        }
        catch (IOException err) {
            XPathException e = UnparsedText.handleIOError(this.absoluteURI, err);
            e.setLocator(this.location);
            throw e;
        }
    }

    @Override
    public StringValue current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SequenceIterator<StringValue> getAnother() throws XPathException {
        return new UnparsedTextIterator(this.absoluteURI, this.context, this.encoding, this.location);
    }

    @Override
    public int getProperties() {
        return 0;
    }

    private void checkLine(NameChecker checker, String buffer) throws XPathException {
        int c = 0;
        while (c < buffer.length()) {
            int ch32;
            if (UTF16CharacterSet.isHighSurrogate(ch32 = buffer.charAt(c++))) {
                char low = buffer.charAt(c++);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (checker.isValidChar(ch32)) continue;
            XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + this.position + " column=" + (c + 1) + " value=hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1190");
            err.setLocator(this.location);
            throw err;
        }
    }
}

