#!/usr/bin/perl
# $Id: 05-DELEG.t 2028 2025-07-22 16:52:42Z willem $	-*-perl-*-
#

use strict;
use warnings;
use Net::DNS;
use Net::DNS::ZoneFile;

use Test::More;
use TestToolkit;

exit( plan skip_all => 'unresolved AUTOLOAD regression	[perl #120694]' )
		unless ( $] > 5.018001 )
		or ( $] < 5.018 );

plan tests => 25;


my $type = 'DELEG';
my $code = $Net::DNS::Parameters::typebyname{$type};

my $typecode = unpack 'xn', Net::DNS::RR->new( type => $type )->encode;
is( $typecode, $code, "$type RR type code = $code" );


for my $rr ( Net::DNS::RR->new( my $record = 'example. IN DELEG' ) ) {
	ok( $rr, "new DELEG RR:	$record" );
	is( $rr->priority,   undef, 'undefined priority' );
	is( $rr->targetname, undef, 'undefined targetname' );
	ok( $rr->string,  'presentation format string' );
	ok( $rr->generic, 'RFC3597 generic format' );
}


for my $rr ( Net::DNS::RR->new( my $record = 'example. DELEG DIRECT=servername' ) ) {
	ok( $rr, "new DELEG RR:	$record" );
	is( $rr->priority, 1, 'non-zero priority' );
	ok( $rr->targetname, 'defined targetname' );
}


for my $rr ( Net::DNS::RR->new( my $record = 'example. DELEG DIRECT=servername IPv6=2001:db8::53' ) ) {
	ok( $rr, "new DELEG RR:	$record" );
	is( $rr->priority, 1, 'non-zero priority' );
	ok( $rr->targetname, 'defined targetname' );
}


for my $rr ( Net::DNS::RR->new( my $record = 'example. DELEG IPv4=192.0.2.1 IPv6=2001:db8::53 port=53' ) ) {
	ok( $rr, "new DELEG RR:	$record" );
	is( $rr->targetname, undef, 'undefined targetname' );
	ok( $rr->priority(123), 'set non-zero priority' );
	is( $rr->priority, 123, 'changed priority' );
	ok( $rr->string,  'presentation format string' );
	ok( $rr->generic, 'RFC3597 generic format' );
}


for my $rr ( Net::DNS::RR->new( my $record = 'example. DELEG INCLUDE="targetname"' ) ) {
	ok( $rr, "new DELEG RR:	$record" );
	is( $rr->priority, 0, 'zero priority' );
	ok( $rr->targetname, 'defined targetname' );
	ok( $rr->string,     'presentation format string' );
	exception( 'priority parameter disallowed', sub { $rr->_parse_rdata('priority=123') } );
}

exception( 'incomplete INCLUDE parameter', sub { Net::DNS::RR->new('example. DELEG INCLUDE') } );
exception( 'incomplete DIRECT parameter',  sub { Net::DNS::RR->new('example. DELEG DIRECT') } );

exit;

