#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__set8025 = "$Header: c:/curses/private/RCS/_set8025.c%v 2.0 1992/11/15 03:24:35 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_set_80x25()	- force a known screen state: 80x25 text mode.

  PDCurses Description:
 	This is a private PDCurses function.

 	Forces the appropriate 80x25 alpha mode given the display adapter.

 	Since we currently do not support changing the virtual console size,
 	this routine is a NOP under Flexos.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	No errors are defined for this routine.

  Portability:
 	PDCurses	int	PDC_set_80x25( void );

**man-end**********************************************************************/

int	PDC_set_80x25(void)
{
#ifdef	OS2
	VIOMODEINFO modeInfo;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_set_80x25() - called\n");
#endif

#ifdef	FLEXOS
	return( OK );
#endif

#ifdef	DOS
	switch (_cursvar.adapter)
	{
	case _CGA:
	case _EGACOLOR:
	case _EGAMONO:
	case _VGACOLOR:
	case _VGAMONO:
	case _MCGACOLOR:
	case _MCGAMONO:
		regs.h.ah = 0x00;
		regs.h.al = 0x03;
		int86(0x10, &regs, &regs);
		break;
	case _MDA:
		regs.h.ah = 0x00;
		regs.h.al = 0x07;
		int86(0x10, &regs, &regs);
	default:
		break;
	}
	return( OK );
#endif

#ifdef	OS2
	modeInfo.cb = sizeof(modeInfo);
	/* set most parameters of modeInfo */
	VioGetMode(&modeInfo, 0);
	modeInfo.fbType = 1;
	VioSetMode(&modeInfo, 0);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif
}
