#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__scroll = "$Header: c:/curses/private/RCS/_scroll.c%v 2.0 1992/11/15 03:24:34 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_scroll()	- low level screen scroll

  PDCurses Description:
 	Scrolls a window in the current page up or down. Urow, lcol,
 	lrow, rcol are the window coordinates.	Lines is the number of
 	lines to scroll. If 0, clears the window, if < 0 scrolls down,
 	if > 0 scrolls up.  Blanks areas that are left, and sets
 	character attributes to attr. If in a colour graphics mode,
 	fills them with the colour 'attr' instead.

  PDCurses Return Value:
 	The PDC_scroll() function returns OK on success otherwise ERR is returned.

  PDCurses Errors:
 	An error will only be returned on the Flexos platform if s_copy()
 	fails.

  Portability:
 	PDCurses	int PDC_scroll( int urow, int lcol, int rcol,
 				     int nlines, chtype attr );

**man-end**********************************************************************/

int	PDC_scroll(int urow, int lcol, int lrow, int rcol, int nlines, chtype attr)
{
#ifdef	FLEXOS
	int	srow;
	int	scol;
	int	drow;
	int	dcol;
	int	nrows
	int	ncols;
	char	blank = (char) _cursvar.blank;
#endif

#ifdef	OS2
	USHORT ch=((attr << 8) & _cursvar.blank);
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_scroll() - called: urow %d lcol %d lrow %d rcol %d nlines %d\n",urow,lcol,lrow,rcol,nlines);
#endif

#ifdef	FLEXOS
	if (nlines == 0)
	{
		sframe.fr_pl[0] = (UBYTE *) & blank;
		sframe.fr_pl[1] = (UBYTE *) & attr;
		sframe.fr_pl[2] = (UBYTE *) " ";
		sframe.fr_nrow = 1;
		sframe.fr_ncol = 1;
		sframe.fr_use = 0x00;
		nrows = lrow;
		ncols = rcol;
		srow = drow = 0;
		scol = dcol = 0;
	}
	else
	if (nlines < 0)
	{
		srow = urow;
		scol = lcol;
		drow = lrow;
		dcol = rcol;
	}
	else
	if (nlines > 0)
	{
		srow = urow;
		scol = lcol;
		drow = lrow;
		dcol = lcol;
	}

	drect.r_row = drow;
	drect.r_col = dcol;
	drect.r_nrow = nrows;
	drect.r_ncol = ncols;

	srect.r_col = scol;
	srect.r_row = srow;
	srect.r_nrow = nrows;
	srect.r_ncol = ncols;

	if (nlines != 0)
		retcode = s_copy(0x03, 0x01L, 0L, (far unsigned short *) &drect, 0L, (far unsigned short *) &srect);
	else
		retcode = s_copy(0x03, 0x01L, 0L, (far unsigned short *) &drect, (far unsigned short *) &sframe, (far unsigned short *) &srect);
	return( (retcode < 0L) ? ERR : OK );
#endif

#ifdef	DOS
	if (nlines >= 0)
	{
		regs.h.ah = 0x06;
		regs.h.al = (unsigned char) nlines;
	}
	else
	{
		regs.h.ah = 0x07;
		regs.h.al = (unsigned char) (-nlines);
	}
	regs.h.bh = (unsigned char)((attr & A_ATTRIBUTES) >> 8);
	regs.h.ch = (unsigned char) urow;
	regs.h.cl = (unsigned char) lcol;
	regs.h.dh = (unsigned char) lrow;
	regs.h.dl = (unsigned char) rcol;
	int86(0x10, &regs, &regs);
	return( OK );
#endif

#ifdef	OS2
	if (nlines > 0)
		VioScrollUp(urow, lcol, lrow, rcol, nlines, (PBYTE)&ch, 0);
	else
		if (nlines < 0)
			VioScrollDn(urow, lcol, lrow, rcol, nlines, (PBYTE)&ch, 0);
		else
/* this clears the whole screen */
			VioScrollUp(0, 0, -1, -1, -1, (PBYTE)&ch, 0);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif
}
