#define	CURSES_LIBRARY	1
#include <curses.h>




/*man-start*********************************************************************

  PDC_scrn_modes_equal()	- Decide if two screen modes are equal

  PDCurses Description:
 	Mainly required for OS/2. It decides if two screen modes
        (VIOMODEINFO structure) are equal. Under DOS it just compares
        two integers

  PDCurses Return Value:
 	This function returns TRUE if equal else FALSe.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_scrn_modes_equal( int mode1, int mode2 );
 	OS2 PDCurses	int PDC_scrn_modes_equal( VIOMODEINFO mode1, VIOMODEINFO mode2 );

**man-end**********************************************************************/

#ifdef     OS2
bool	PDC_scrn_modes_equal(VIOMODEINFO mode1, VIOMODEINFO mode2)
#else
bool	PDC_scrn_modes_equal(int mode1, int mode2)
#endif
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_scrn_modes_equal() - called\n");
#endif

#ifdef     OS2
	return (   (mode1.cb == mode2.cb) && (mode1.fbType == mode2.fbType)
            && (mode1.color == mode2.color) && (mode1.col == mode2.col)
            && (mode1.row == mode2.row) && (mode1.hres == mode2.vres)
            && (mode1.vres == mode2.vres) );
#else
	return (mode1 == mode2);
#endif
}
