#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef	PDC_putc

#ifdef PDCDEBUG
char *rcsid__putc = "$Header: c:/curses/private/RCS/_putc.c%v 2.1 1993/01/08 15:45:10 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_putc()	- Output a character in the current attribute.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Outputs character 'chr' to screen in tty fashion. If a colour
 	mode is active, the character is written with colour 'colour'.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_putc( chtype character, chtype color );

**man-end**********************************************************************/

int	PDC_putc( chtype character, chtype color )
{
#ifdef	OS2
	int curRow = PDC_get_cur_row ();
	int curCol = PDC_get_cur_col ();
#endif

#ifdef UNIX
static chtype last_attribute=0;
#ifdef CHTYPE_LONG
static bool last_acs=FALSE;
#endif
static int curses_to_ansi[] = {0,4,2,6,1,5,3,7};
short fore,back;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_putc() - called:char=%c attrib=0x%x color=0x%x\n",character & A_CHARTEXT,character & A_ATTRIBUTES,color);
#endif

#ifdef	FLEXOS
	retcode = s_write(0x00, 0x01L, (_far char *) &character, 1L, 0);
	return( (retcode < 0L) ? ERR : OK );
#endif

#ifdef	DOS
	regs.h.ah = 0x09;	/* Avoid screen wrap.  Don't advance cursor. */
	regs.h.al = (unsigned char) (character & A_CHARTEXT);
	regs.h.bh = _cursvar.video_page;
	regs.h.bl = (unsigned char) (color);
	regs.x.cx = 1;
	int86(0x10, &regs, &regs);
	return( OK );
#endif

#ifdef	OS2
	VioWrtTTY ((PCH)&character, 1, 0);
	VioWrtNAttr ((PBYTE)&color, 1, (USHORT)curRow, (USHORT)curCol, 0);
	PDC_gotoxy (curRow, curCol);
	return( OK );
#endif

#ifdef UNIX
	if (last_attribute != color)
		{
		if (exit_attribute_mode != NULL)
			putp(exit_attribute_mode);
		last_attribute = color;
		if ((color & A_COLOR) && has_colors())
			{
			pair_content(PAIR_NUMBER(color),&fore,&back);
			putp(tparm(set_foreground,curses_to_ansi[fore]));
			putp(tparm(set_background,curses_to_ansi[back]));
			}
		if (color & A_BOLD)
			if (enter_bold_mode != NULL)
				putp(enter_bold_mode);
		if (color & A_BLINK)
			if (enter_blink_mode != NULL)
				putp(enter_blink_mode);
		if (color & A_REVERSE)
			if (enter_reverse_mode != NULL)
				putp(enter_reverse_mode);
#ifdef CHTYPE_LONG
		if (color & A_STANDOUT)
			if (enter_standout_mode != NULL)
				putp(enter_standout_mode);
		if (color & A_ALTCHARSET)
			{
			if (last_acs == FALSE)
				if (enter_alt_charset_mode != NULL)
					putp(enter_alt_charset_mode);
			last_acs = TRUE;
			}
		else
			{
			last_acs = FALSE;
			if (exit_alt_charset_mode != NULL)
				putp(exit_alt_charset_mode);
			}
#endif
		}
	putchar(character & A_CHARTEXT);
	return( OK );
#endif
}
