#define	CURSES_LIBRARY	1
#define NEEDS_OS2       1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__print = "$Header: c:/curses/private/RCS/_print.c%v 2.0 1992/11/15 03:24:33 MH Rel $";
#endif

#ifdef OS2
#  if !defined (CURSES__32BIT__) && !defined(CSET2) && !defined(MSC) &&!defined(TC)
#define INCL_DOS
#include <bsedos.h>
#endif
char Printer[]="LPT1:";
#endif


/*man-start*********************************************************************

  PDC_print()	- Provides primitive access to the BIOS printer functions

  PDCurses Description:
 	This is a private PDCurses routine.

 	Implements write/init/read printer services at the BIOS level.

 	This provides the basic support that PDCurses needs to dump the
 	contents of windows or pads to the printer attached to the BIOS
 	printer port.

  PDCurses Return Value:
 	See the BIOS INT 0x17 specifications.

  PDCurses Errors:
 	See the BIOS INT 0x17 specifications.

  Portability:
 	PDCurses	int PDC_print( int cmd, int byte, int port );

**man-end**********************************************************************/

int	PDC_print(int cmd, int byte, int port)
{
#ifdef	OS2
#  if !defined (CURSES__32BIT__) && !defined(CSET2) && !defined(TC)
	HFILE Lpt;
	USHORT Action;
	USHORT NoWritten;
#  endif
#endif

#ifdef	DOS
	int	status = 0;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_print() - called\n");
#endif

#ifdef	FLEXOS
	return( OK );
#endif

#ifdef	DOS
	regs.h.ah = (unsigned char)cmd;
	regs.h.al = (unsigned char)byte;
	regs.x.dx = (unsigned int)port;
	int86(0x17, &regs, &regs);
	status = regs.h.ah;
	return (status);
#endif

#ifdef	OS2
#  if !defined (CURSES__32BIT__) && !defined(CSET2) && !defined(TC)
	if (DosOpen((PSZ)Printer, &Lpt, &Action, 0,0,0,0,0) != 0)
		return(ERR);
	DosWrite(Lpt,&byte,1,&NoWritten);
	DosClose(Lpt);
	return(NoWritten == 1);
#  endif
#endif
}
