#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__getcrsr = "$Header: c:/curses/private/RCS/_getcrsr.c%v 2.0 1992/11/15 03:24:25 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_cursor_mode()	- Get the cursor start and stop scan lines.

  PDCurses Description:
 	Gets the cursor type to begin in scan line startrow and end in
 	scan line endrow.  Both values should be 0-31.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_get_cursor_mode( void );

**man-end**********************************************************************/

int	PDC_get_cursor_mode(void)
{

#ifdef	DOS
#  if	SMALL || MEDIUM
	short far*	CURSOR_MODE = (short far *) _FAR_POINTER(0,0x0460);
#  else
	short * CURSOR_MODE = (short *) _FAR_POINTER(0,0x0460);
#  endif
	short		cmode;
#endif

#ifdef	OS2
	VIOCURSORINFO cursorInfo;
	short		cmode;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_cursor_mode() - called\n");
#endif

#ifdef	FLEXOS
	/*
	 * Under FLEXOS, this routine returns 1 if the cursor is on and 0 if
	 * the cursor is off...
	 */
	s_getfield(T_VIRCON, VC_MODE, STDOUT, (far BYTE *) & vir,
		sizeof(vir.vc_mode));

	if (vir.vc_mode & VCWM_CURSOR)
		return (TRUE);
	else
		return (FALSE);
#endif

#ifdef	DOS
	cmode = *CURSOR_MODE;
	return (cmode);
#endif

#ifdef	OS2
	VioGetCurType (&cursorInfo, 0);
/* I am not sure about this JGB */
	cmode = ((cursorInfo.yStart << 8) | (cursorInfo.cEnd));
	return(cmode);
#endif

#ifdef UNIX
	return(0);/* this is N/A */
#endif
}
