#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif

#ifdef PDCDEBUG
char *rcsid__getcols = "$Header: c:/curses/private/RCS/_getcols.c%v 2.0 1992/11/15 03:24:24 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_columns()	- return width of screen/viewport.

  PDCurses Description:
 	This is a private PDCurses function

 	This function will return the width of the current screen.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_columns( void );

**man-end**********************************************************************/

int	PDC_get_columns(void)
{
#ifdef	DOS
	int		cols;
	char *env_cols;
#endif

#ifdef	OS2
	VIOMODEINFO modeInfo;
	int cols;
	char *env_cols;
#endif


#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_columns() - called\n");
#endif

#ifdef	FLEXOS
	return( vir.vc_size.rs_ncols );
#endif

#ifdef	DOS
/* use the value from COLS environment variable, if set. MH 10-Jun-92 */
/* and use the minimum of COLS and return from int10h    MH 18-Jun-92 */
	regs.h.ah = 0x0f;
	int86(0x10, &regs, &regs);
	cols = (int)regs.h.ah;
	env_cols = (char *)getenv("COLS");
	if (env_cols != (char *)NULL)
	{
		cols = min(atoi(env_cols),cols);
	}
	return(cols);
#endif

#ifdef	OS2
	modeInfo.cb = sizeof(modeInfo);
	VioGetMode(&modeInfo, 0);
	cols = modeInfo.col;
	env_cols = (char *)getenv("COLS");
	if (env_cols != (char *)NULL)
	{
		cols = min(atoi(env_cols),cols);
	}
	return(cols);
#endif

#ifdef UNIX
	return(columns);
#endif
}
