#define CURSES_LIBRARY  1
#include <curses.h>
#undef  wgetstr

#ifdef PDCDEBUG
char *rcsid_wgetstr = "$Header: c:/curses/portable/RCS/wgetstr.c%v 2.1 1993/01/08 15:39:06 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wgetstr()     - read string

  X/Open Description:
        A series of characters are read until a newline or carriage
        return is received.  The resulting value is placed in the area
        pointed to by the character pointer str.  The user's erase (^H)
        and kill (^U) characters are interpreted.

        NOTE: getstr(), mvgetstr(), and mvwgetstr() are macros.

        WARNING:  There is no way to know how long the buffer passed to 
                  this function is, so it is possible to overwrite wrong 
                  memory or code!!

  PDCurses Description:
        Tabs are automatically expanded to spaces.

  X/Open Return Value:
        These functions return OK on success and ERR on error.

  PDCurses Errors:
        It is an error to call this function with a NULL window pointer.

  Portability:
        PDCurses        int wgetstr( WINDOW* win, char* str );
        X/Open Dec '88  int wgetstr( WINDOW* win, char* str );
        BSD Curses      int wgetstr( WINDOW* win, char* str );
        SYS V Curses    int wgetstr( WINDOW* win, char* str );

**man-end**********************************************************************/



int     wgetstr(WINDOW *win, char *str)
{
        int     ch, i, n;
        int     t = win->_tabsize;
        int     x = win->_curx;
        int     mx = win->_maxx;
        char*   p = str; 
        bool    stop = FALSE;
        bool    oldecho;
        bool    oldcbreak;
        bool    oldnodelay;

#ifdef PDCDEBUG
        if (trace_on) PDC_debug("wgetstr() - called\n");
#endif

        if (win == (WINDOW *)NULL)
                return (ERR);

#ifdef UNIX
        wrefresh(win);

        while ((*str = wgetch(win)) != ERR && *str != '\n')
             ;
        if (*str == ERR) {
                *str = '\0';
                waddstr(win,p);
                return ERR;
        }
        *str = '\0';
        waddstr(win,p);
        return OK;

#else
        oldcbreak       = _cursvar.cbreak;      /* remember states       */
        oldecho         = _cursvar.echo;
        oldnodelay      = win->_nodelay;

        _cursvar.echo   = FALSE;                /* we do echo ourselves */
        cbreak();               /* ensure each key is returned immediately */
        win->_nodelay   = FALSE;                /* don't return -1       */

        wrefresh (win);

        while (!stop)
        {
          switch (ch = wgetch (win) & A_CHARTEXT)
          {
            case '\t':
              ch = ' ';
              n = t - (win->_curx - x)%t;
              for (i=0; i<n; i++) 
              {
                if (oldecho) waddch (win, ch); 
                *p++ = ch; 
              }
              break;

            case _ECHAR:  /* CTRL-H */   /* Delete character */
              if (p > str)
              {
                if (oldecho) waddstr (win, "\b \b");
                p--;
              }
              break;

            case _DLCHAR:  /* CTRL-U */  /* Delete line */
              while (p > str)
              {
                if (oldecho) waddstr (win, "\b \b");
                p--;
              }
              break;

            case _DWCHAR: /* CTRL-W */  /* Delete word */
              while ((*p == ' ') && (p > str))
              {
                if (oldecho) waddstr (win, "\b \b");
                p--;
              }
              while ((*p != ' ') && (p > str))
              {
                if (oldecho) waddstr (win, "\b \b");
                p--;
              }
              break;

            case '\n':
            case '\r':
              stop = TRUE;
              if (oldecho) waddch (win, '\n');
              break;

            default:
              *p++ = ch;
              if (oldecho) waddch (win, ch);
              break;
          }
          wrefresh (win);
        }
        *p = '\0';

        _cursvar.echo   = oldecho;      /* restore old settings */
        _cursvar.cbreak = oldcbreak;
        win->_nodelay   = oldnodelay;

        return (OK);
#endif
}
