#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	waddch

#ifdef PDCDEBUG
char *rcsid_waddch = "$Header: c:/curses/portable/RCS/waddch.c%v 2.0 1992/11/15 03:29:20 MH Rel $";
#endif




/*man-start*********************************************************************

  waddch()	- add character to window

  X/Open Description:
 	The routine addch inserts the character ch into the default
 	window at the current cursor position and the window cursor is
 	advanced.  The character is of the type chtype as containing
 	both data and attributes.

 	The routine waddch inserts the character ch into the specified
 	window at the current cursor position.  The cursor position is
 	advanced.

 	The routine mvaddch moves the cursor to the specified (y, x)
 	position and inserts the character ch into the default window.
 	The cursor position is advanced after the character has been
 	inserted.

 	The routine mvwaddch moves the cursor to the specified (y, x)
 	position and inserts the character ch into the specified
 	window.  The cursor position is advanced after the character
 	has been inserted.

 	All these routines are similar to putchar.  The following
 	information applies to all the routines.

 	If the cursor moves on to the right margin, an automatic
 	newline is performed.  If scrollok is enabled, and a character
 	is added to the bottom right corner of the screen, the
 	scrolling region will be scrolled up one line.  If scrolling
 	is not allowed, ERR will be returned.

 	If ch is a tab, newline, or backspace, the cursor will be
 	moved appropriately within the window.  If ch is a newline,
 	the clrtoeol routine is called before the cursor is moved to
 	the beginning of the next line.  If newline mapping is off,
 	the cursor will be moved to the next line, but the x
 	coordinate will be unchanged.  If ch is a tab the cursor is
 	moved to the next tab position within the window.  If ch is
 	another control character, it will be drawn in the ^X
 	notation.  Calling the inch routine after adding a control
 	character returns the representation of the control character,
 	not the control character.

 	Video attributes can be combined with a character by ORing
 	them into the parameter.  This will result in these attributes
 	being set.  The intent here is that text, including
 	attributes, can be copied from one place to another using inch
 	and addch.

 	NOTE: addch(), mvaddch(), and mvwaddch() are macros.

  PDCurses Description:
 	Depending upon the state of the raw character output, 7- or
 	8-bit characters will be output.  NOTE: Needs work before release!

  X/Open Return Value:
 	The waddch() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int waddch( WINDOW* win, chtype c );
 	X/Open Dec '88	int waddch( WINDOW* win, chtype c );
 	BSD Curses	int waddch( WINDOW* win, chtype c );
 	SYS V Curses	int waddch( WINDOW* win, chtype c );

**man-end**********************************************************************/

int	waddch(WINDOW *win, chtype c)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("waddch() - called\n");
#endif

	return( PDC_chadd( win, (chtype)c, !(_cursvar.raw_out), TRUE ) );
}
