#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	unctrl

#ifdef PDCDEBUG
char *rcsid_unctrl = "$Header: c:/curses/portable/RCS/unctrl.c%v 2.0 1992/11/15 03:29:19 MH Rel $";
#endif




static char strbuf[3] = {0, 0, 0};

/*man-start*********************************************************************

  unctrl()	- convert character to printable form

  X/Open Description:
 	The unctrl routine expands the character c into a character
 	string which is a printable representation of the character.

 	Control characters are displayed in the ^X notation.  Printing
 	characters are displayed normally.

  PDCurses Description:
 	The conversion from a control character to a two-character
 	sequence is done by the unctrl() function. In the BSD version
 	of curses it is done by a macro, which uses a publicly
 	available translation table. Some ill-behaved application
 	programs use the table directly, and since it does not exist
 	in this curses version such application will link with an
 	error message complainting about undefined symbols.

  X/Open Return Value:
 	The unctrl() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	char* unctrl( chtype c );
 	X/Open Dec '88	char* unctrl( chtype c );
 	BSD Curses	char* unctrl( chtype c );
 	SYS V Curses	char* unctrl( chtype c );

**man-end**********************************************************************/

char*	unctrl(chtype c)
{
	chtype	ic = c;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("unctrl() - called\n");
#endif

	ic &= A_CHARTEXT;
	if (ic >= 0x20 && ic != 0x7f)		/* normal characters */
	{
		strbuf[0] = (char) ic;
		strbuf[1] = '\0';
		return( strbuf );
	}
	strbuf[0] = '^';	/* '^' prefix */
	if (c == 0x7f)
	{
		/*
		 * 0x7f == DEL
		 */
		strbuf[1] = '?';
	}
	else
	{
		/*
		 * other control
		 */
		strbuf[1] = (char)(ic + '@');
	}
	return( strbuf );
}
