#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	scroll

#ifdef PDCDEBUG
char *rcsid_scroll = "$Header: c:/curses/portable/RCS/scroll.c%v 2.0 1992/11/15 03:28:49 MH Rel $";
#endif





/*man-start*********************************************************************

  scroll()	- scroll window

  X/Open Description:
 	The window is scrolled up one line.  THis involves moving the
 	lines in the window data strcture.

  PDCurses Description:
 	No additional functionality at this time.  Thought it might be
 	be nice to provide reverse scrolling, or scrolling 'n' lines
 	in a positive (down) or negative (up) direction in a future
 	release for the PC platform.

  X/Open Return Value:
 	The scroll() function returns OK on succes and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL* window.

  Portability:
 	PDCurses	int scroll( WINDOW* win );
 	X/Open Dec '88	int scroll( WINDOW* win );
 	SysV Curses	int scroll( WINDOW* win );
 	BSD Curses	int scroll( WINDOW* win );

**man-end**********************************************************************/

int	scroll(WINDOW *win)
{
	register int	i;
	chtype	blank;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("scroll() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	blank = win->_blank | win->_attrs;

	/*
	 * Check if window scrolls	and cursor in region.
	 */
	if ((!win->_scroll) ||
	    (win->_cury < win->_tmarg) ||
	    (win->_cury > win->_bmarg))
	{
		return( ERR );
	}

	for (i = win->_tmarg; (i < win->_bmarg); i++)
	{
		memcpy(win->_y[i],win->_y[i+1],sizeof(chtype)*(win->_maxx)); /* copy contents of line
							 * so sub windows work */
		win->_firstch[i] = 0;
		win->_lastch[i] = win->_maxx - 1;
	}

	for (i=0;i<win->_maxx;i++)
		win->_y[win->_bmarg][i] = blank;

	if (win->_cury > win->_tmarg)			/* if not on top line */
		win->_cury--;				/* cursor scrolls too */

	win->_firstch[win->_bmarg] = 0;
	win->_lastch[win->_bmarg] = win->_maxx - 1;
	return( OK );
}
