#include <stdio.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef	longname

#ifdef PDCDEBUG
char *rcsid_longname = "$Header: c:/curses/portable/RCS/longname.c%v 2.0 1992/11/15 03:28:59 MH Rel $";
#endif




#ifdef	FLEXOS
extern	char*	_flexos_gname();
#endif

static	char	_display[ 128 ];




/*man-start*********************************************************************

  longname()	- return full terminal type name

  X/Open Description:
 	This function returns a pointer to a static area containing a
 	verbose description of the current terminal.  The maximum length
 	of the string is 128 characters.  It is defined only after the
 	call to initscr() or newterm().  The area is overwritten by each
 	call to newterm() and is not restored by set_term().  The value
 	should therefore be saved between calls to newterm(), if
 	longname() is going to be used with multiple terminals.

  PDCurses Description:
 	In addition to the above definition, the form of this string is
 	the adapter name (or video card name) and the text resolution.
 	This may also be followed by the notation that the video card
 	may be a clone, which indicates that the card identification
 	maps to more than one unique card.

 	e.g. The MDS Genius and the Quadram QuadHPG identify themselves
 	in the same manner, but are vastly different in maximum resolution.

  X/Open Return Value:
 	The longname() function returns a pointer to a verbose description
 	of the current terminal on success and the null pointer on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	char* longname( void );
 	X/Open Dec '88	char* longname( void );
 	BSD Curses	char* longname( void );
 	SYS V Curses	char* longname( void );

**man-end**********************************************************************/

char*	longname(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("longname() - called\n");
#endif

#ifdef UNIX
	strcpy(_display,_CUR_TERM.name_long);
#else

#ifdef     OS2
	switch	(_cursvar.adapter.adapter)
	{
	case DISPLAY_CGA:	sprintf(_display, "CGA-%dx%d", LINES, COLS);	  break;
	case DISPLAY_MONOCHROME:	sprintf(_display, "MDA-%dx%d", LINES, COLS);	  break;
	case DISPLAY_EGA:	sprintf(_display, "EGA-%dx%d", LINES, COLS); break;
	case DISPLAY_VGA:	sprintf(_display, "VGA-%dx%d", LINES, COLS); break;
	case DISPLAY_8514A:     sprintf(_display, "8514-%dx%d", LINES, COLS);  break;
#endif

#ifdef DOS
	switch	(_cursvar.adapter)
	{
	case _CGA:	sprintf(_display, "CGA-%dx%d", LINES, COLS);	  break;
	case _MDA:	sprintf(_display, "MDA-%dx%d", LINES, COLS);	  break;
	case _EGACOLOR:	sprintf(_display, "EGAColor-%dx%d", LINES, COLS); break;
	case _EGAMONO:	sprintf(_display, "EGAMono-%dx%d", LINES, COLS);  break;
	case _VGACOLOR:	sprintf(_display, "VGAColor-%dx%d", LINES, COLS); break;
	case _VGAMONO:	sprintf(_display, "VGAMono-%dx%d", LINES, COLS);  break;
	case _MCGACOLOR:sprintf(_display, "MCGAColor-%dx%d", LINES, COLS);break;
	case _MCGAMONO:	sprintf(_display, "MCGAMono-%dx%d", LINES, COLS); break;
	case _MDS_GENIUS:sprintf(_display, "Genius-%dx%d", LINES, COLS);  break;
#endif

#ifdef	FLEXOS
	case _FLEXOS:	sprintf(_display, "%s", _cursesgname());	  break;
#endif

	default:	sprintf(_display, "Unknown-%dx%d", LINES, COLS);  break;
	}

	if (_cursvar.bogus_adapter)
		strcat(_display, " (Clone)");
#endif

	return (_display);
}
