#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	killchar

#ifdef PDCDEBUG
char *rcsid_killchar = "$Header: c:/curses/portable/RCS/killchar.c%v 2.0 1992/11/15 03:28:58 MH Rel $";
#endif




/*man-start*********************************************************************

  killchar()	- return current KILL character

  X/Open Description:
 	The user's current line KILL character.

  PDCurses Description:
 	This is hardcoded at this time.  There may be future development
 	to allow applications an easy way to specify this value.

  X/Open Return Value:
 	The killchar() function returns the user's current line KILL
 	character.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	char killchar( void );
 	X/Open Dec '88	char killchar( void );
 	BSD Curses	char killchar( void );
 	SYS V Curses	char killchar( void );

**man-end**********************************************************************/

char	killchar(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("killchar() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	ioctl(_CUR_TERM.fd, TCGETA, &_CUR_TERM.prog_mode);
	return(_CUR_TERM.prog_mode.c_cc[VKILL]);
#else
	ioctl(_CUR_TERM.fd, TIOCGETP, &_CUR_TERM.prog_mode.v6);
	return(_CUR_TERM.prog_mode.v6.sg_kill);
#endif
#else
	return( _DLCHAR );	/* line delete char (^U) */
#endif
}
