#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	flushinp

#ifdef PDCDEBUG
char *rcsid_flushinp = "$Header: c:/curses/portable/RCS/flushinp.c%v 2.0 1992/11/15 03:28:52 MH Rel $";
#endif




/*man-start*********************************************************************

  flushinp()	- discard type-ahead

  X/Open Description:
 	Throws away any type-ahead that has been typed by the user and
 	has not yet been read by the program.

  PDCurses Description:
 	If the PDCurses library is compiled under DOS with the FAST_VIDEO
 	define true, then we will poke the BIOS keyboard buffer head and
 	tail pointers, resetting the typeahead.

 	If this is not true, then we will be unable to reliably flush
 	the typeahead.

  X/Open Return Value:
 	The flushinp() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int flushinp( void );
 	X/Open Dec '88	int flushinp( void );
 	BSD Curses	int flushinp( void );
 	SYS V Curses	int flushinp( void );

**man-end**********************************************************************/

int	flushinp(void)
{
extern int	c_pindex;		/* putter index */
extern int	c_gindex;		/* getter index */
extern int	c_ungind;		/* wungetch() push index */

#if defined(DOS) && defined(FAST_VIDEO)
	short  *KB_HEAD = (short *) _FAR_POINTER(0,0x41a); /* 40:1A  BIOS KB head  */
	short  *KB_TAIL = (short *) _FAR_POINTER(0,0x41c); /* 40:1C  BIOS KB tail  */
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("flushinp() - called\n");
#endif

#if defined(DOS) && defined(FAST_VIDEO)
	*KB_HEAD = *KB_TAIL;		/* Force the BIOS kbd buf	*/
					/* head/tail pointers to be the */
					/* same...  Real nasty trick... */
#endif

#ifdef OS2
	KbdFlushBuffer(0);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif

	c_gindex = 1;			/* set indices to kill buffer	 */
	c_pindex = 0;
	c_ungind = 0;			/* clear c_ungch array		 */
	return( OK );
}
