#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef	flash

#ifdef PDCDEBUG
char *rcsid_flash = "$Header: c:/curses/portable/RCS/flash.c%v 2.0 1992/11/15 03:28:52 MH Rel $";
#endif




/*man-start*********************************************************************

  flash()	- generate audio-visual alarm

  X/Open Description:
 	This routine is used to signal the terminal user.  The beep()
 	function will sound the audible bell on the terminal, if possible
 	and if not, will flash the screen (visible bell), if possible.
 	The flash() function will flash the screen, and if that is not
 	possible, will sound the audible signal.  If neither signal is
 	possible, nothing will happen.  Nearly all terminals have an
 	audible signal (bell or beep), but only some can flash the screen.

  X/Open Return Value:
 	The beep() and flash() functions return OK on success and ERR on
 	error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int flash( void );
 	X/Open Dec '88	int flash( void );
 	BSD Curses	int flash( void );
 	SYS V Curses	int flash( void );

**man-end**********************************************************************/

int	flash(void)
{
	extern unsigned char atrtab[MAX_ATRTAB];
	int	i;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("flash() - called\n");
#endif

#ifdef UNIX
	if (flash_screen != NULL)
		putp(flash_screen);
	return(OK);
#endif

	PDC_scroll(0, 0, LINES - 1, COLS - 1, 0, (chtype)(atrtab[264] << 8));
	delay_output( 50 );
	PDC_scroll(0, 0, LINES - 1, COLS - 1, 0, (chtype)(atrtab[265] << 8));
	wrefresh(curscr);
	return( OK );
}
