#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif

#undef	echo

#ifdef PDCDEBUG
char *rcsid_echo = "$Header: c:/curses/portable/RCS/echo.c%v 2.0 1992/11/15 03:28:50 MH Rel $";
#endif




/*man-start*********************************************************************

  echo()	- enable/disable terminal echo

  X/Open Description:
 	These functions control whether characters typed by the user
 	are echoed by the input routine.  Initially, input characters
 	are echoed.  Subsequent calls to echo() and noecho() do not
 	flush type-ahead.

  PDCurses Description:
 	No additional PDCurses functionality.

  X/Open Return Value:
 	The echo() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int echo( void );
 	X/Open Dec '88	int echo( void );
 	BSD Curses	int echo( void );
 	SYS V Curses	int echo( void );

**man-end**********************************************************************/

int	echo(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("echo() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	_CUR_TERM.prog_mode.c_lflag |= ECHOCTL|ECHOKE;
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#else
	_CUR_TERM.prog_mode.sg_flags |= ECHO;
	ioctl(_CUR_TERM.fd, TIOCSETP, &_CUR_TERM.prog_mode);
#endif
#endif

	_cursvar.echo = TRUE;
	return( OK );
}
