#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	delwin

#ifdef PDCDEBUG
char *rcsid_delwin = "$Header: c:/curses/portable/RCS/delwin.c%v 2.0 1992/11/15 03:29:17 MH Rel $";
#endif




/*man-start*********************************************************************

  delwin()	- delete window

  X/Open Description:
 	Deletes the named window, freeing all memory associated with it.
 	In the case of overlapping windows, subwindows should be deleted
 	before the main window.

  PDCurses Description:
 	This routine will also attempt to remove the passed window from
 	the visible window's list.  This is a list of windows that are
 	"visible" and will always be refreshed at the next doupdate()
 	call.

  X/Open Return Value:
 	The delwin() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int delwin( WINDOW* win );
 	X/Open Dec '88	int delwin( WINDOW* win );
 	BSD Curses	int delwin( WINDOW* win );
 	SYS V Curses	int delwin( WINDOW* win );
**man-end**********************************************************************/

int	delwin(WINDOW *win)
{
extern	void	(*fre)( void* );
	int	i;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("delwin() - called\n");
#endif


	if (win == (WINDOW *)NULL)
		return( ERR );

#ifdef	REGISTERWINDOWS
	_rmwin(win);		/* Remove from the visible windows list... */
#endif

	/*
	 * FYI:  Subwindow's use 'parent's' lines
	 */
	if (!(win->_flags & _SUBWIN))
	{
		for (i = 0; i < win->_pmaxy && win->_y[i]; i++)
		{
			if (win->_y[i] != NULL)
				(*fre)(win->_y[i]);
		}
	}
	(*fre)(win->_firstch);
	(*fre)(win->_lastch);
	(*fre)(win->_y);
	(*fre)(win);
	return( OK );
}
