#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	tabsize

#ifdef PDCDEBUG
char *rcsid_tabsize = "$Header: c:/curses/nonport/RCS/tabsize.c%v 2.0 1992/11/15 03:18:29 MH Rel $";
#endif




/*man-start*********************************************************************

  tabsize()	- Set tab size in window

  PDCurses Description:
 	This routine sets the tabsize for stdscr and returns the previous
 	tab size settings.

  PDCurses Return Value:
 	This routine returns the previous tab size setting upon success
 	otherwise, it returns ERR.

  PDCurses Errors:
 	It is an error to call this routine before initscr().

  Portability:
 	PDCurses	int tabsize( int ts );
 	X/Open Dec '88	
 	SysV Curses	
 	BSD Curses	

**man-end**********************************************************************/

int	tabsize(int ts)
{
	int	origval;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("tabsize() - called\n");
#endif

	if (stdscr == (WINDOW *)NULL)
		return( ERR );

	origval = stdscr->_tabsize;
	stdscr->_tabsize = ts;
	return( origval );
}
