#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	mvwinsert

#ifdef PDCDEBUG
char *rcsid_mvwinser = "$Header: c:/curses/nonport/RCS/mvwinser.c%v 2.0 1992/11/15 03:18:27 MH Rel $";
#endif




/*man-start*********************************************************************

  mvwinsert()	- Insert line

  PDCurses Description:
 	A blank line is inserted above the current line and the bottom
 	line is lost.

 	This routine is provided as an extension to the X/Open interface.

  PDCurses Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int mvwinsertln( WINDOW win, int y, int x );

**man-end**********************************************************************/

int	mvwinsertln(WINDOW *win, int y, int x)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("mvwinsertln() - called: y %d x %d\n",y,x);
#endif

	return( (wmove(win, y, x) == ERR) ? ERR : winsertln(win) );
}
