#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	cursoff

#ifdef PDCDEBUG
char *rcsid_cursoff = "$Header: c:/curses/nonport/RCS/cursoff.c%v 2.0 1992/11/15 03:18:26 MH Rel $";
#endif




/*man-start*********************************************************************

  cursoff()	- Turns off the hardware cursor.

  PDCurses Description:
 	Turns off the hardware curses, it does nothing if it is already off.

  PDCurses Return Value:
 	Returns OK upon success, ERR upon failure.

  PDCurses Errors:
 	ERR will be returned (in the case of FLEXOS) if the hardware cursor
 	can not be disabled.

  Portability:
 	PDCurses	int cursoff( void );

**man-end**********************************************************************/

int	cursoff(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("cursoff() - called\n");
#endif

#ifndef UNIX
	if	(_cursvar.visible_cursor)
	{
		_cursvar.visible_cursor = FALSE;
#ifdef     OS2
		PDC_set_cursor_mode(32, 33);	/* turn it off */
#else
		switch (_cursvar.adapter)
		{
		case _FLEXOS:
			PDC_set_cursor_mode(_cursvar.visible_cursor, 0);
			break;
		default:
			PDC_set_cursor_mode(32, 33);	/* turn it off */
			break;
		}
#endif
	}
#endif
	return( OK );
}
