#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	border

#ifdef PDCDEBUG
char *rcsid_border = "$Header: c:/curses/nonport/RCS/border.c%v 2.0 1992/11/15 03:18:25 MH Rel $";
#endif




/*man-start*********************************************************************

  border()	- sets the border characters in the stdscr window.

  PDCurses Description:
 	This routine sets the border characters for stdscr.

 	WARNING:
 		Don't make this a call to wborder() - it would
 		require too much stack for parameters.
 	
  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error for stdscr to be a NULL pointer.

  Portability:
 	PDCurses	int border( chtype l,  chtype r,  chtype t,  chtype b,
 				    chtype tl, chtype tr  chtype bl, chtype br );

**man-end**********************************************************************/

int	border(chtype l,chtype r,chtype t,chtype b,chtype tl,chtype tr,chtype bl,chtype br)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("border() - called\n");
#endif

	if (stdscr == (WINDOW *)NULL)
		return( ERR );

	return( wborder( stdscr, l, r, t, b, tl, tr, bl, br ) );
}
