package Game::Life::Fast;

use 5.008008;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Game::Life::Fast ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	is_alive 
	process 
	copy_grid
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.01';


# Preloaded methods go here.
use Inline C => 'DATA',
		   VERSION => '0.01',
		   NAME => 'Game::Life::Fast';
1;

__DATA__
__C__
int is_alive( char* grid, int x, int y, int width, char alive){
	if( x < 0 || y < 0 || grid == NULL) return 0;
	return grid[ x + y * width ] == alive;
}

int process( char* grid, int width, int height, char alive, char death){
	int x,y;
	char* old;
	int neighbors;
	old=(char*)malloc( width * height );
	memcpy( old, grid, width * height );
	if (!old) return 0;
	for(y=0;y<height;y++){
		for(x=0;x<width;x++){
			neighbors = is_alive(old, x-1, y-1, width, alive) + is_alive(old, x, y-1, width, alive) + is_alive(old, x+1, y-1, width, alive) 
				+ is_alive(old, x-1, y, width, alive) + is_alive(old, x + 1, y, width, alive) 
				+ is_alive(old, x-1, y+1, width, alive) + is_alive(old, x, y+1, width, alive) + is_alive(old, x+1, y+1, width, alive);
			if(is_alive(old, x, y, width, alive)){
				grid[x+y*width]= (neighbors==2||neighbors==3)?alive:death;
			}
			else{
				grid[x+y*width]=(neighbors == 3)?alive:death;
			}
		}
	}
	free(old);
	return 1;
}

int copy_grid( char* grid_src, int width_src, int height_src,
								char* grid_trg, int width_trg, int height_trg,
								int at_x, int at_y ){
	int x, y;
	int o_trg, o_src;
	//TODO: optimize by doing :  height_src * memcpy( &grid_trg[...], ..., width_src );
	for(y=0;y<height_src;y++){
		for(x=0;x<width_src;x++){
			o_trg = at_x + x + width_trg * ( at_y + y );
			o_src = x+y*width_src;
			if(o_trg>width_trg*height_trg || o_src>width_src*height_src){
				return 0;
			}
			grid_trg[ at_x + x + width_trg * ( at_y + y ) ] = grid_src[ x+y*width_src ];
		}
	}
	return 1;
}