use Test;
use DateTime::Julian :ALL;

plan 60;

my %jpl =
    # using test data from the JPL website:
    #     https://ssd.jpl.nasa.gov/tc.cgi

    '-4000-01-01T11:59:59.99Z' => [260423.9999999, 'Thursday'],
    '-4000-01-01T12:00:00.00Z' => [260424, 'Thursday'],
    '-4000-01-01T13:00:00.01Z' => [260424.0416668, 'Thursday'],
    '-4000-01-01T23:59:59.99Z' => [260424.4999999, 'Thursday'],
    '-4000-01-02T00:00:00.00Z' => [260424.5, 'Friday'],
    '-4000-01-01T00:00:00.01Z' => [260423.5000001, 'Thursday'],
    '-3000-01-01T11:59:59.99Z' => [625673.9999999, 'Monday'],
    '-3000-01-01T12:00:00.00Z' => [625674, 'Monday'],
    '-3000-01-01T13:00:00.01Z' => [625674.0416668, 'Monday'],
    '-3000-01-01T23:59:59.99Z' => [625674.4999999, 'Monday'],
    '-3000-01-02T00:00:00.00Z' => [625674.5, 'Tuesday'],
    '-3000-01-01T00:00:00.01Z' => [625673.5000001, 'Monday'],
    '-2000-01-01T11:59:59.99Z' => [990923.9999999, 'Friday'],
    '-2000-01-01T12:00:00.00Z' => [990924, 'Friday'],
    '-2000-01-01T13:00:00.01Z' => [990924.0416668, 'Friday'],
    '-2000-01-01T23:59:59.99Z' => [990924.4999999, 'Friday'],
    '-2000-01-02T00:00:00.00Z' => [990924.5, 'Saturday'],
    '-2000-01-01T00:00:00.01Z' => [990923.5000001, 'Friday'],
    '-1000-01-01T11:59:59.99Z' => [1356173.9999999, 'Tuesday'],
    '-1000-01-01T12:00:00.00Z' => [1356174, 'Tuesday'],
    '-1000-01-01T13:00:00.01Z' => [1356174.0416668, 'Tuesday'],
    '-1000-01-01T23:59:59.99Z' => [1356174.4999999, 'Tuesday'],
    '-1000-01-02T00:00:00.00Z' => [1356174.5, 'Wednesday'],
    '-1000-01-01T00:00:00.01Z' => [1356173.5000001, 'Tuesday'],
    '+0001-01-01T11:59:59.99Z' => [1721423.9999999, 'Saturday'],
    '+0001-01-01T12:00:00.00Z' => [1721424, 'Saturday'],
    '+0001-01-01T13:00:00.01Z' => [1721424.0416668, 'Saturday'],
    '+0001-01-01T23:59:59.99Z' => [1721424.4999999, 'Saturday'],
    '+0001-01-02T00:00:00.00Z' => [1721424.5, 'Sunday'],
    '+0001-01-01T00:00:00.01Z' => [1721423.5000001, 'Saturday'],
    '-0001-01-01T11:59:59.99Z' => [1721057.9999999, 'Thursday'],
    '-0001-01-01T12:00:00.00Z' => [1721058, 'Thursday'],
    '-0001-01-01T13:00:00.01Z' => [1721058.0416668, 'Thursday'],
    '-0001-01-01T23:59:59.99Z' => [1721058.4999999, 'Thursday'],
    '-0001-01-02T00:00:00.00Z' => [1721058.5, 'Friday'],
    '-0001-01-01T00:00:00.01Z' => [1721057.5000001, 'Thursday'],
    '+1000-01-01T11:59:59.99Z' => [2086307.9999999, 'Monday'],
    '+1000-01-01T12:00:00.00Z' => [2086308, 'Monday'],
    '+1000-01-01T13:00:00.01Z' => [2086308.0416668, 'Monday'],
    '+1000-01-01T23:59:59.99Z' => [2086308.4999999, 'Monday'],
    '+1000-01-02T00:00:00.00Z' => [2086308.5, 'Tuesday'],
    '+1000-01-01T00:00:00.01Z' => [2086307.5000001, 'Monday'],
    '+2000-01-01T11:59:59.99Z' => [2451544.9999999, 'Saturday'],
    '+2000-01-01T12:00:00.00Z' => [2451545, 'Saturday'],
    '+2000-01-01T13:00:00.01Z' => [2451545.0416668, 'Saturday'],
    '+2000-01-01T23:59:59.99Z' => [2451545.4999999, 'Saturday'],
    '+2000-01-02T00:00:00.00Z' => [2451545.5, 'Sunday'],
    '+2000-01-01T00:00:00.01Z' => [2451544.5000001, 'Saturday'],
    '+3000-01-01T11:59:59.99Z' => [2816787.9999999, 'Wednesday'],
    '+3000-01-01T12:00:00.00Z' => [2816788, 'Wednesday'],
    '+3000-01-01T13:00:00.01Z' => [2816788.0416668, 'Wednesday'],
    '+3000-01-01T23:59:59.99Z' => [2816788.4999999, 'Wednesday'],
    '+3000-01-02T00:00:00.00Z' => [2816788.5, 'Thursday'],
    '+3000-01-01T00:00:00.01Z' => [2816787.5000001, 'Wednesday'],
    '+4000-01-01T11:59:59.99Z' => [3182029.9999999, 'Saturday'],
    '+4000-01-01T12:00:00.00Z' => [3182030, 'Saturday'],
    '+4000-01-01T13:00:00.01Z' => [3182030.0416668, 'Saturday'],
    '+4000-01-01T23:59:59.99Z' => [3182030.4999999, 'Saturday'],
    '+4000-01-02T00:00:00.00Z' => [3182030.5, 'Sunday'],
    '+4000-01-01T00:00:00.01Z' => [3182029.5000001, 'Saturday'],
;

for %jpl.keys.sort -> $ut {
    # with key and value JPL test data:
    my $jd  = %jpl{$ut}[0];
    my $dow = %jpl{$ut}[1];

    my $ut-dt = DateTime::Julian.new: $ut;
    my $jd-dt = DateTime::Julian.new: :juliandate($jd);
    is $ut-dt, $jd-ut;
}

