#!perl -T
use Lingua::HU::Numbers qw/num2hu/;
use Test::More tests => 31;

## integers [1-12]
is (num2hu(0), "nulla");
is (num2hu(12), "tizenkett");
is (num2hu(100), "szz");
is (num2hu(1000), "ezer");
is (num2hu(1999), "ezerkilencszzkilencvenkilenc");
is (num2hu(2001), "kettezer-egy");
is (num2hu(2110), "kettezer-egyszztz");
is (num2hu(5000), "tezer");
is (num2hu(123000),"szzhuszonhromezer");
is (num2hu(1000000),"egymilli");
is (num2hu(1001000), "egymilli-ezer");
is (num2hu('999000000000000000000000000000000000000000000000000000000000000'),
	"kilencszzkilencvenkilenc decilli");

## -+ signs [13-18]
is (num2hu('-1100'), "mnusz ezeregyszz");
is (num2hu('-21000'), "mnusz huszonegyezer");
is (num2hu('+1111'), "ezeregyszztizenegy");
is (num2hu('+23000'), "huszonhromezer");
is (num2hu('-0'), "nulla");
is (num2hu('+0'), "nulla");

## real numbers [19-25]

is (num2hu('1.5'), "egy egsz t tized");
is (num2hu('2001.2005'), "kettezer-egy egsz kettezer-t tzezred");
is (num2hu('11.10'), "tizenegy egsz egy tized");
is (num2hu('20.101'), "hsz egsz szzegy ezred");
is (num2hu('120.000'), "szzhsz");
is (num2hu('99.010'), "kilencvenkilenc egsz egy szzad");
is (num2hu('0.0101'), "nulla egsz szzegy tzezred");

## combined cases [26-27]
is (num2hu('+0.0'), "nulla");
is (num2hu('-0.010'),"mnusz nulla egsz egy szzad");

## formatting errors [28-31]

ok (! eval("num2hu('0.')") && $@);
ok (! eval("num2hu('0,')") && $@);
ok (! eval("num2hu('text')") && $@);
ok (! eval('$_="1" x 67;num2hu($_)') && $@);
