use Config;
use XS::Install;

my %params = (
    NAME          => 'Test::Catch',
    VERSION_FROM  => 'lib/Test/Catch.pm',
    ABSTRACT_FROM => 'lib/Test/Catch.pod',
    BIN_DEPS      => 'CPP::catch',
    BIN_SHARE     => {PASSTHROUGH => 'CPP::catch'},
    CPLUS         => 11,
    CCFLAGS       => '-Wall -Wextra',
    test          => {SRC => 't'},
);

eval {
    write_makefile(%params);
    1;
} or do {
    if ($@ =~ /this module wants 'CPP::catch' as a binary dependence/) {
        warn "debugging binary dependence missing";
        for my $inc (@INC) {
            warn "checking $inc";
            my $d = "$inc/CPP";
            next unless -d $d;
            warn join(" ", glob("$d/*"));
            $d = "$d/catch.x";
            next unless -d $d;
            warn "has $d";
            warn join(" ", glob("$d/*"));
            warn join(" ", glob("$d/*/*"));
        }
    }
    die $@;
}
