package Google::Ads::AdWords::v201605::ExtensionSetting;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201605' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %extensions_of :ATTR(:get<extensions>);
my %platformRestrictions_of :ATTR(:get<platformRestrictions>);

__PACKAGE__->_factory(
    [ qw(        extensions
        platformRestrictions

    ) ],
    {
        'extensions' => \%extensions_of,
        'platformRestrictions' => \%platformRestrictions_of,
    },
    {
        'extensions' => 'Google::Ads::AdWords::v201605::ExtensionFeedItem',
        'platformRestrictions' => 'Google::Ads::AdWords::v201605::ExtensionSetting::Platform',
    },
    {

        'extensions' => 'extensions',
        'platformRestrictions' => 'platformRestrictions',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201605::ExtensionSetting

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ExtensionSetting from the namespace https://adwords.google.com/api/adwords/cm/v201605.

A setting specifying when and which extensions should serve at a given level (customer, campaign, or ad group). 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * extensions


=item * platformRestrictions




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

