package CIF::Client::Plugin::Bindzone;
use CIF::Client::Support qw(confor);

sub type { return 'output'; }

my $default_output = '/etc/namedb/';

sub write_out {
    my $self = shift;
    my $config = shift;
    my $feed = shift;
    my @array = @{$feed->{'feed'}->{'entry'}};
    
    my @config_search_path = ('claoverride', $feed->{'query'}, 'client' );
    my $cfg_bindzone_path = confor($config, \@config_search_path, 'bindzone_path', undef);
   
    my $query = $feed->{'query'};
    $query =~ s/\//_/g;

    if($cfg_bindzone_path){
        $default_output = $cfg_bindzone_path;
    }

    $query = 'cif_'.$query.'.zone'; 
    $default_output .= '/'.$query;
    $default_output =~ s/\/\//\//g;

    my $text = '// generated by: '.$0." at ".time()."\n";
    foreach (@array){
        $text .= 'zone "'.$_->{'address'}.'" {type master; file "'.$default_output.'";};'."\n";
    }
    return $text;
}
1;
