#!/usr/bin/perl -w

# $Id: 200idle.t,v 1.1 2001/02/20 16:22:23 rich Exp $

use strict;
use Test;
use POSIX qw(dup2);
use IO::Handle;

BEGIN {
  plan tests => 4;
}

use Net::FTPServer::InMem::Server;

pipe INFD0, OUTFD0 or die "pipe: $!";
pipe INFD1, OUTFD1 or die "pipe: $!";
my $pid = fork ();
die unless defined $pid;
unless ($pid) {			# Child process (the server).
  POSIX::dup2 (fileno INFD0, 0);
  POSIX::dup2 (fileno OUTFD1, 1);
  close INFD0;
  close OUTFD0;
  close INFD1;
  close OUTFD1;
  my $ftps = Net::FTPServer::InMem::Server->run
    (['--test', '-d', '-C', '/dev/null']);
  exit;
}

# Parent process (the test script).
close INFD0;
close OUTFD1;
OUTFD0->autoflush (1);

$_ = <INFD1>;
print OUTFD0 "USER rich\r\n";
$_ = <INFD1>;
ok (/^331/);

print OUTFD0 "PASS 123456\r\n";
$_ = <INFD1>;
ok (/^230 Welcome rich\./);

# Set the idle timeout to 2 seconds and wait.
print OUTFD0 "SITE IDLE 2\r\n";
$_ = <INFD1>;
ok (/^200/);

sleep 3;

# Expect timeout status.
$_ = <INFD1>;
ok (/^421/);
