#!/usr/bin/perl
#

use strict;
use warnings;
use IO::File;
use Test::More tests => 27;

use Net::DNS::Resolver::Unbound;


ok( Net::DNS::Resolver::Unbound->string(), 'default configuration' );

my $recursive = Net::DNS::Resolver::Unbound->new( nameservers => [] );
ok( $recursive, 'create fully recursive resolver instance' );
is( scalar( $recursive->nameservers ), 0, 'empty nameserver list' );

my $resolver = Net::DNS::Resolver::Unbound->new( debug_level => 0, prefer_v4 => 1 );
ok( $resolver, 'create stub resolver instance' );


my $option = 'outgoing-port-avoid';
my $value  = '3200-3202';
my $return = $resolver->option( $option, $value );
is( $return, undef, "resolver->option( $option, $value )" );
my $single = $resolver->option($option);
is( $single, $value, 'single-valued resolver option' );

$resolver->option( $option, '3203-3205' );
$resolver->option( $option, '3206-3208' );
my @multi = $resolver->option($option);
is( scalar(@multi), 3, 'multi-valued resolver option' );

my $bogus = $resolver->option('bogus');
is( $bogus, undef, 'nonexistent resolver option' );

ok( $resolver->string(), '$resolver->string' );


my $filename = "file$$";

END {
	unlink $filename;
}
close( IO::File->new( $filename, '>' ) or die "Can't touch $filename $!" );


## exercise context methods
ok eval { $resolver->option( 'verbosity',		 undef ); 1 };
ok eval { $resolver->option( 'outgoing-port-avoid', '3200-3208' ); 1 };
ok eval { $resolver->config($filename); 1 };
ok eval { $resolver->set_fwd('::1'); 1 };
ok eval { $resolver->set_fwd('127.0.0.1'); 1 };
ok eval { $resolver->set_fwd('127.0.0.53'); 1 };
ok eval { $resolver->set_tls(0); 1 };
ok eval { $resolver->set_stub( 'zone', '10.1.2.3', 0 ); 1 };
ok eval { $resolver->resolv_conf($filename); 1 };
ok eval { $resolver->hosts($filename); 1 };
ok eval { $resolver->add_ta('zone DS'); 1 };
ok eval { $resolver->add_ta_file($filename); 1 };
ok eval { $resolver->add_ta_autr($filename); 1 };
ok eval { $resolver->trusted_keys($filename); 1 };
ok eval { $resolver->debug_out($filename); 1 };
ok eval { $resolver->debug_level(1); 1 };
ok eval { $resolver->async_thread(1); 1 };

ok( $resolver->string(), 'context rebuilt' );

exit;

