use utf8;

package SemanticWeb::Schema::HyperToc;

# ABSTRACT: A HyperToc represents a hypertext table of contents for complex media objects

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'HyperToc';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v22.0.0';


has associated_media => (
    is        => 'rw',
    predicate => '_has_associated_media',
    json_ld   => 'associatedMedia',
);



has toc_entry => (
    is        => 'rw',
    predicate => '_has_toc_entry',
    json_ld   => 'tocEntry',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::HyperToc - A HyperToc represents a hypertext table of contents for complex media objects

=head1 VERSION

version v22.0.0

=head1 DESCRIPTION

A HyperToc represents a hypertext table of contents for complex media objects, such as L<SemanticWeb::Schema::VideoObject>, L<SemanticWeb::Schema::AudioObject>. Items in the table of contents are indicated using the [[tocEntry]] property, and typed L<SemanticWeb::Schema::HyperTocEntry>. For cases where the same larger work is split into multiple files, [[associatedMedia]] can be used on individual L<SemanticWeb::Schema::HyperTocEntry> items.

=head1 ATTRIBUTES

=head2 C<associated_media>

C<associatedMedia>

A media object that encodes this CreativeWork. This property is a synonym
for encoding.

A associated_media should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::MediaObject']>

=back

=head2 C<_has_associated_media>

A predicate for the L</associated_media> attribute.

=head2 C<toc_entry>

C<tocEntry>

Indicates a L<SemanticWeb::Schema::HyperTocEntry> in a L<SemanticWeb::Schema::HyperToc>.

A toc_entry should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::HyperTocEntry']>

=back

=head2 C<_has_toc_entry>

A predicate for the L</toc_entry> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
