#!/usr/bin/perl

use strict;

use Graphics::Framebuffer;
use Time::HiRes qw(sleep);

my $joined = join('',@ARGV);
my $wait = .75;
$wait = $joined =~ /(\d++)/ if (scalar(@ARGV));
my $dump = 0;
$dump = 1 if ($joined =~ /dump/i);
$wait = 0 if ($joined =~ /wait/i);

my $fb = Graphics::Framebuffer->new('SPLASH' => 1,'SHOW_ERRORS'=>1); # ,'SIMULATED_X'=>1280,'SIMULATED_Y'=>720);

$SIG{'INT'} = sub { $fb->cls('ON'); exit(0); };

my $adj = $fb->{'XRES'} / 1920;

$fb->cls('OFF');
# $fb->or_mode();

foreach my $font (sort(keys %{$fb->{'FONTS'}})) {
    unless ($dump) {
        $fb->cls();
        my $tprint = {
            'bounding_box' => 1,
            'face'         => $fb->{'FONTS'}->{$font}->{'font'},
            'center'       => 3,
            'text'         => $font,
            'font_path'    => $fb->{'FONTS'}->{$font}->{'path'},
            'color'        => 'FFFFFFFF',
            'height'       => 150 * $adj,
            'antialias'    => 1
        };
        my $smprint = {
            'bounding_box' => 1,
            'text'         => $font,
            'color'        => '99FF99FF',
            'height'       => 72 * $adj,
            'y'            => 76 * $adj,
            'antialias'    => 1
        };
        $fb->ttf_print(
            $fb->ttf_print($tprint)
        );
        $fb->ttf_print(
            $fb->ttf_print($smprint)
        );
        if ($wait) {
            sleep $wait;
        } else {
            <>;
        }
    } else {
        print STDOUT "$font\n";
    }
}

$fb->cls('ON');

=head1 NAME

Available Fonts Display

=head1 DESCRIPTION

This displays (in the actual font) all of the system fonts the Graphics::Framebuffer module could find.

=head1 SYNOPSIS

 perl fonts.pl [wait time] [dump]

=head2 Example

=over 4

 perl fonts 0.75

=back

=head1 OPTIONS

=over 2

=item B<wait time> (a decimal number)

Tells the script to wait "wait time" seconds before showing the next font.  This can be fractions of a second.  The default is "0.5" seconds.

=item B<dump>

Tells the script to dump a list of the font names to STDOUT.

=back

=cut
