#!/usr/bin/perl

use strict;

use Graphics::Framebuffer;
use Time::HiRes qw(sleep);

my $fb = Graphics::Framebuffer->new('SPLASH' => 1,'SHOW_ERRORS'=>1);

my $adj = 1920 / $fb->{'VXRES'};

$fb->cls();

foreach my $font (sort(keys %{$fb->{'FONTS'}})) {
    $fb->cls();
    my $tprint = {
        'bounding_box' => 1,
        'face'         => $fb->{'FONTS'}->{$font}->{'font'},
        'center'       => 3,
        'text'         => $font,
        'font_path'    => $fb->{'FONTS'}->{$font}->{'path'},
        'color'        => 'FFFFFFFF',
        'height'       => 150 * $adj
    };
    $fb->ttf_print(
        $fb->ttf_print($tprint)
    );
    sleep .5;
}

