 use strict;
 use Statistics::ANOVA 0.061;
 my $varo = Statistics::ANOVA->new();

 # Some data:
 my @gp1 = (qw/8 7 11 14 9/);
 my @gp2 = (qw/11 9 8 11 13/);
 my @gp3 = (qw/7 13 12 8 10/);

 # Load the data, names can be arbitrary
 $varo->load_data({gp1 => \@gp1, gp2 => \@gp2});
 # Oh, forgot one:
 $varo->add_data(gp3 => \@gp3);

 # If they are independent data, test equality of variances, difference between them, and means:
 $varo->obrien_test()->dump(title => 'O\'Brien\'s test of equality of variances');
 $varo->levene_test()->dump(title => 'Levene\'s test of equality of variances');
 $varo->anova_indep()->dump(title => 'Independent groups ANOVA', table => 1, string => 1, precision_s => 3, precision_p => 4, eta_squared => 1, omega_squared => 1);
 $varo->comparisons_indep();

 # or if they are repeated measures:
 $varo->anova_dep()->dump(title => 'Dependent groups ANOVA');
 $varo->comparisons_dep();
 # or:
 $varo->anova_friedman()->dump(title => 'Friedman test');
 # or:
 $varo->anova_friedman(f_equiv => 1)->dump(title => 'Friedman test (F equiv)');
 
 __END__

##Should print out this:
O'Brien's test of equality of variances
F(2, 12) = 0.386, p = 0.687770018342956
Levene's test of equality of variances
F(2, 12) = 0.389, p = 0.686116469325902
Independent groups ANOVA
	Df	Sum Sq	Mean Sq	F value	Pr(>F)
Factor	2	0.933	0.467	0.078	0.9256
Error	12	72.000	6.000	
F(2, 12) = 0.078, p = 0.9256, eta^2 = 0.013, omega^2 = -0.140
gp2 - gp1: t(7.17482707174827) = 0.395628284037472 2-p = 0.70416
gp2 - gp3: t(7.48562356676663) = 0.278693205716647 2-p = 0.78854
gp1 - gp3: t(7.94327358676384) = 0.118678165819385 2-p = 0.90886
Adjusted alpha = 0.0166666666666667
Dependent groups ANOVA
F(2, 8) = 0.060, p = 0.941743285288526
gp2 - gp1: t(4) = 0.399114063142644, 2-p = 0.7102
gp2 - gp3: t(4) = 0.221539510248685, 2-p = 0.83552
gp1 - gp3: t(4) = -0.103417537999004, 2-p = 0.9226
Adjusted alpha = 0.0166666666666667
Friedman test
chi^2(3) = 0.400, p = 0.81873075307798
Friedman test (F equiv)
F(2, 8) = 0.167, p = 0.849346559999998
